/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet;

import java.nio.ByteOrder;
import org.jnetpcap.JBufferHandler;
import org.jnetpcap.PcapHeader;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.packet.JPcapRecordIterable;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.PcapPacketHandler;

public class JPcapRecordBuffer
extends JBuffer
implements JPcapRecordIterable {
    private final int start = 4;
    private int limit;
    private int position = 4;
    private final int capacity;
    private int count = 0;
    private Record[] records;
    final PcapHeader header = new PcapHeader(JMemory.POINTER);
    final JBuffer pkt_buf = new JBuffer(JMemory.POINTER);
    final PcapPacket packet = new PcapPacket(JMemory.POINTER);

    public JPcapRecordBuffer(int n) {
        super(n);
        this.limit = this.capacity = n;
        this.order(ByteOrder.nativeOrder());
    }

    public int getPacketRecordCount() {
        return this.count;
    }

    private void setPacketRecordCount(int n) {
        super.setUInt(0, n);
        this.count = n;
    }

    public void append(PcapHeader pcapHeader, JBuffer jBuffer) {
        pcapHeader.transferTo(this, this.position);
        this.position += PcapHeader.sizeof();
        jBuffer.transferTo(this, 0, jBuffer.size(), this.position);
        this.position += jBuffer.size();
        ++this.count;
    }

    public void close() {
        this.limit = this.position;
        this.position = 4;
        this.setInt(0, this.count);
        JBuffer jBuffer = new JBuffer(this.limit);
        jBuffer.order(ByteOrder.nativeOrder());
        this.transferTo(jBuffer, 0, this.limit, 0);
        this.setSize(this.limit);
        this.records = new Record[this.count];
        Iterator iterator = this.iterator();
        for (int i = 0; i < this.count && iterator.hasNext(); ++i) {
            this.records[i] = new Record();
            this.records[i].header = new PcapHeader(JMemory.POINTER);
            this.records[i].packet = new JBuffer(JMemory.POINTER);
            iterator.next(this.records[i].header, this.records[i].packet);
        }
    }

    @Override
    public Iterator iterator() {
        return new Iterator();
    }

    public String toString() {
        return "packets = " + this.count;
    }

    public <T> long dispatchToJBuffeHandler(JBufferHandler<T> jBufferHandler, T t) {
        for (Record record : this) {
            jBufferHandler.nextPacket(record.header, record.packet, t);
        }
        return this.getPacketRecordCount();
    }

    public <T> long dispatchToPcapPacketHandler(PcapPacketHandler<T> pcapPacketHandler, T t) {
        for (Record record : this) {
            this.packet.transferHeaderAndDataFrom(record.header, record.packet);
            this.packet.scan(1);
            pcapPacketHandler.nextPacket(this.packet, t);
        }
        return this.getPacketRecordCount();
    }

    public class Iterator
    implements java.util.Iterator<Record> {
        private int offset = 4;
        private int index = 0;
        final int PCAP_HEADER_SIZEOF = PcapHeader.sizeof();

        @Override
        public boolean hasNext() {
            return this.index < JPcapRecordBuffer.this.count;
        }

        @Override
        public Record next() {
            return JPcapRecordBuffer.this.records[this.index++];
        }

        public void next(PcapHeader pcapHeader, JBuffer jBuffer) {
            this.offset += pcapHeader.peerTo(JPcapRecordBuffer.this, this.offset);
            this.offset += jBuffer.peer(JPcapRecordBuffer.this, this.offset, pcapHeader.caplen());
            ++this.index;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("optional method not implemented");
        }

        public void reset() {
            this.offset = 4;
            this.index = 0;
        }

        public long getPacketRecordCount() {
            return JPcapRecordBuffer.this.count;
        }
    }

    public static class Record {
        public PcapHeader header;
        public JBuffer packet;
    }
}

