/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import org.jnetpcap.JCaptureHeader;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.nio.JMemoryPool;
import org.jnetpcap.nio.JStruct;
import org.jnetpcap.packet.JFlowKey;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JHeaderAccessor;
import org.jnetpcap.packet.JHeaderChecksum;
import org.jnetpcap.packet.JHeaderPool;
import org.jnetpcap.packet.JScanner;
import org.jnetpcap.packet.PeeringException;
import org.jnetpcap.packet.format.FormatUtils;
import org.jnetpcap.packet.format.JFormatter;
import org.jnetpcap.packet.format.TextFormatter;
import org.jnetpcap.protocol.JProtocol;
import org.jnetpcap.util.JThreadLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JPacket
extends JBuffer
implements JHeaderAccessor,
Iterable<JHeader> {
    public static final int DEFAULT_STATE_HEADER_COUNT = 20;
    protected static JThreadLocal<JScanner> defaultScanner;
    private static JHeaderPool headerPool;
    private static JFormatter out;
    private static ThreadLocal<TextFormatter> formatterPool;
    protected static JMemoryPool pool;
    protected final JBuffer memory = new JBuffer(JMemory.Type.POINTER);
    protected final State state = new State(JMemory.Type.POINTER);

    public static JHeaderPool getDefaultHeaderPool() {
        return headerPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JScanner getDefaultScanner() {
        if (defaultScanner != null) return (JScanner)defaultScanner.get();
        Class<JScanner> clazz = JScanner.class;
        synchronized (JScanner.class) {
            if (defaultScanner != null) return (JScanner)defaultScanner.get();
            defaultScanner = new JThreadLocal<JScanner>(JScanner.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return (JScanner)defaultScanner.get();
        }
    }

    public static JFormatter getFormatter() {
        return out;
    }

    public static JMemoryPool getMemoryPool() {
        return pool;
    }

    public static void setDefaultHeaderPool(JHeaderPool jHeaderPool) {
        headerPool = jHeaderPool;
    }

    public static void setFormatter(JFormatter jFormatter) {
        out = jFormatter;
    }

    public static void setMemoryPool(JMemoryPool jMemoryPool) {
        pool = jMemoryPool;
    }

    public static void shutdown() {
        defaultScanner = null;
        pool = null;
    }

    public JPacket(int n, int n2) {
        super(JMemory.Type.POINTER);
        this.order(ByteOrder.BIG_ENDIAN);
        this.allocate(n + n2);
    }

    public JPacket(JMemory.Type type) {
        super(type);
        this.order(ByteOrder.BIG_ENDIAN);
    }

    public void allocate(int n) {
        pool.allocate(n, this.memory);
    }

    public <T> Iterable<T> filterByType(final Class<T> clazz) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return JPacket.this.iterator(clazz);
            }
        };
    }

    public int getAllocatedMemorySize() {
        if (!this.memory.isInitialized()) {
            return 0;
        }
        return this.memory.size();
    }

    public abstract JCaptureHeader getCaptureHeader();

    public JFlowKey getFlowKey() {
        return this.state.getFlowKey();
    }

    public JFlowKey getFlowKey(JFlowKey jFlowKey) {
        jFlowKey.peer(this.state);
        return jFlowKey;
    }

    public long getFrameNumber() {
        return this.state.getFrameNumber() + 1L;
    }

    @Override
    public <T extends JHeader> T getHeader(T t) {
        return this.getHeader(t, 0);
    }

    @Override
    public <T extends JHeader> T getHeader(T t, int n) {
        this.check();
        int n2 = t.getId();
        if (!this.hasHeader(n2)) {
            return null;
        }
        int n3 = this.state.findHeaderIndex(n2, n);
        if (n3 == -1) {
            return null;
        }
        return this.getHeaderByIndex(n3, t);
    }

    @Override
    public <T extends JHeader> T getHeaderByIndex(int n, T t) throws IndexOutOfBoundsException {
        int n2 = t.getId();
        if (!this.hasHeader(n2)) {
            return null;
        }
        JHeader.State state = t.getState();
        this.state.peerHeaderByIndex(n, state);
        int n3 = state.getOffset();
        int n4 = state.getLength();
        t.peer(this, n3, n4);
        t.setPacket(this);
        t.setIndex(n);
        t.decode();
        return t;
    }

    @Override
    public int getHeaderCount() {
        return this.state.getHeaderCount();
    }

    @Override
    public int getHeaderIdByIndex(int n) {
        return this.state.getHeaderIdByIndex(n);
    }

    @Override
    public int getHeaderInstanceCount(int n) {
        return this.state.getInstanceCount(n);
    }

    protected JBuffer getMemoryBuffer(byte[] byArray) {
        pool.allocate(byArray.length, this.memory);
        this.memory.transferFrom(byArray);
        return this.memory;
    }

    protected JBuffer getMemoryBuffer(ByteBuffer byteBuffer) throws PeeringException {
        this.memory.peer(byteBuffer);
        return this.memory;
    }

    protected JBuffer getMemoryBuffer(int n) {
        if (!this.memory.isInitialized() || this.memory.size() < n) {
            this.allocate(n);
        }
        return this.memory;
    }

    protected JBuffer getMemoryBuffer(JBuffer jBuffer) {
        this.memory.peer(jBuffer);
        return this.memory;
    }

    public int getPacketWirelen() {
        return this.getCaptureHeader().wirelen();
    }

    @Deprecated
    public JScanner getScanner() {
        return (JScanner)defaultScanner.get();
    }

    public State getState() {
        return this.state;
    }

    public abstract int getTotalSize();

    public boolean hasAllHeaders(long l) {
        long l2 = this.state.get64BitHeaderMap(JProtocol.maskToGroup(l));
        return (l2 & l) == l;
    }

    public boolean hasAnyHeader(long l) {
        long l2 = this.state.get64BitHeaderMap(JProtocol.maskToGroup(l));
        return (l2 & l & 0xFFFFFFFFL) != 0L && (l2 & 0xFFFFFFFF00000000L) == (l & 0xFFFFFFFF00000000L);
    }

    @Override
    public boolean hasHeader(int n) {
        long l;
        long l2 = this.state.get64BitHeaderMap(JProtocol.idToGroup(n));
        return (l2 & (l = JProtocol.idToMask(n))) != 0L;
    }

    @Override
    public boolean hasHeader(int n, int n2) {
        this.check();
        int n3 = this.state.findHeaderIndex(n, n2);
        return n3 != -1;
    }

    @Override
    public <T extends JHeader> boolean hasHeader(T t) {
        return this.getHeader(t, 0) != null;
    }

    @Override
    public <T extends JHeader> boolean hasHeader(T t, int n) {
        this.check();
        int n2 = t.getId();
        if (!this.hasHeader(n2)) {
            return false;
        }
        int n3 = this.state.findHeaderIndex(n2, n);
        if (n3 == -1) {
            return false;
        }
        this.getHeaderByIndex(n3, t);
        return true;
    }

    @Override
    public Iterator<JHeader> iterator() {
        final int n = this.state.getHeaderCount();
        return new Iterator<JHeader>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < n;
            }

            @Override
            public JHeader next() {
                if (this.i >= n) {
                    throw new IllegalStateException("must first call hasNext");
                }
                int n2 = JPacket.this.getHeaderIdByIndex(this.i++);
                JHeader jHeader = headerPool.getHeader(n2);
                return JPacket.this.getHeader(jHeader);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public <T> Iterator<T> iterator(final Class<T> clazz) {
        final int n = this.state.getHeaderCount();
        return new Iterator<T>(){
            JHeader header;
            int i = 0;

            private void advance() {
                while (this.i < n) {
                    int n2 = JPacket.this.getHeaderIdByIndex(this.i);
                    this.header = headerPool.getHeader(n2);
                    if (clazz.isInstance(this.header)) break;
                    ++this.i;
                }
            }

            @Override
            public boolean hasNext() {
                this.advance();
                return this.i < n;
            }

            @Override
            public T next() {
                if (this.header == null) {
                    throw new IllegalStateException("must first call hasNext");
                }
                ++this.i;
                return JPacket.this.getHeader(this.header);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void recalculateAllChecksums() {
        for (JHeaderChecksum jHeaderChecksum : this.filterByType(JHeaderChecksum.class)) {
            jHeaderChecksum.recalculateChecksum();
        }
    }

    public int remaining(int n) {
        return this.size() - n;
    }

    public int remaining(int n, int n2) {
        int n3 = this.size() - n;
        return n3 >= n2 ? n2 : n3;
    }

    public void scan(int n) {
        JPacket.getDefaultScanner().scan(this, n, this.getCaptureHeader().wirelen());
    }

    @Override
    public String toHexdump() {
        if (this.state.isInitialized()) {
            return FormatUtils.hexdump(this);
        }
        byte[] byArray = this.getByteArray(0, this.size());
        return FormatUtils.hexdump(byArray);
    }

    public String toString() {
        TextFormatter textFormatter = formatterPool.get();
        textFormatter.reset();
        try {
            textFormatter.format(this);
            return textFormatter.toString();
        }
        catch (Exception exception) {
            throw new RuntimeException(textFormatter.toString(), exception);
        }
    }

    static {
        headerPool = new JHeaderPool();
        out = new TextFormatter(new StringBuilder());
        formatterPool = new ThreadLocal<TextFormatter>(){

            @Override
            protected TextFormatter initialValue() {
                return new TextFormatter(new StringBuilder());
            }
        };
        pool = new JMemoryPool();
    }

    public static class State
    extends JStruct {
        public static final int FLAG_TRUNCATED = 1;
        public static final String STRUCT_NAME = "packet_state_t";
        private JFlowKey flowKey;

        public static native int sizeof(int var0);

        public State(int n) {
            super(STRUCT_NAME, n);
        }

        public State(JMemory.Type type) {
            super(STRUCT_NAME, type);
        }

        public void cleanup() {
            super.cleanup();
        }

        public int findHeaderIndex(int n) {
            return this.findHeaderIndex(n, 0);
        }

        public native int findHeaderIndex(int var1, int var2);

        public native long get64BitHeaderMap(int var1);

        public native int getFlags();

        public JFlowKey getFlowKey() {
            if (this.flowKey == null) {
                this.flowKey = new JFlowKey();
            }
            this.peerFlowKey();
            return this.flowKey;
        }

        public native long getFrameNumber();

        public native int getHeaderCount();

        public native int getHeaderIdByIndex(int var1);

        public native int getHeaderLengthByIndex(int var1);

        public native int getHeaderOffsetByIndex(int var1);

        public native int getInstanceCount(int var1);

        public native int getWirelen();

        public int peer(ByteBuffer byteBuffer) throws PeeringException {
            int n = super.peer(byteBuffer);
            this.peerFlowKey();
            return n;
        }

        public int peer(JBuffer jBuffer) {
            int n = super.peer(jBuffer, 0, this.size());
            this.peerFlowKey();
            return n;
        }

        public int peer(JBuffer jBuffer, int n, int n2) throws IndexOutOfBoundsException {
            int n3 = super.peer(jBuffer, n, n2);
            this.peerFlowKey();
            return n3;
        }

        public int peer(JMemory jMemory, int n) {
            int n2 = super.peer(jMemory, n, this.size());
            this.peerFlowKey();
            return n2;
        }

        public int peer(JMemoryPool.Block block, int n, int n2) throws IndexOutOfBoundsException {
            int n3 = super.peer(block, n, n2);
            this.peerFlowKey();
            return n3;
        }

        public int peer(State state) {
            int n = super.peer(state, 0, this.size());
            this.peerFlowKey();
            return n;
        }

        private void peerFlowKey() {
            if (this.flowKey != null) {
                this.flowKey.peer(this);
            }
        }

        public native int peerHeaderById(int var1, int var2, JHeader.State var3);

        public native int peerHeaderByIndex(int var1, JHeader.State var2) throws IndexOutOfBoundsException;

        public int peerTo(JBuffer jBuffer, int n) {
            int n2 = super.peer(jBuffer, n, this.size());
            this.peerFlowKey();
            return n2;
        }

        public int peerTo(JBuffer jBuffer, int n, int n2) {
            int n3 = super.peer(jBuffer, n, n2);
            this.peerFlowKey();
            return n3;
        }

        public int peerTo(State state, int n) {
            int n2 = super.peer(state, n, state.size());
            this.peerFlowKey();
            return n2;
        }

        public native void setFlags(int var1);

        public native void setWirelen(int var1);

        public String toDebugString() {
            return super.toDebugString() + "\n" + this.toDebugStringJPacketState();
        }

        private native String toDebugStringJPacketState();

        public int transferTo(byte[] byArray, int n) {
            return super.transferTo(byArray, 0, this.size(), n);
        }

        public int transferTo(byte[] byArray, int n, int n2, int n3) {
            return super.transferTo(byArray, n, this.size(), n3);
        }

        public int transferTo(JBuffer jBuffer, int n, int n2, int n3) {
            return super.transferTo(jBuffer, n, this.size(), n3);
        }

        public int transferTo(State state) {
            return super.transferTo(state, 0, this.size(), 0);
        }
    }
}

