/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jnetpcap.packet.JFlowKey;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.format.FormatUtils;
import org.jnetpcap.protocol.lan.Ethernet;
import org.jnetpcap.protocol.network.Ip4;
import org.jnetpcap.protocol.tcpip.Tcp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFlow {
    private final JFlowKey key;
    private final boolean reversable;
    private final List<JPacket> all;
    private final List<JPacket> forward;
    private final List<JPacket> reverse;
    private final Tcp tcp = new Tcp();
    private final Ip4 ip = new Ip4();
    private final Ethernet eth = new Ethernet();

    public JFlow(JFlowKey jFlowKey) {
        this.key = jFlowKey;
        boolean bl = this.reversable = (jFlowKey.getFlags() & 1) > 0;
        if (this.reversable) {
            this.all = new LinkedList<JPacket>();
            this.forward = new LinkedList<JPacket>();
            this.reverse = new LinkedList<JPacket>();
        } else {
            this.all = new LinkedList<JPacket>();
            this.forward = Collections.emptyList();
            this.reverse = Collections.emptyList();
        }
    }

    public final JFlowKey getKey() {
        return this.key;
    }

    public boolean add(JPacket jPacket) {
        int n = this.key.match(jPacket.getState().getFlowKey());
        if (n == 0) {
            return false;
        }
        if (!this.isReversable()) {
            return this.all.add(jPacket);
        }
        return (n == 1 ? this.forward.add(jPacket) : this.reverse.add(jPacket)) && this.all.add(jPacket);
    }

    public final boolean isReversable() {
        return this.reversable;
    }

    public final List<JPacket> getAll() {
        return this.all;
    }

    public int size() {
        return this.all.size();
    }

    public final List<JPacket> getForward() {
        return this.reversable ? this.forward : this.all;
    }

    public final List<JPacket> getReverse() {
        return this.reversable ? this.reverse : null;
    }

    public String toString() {
        if (this.all.isEmpty()) {
            return this.key.toDebugString() + " size=" + this.all.size();
        }
        JPacket jPacket = this.all.get(0);
        if (jPacket.hasHeader(this.tcp) && jPacket.hasHeader(this.ip)) {
            String string = FormatUtils.ip(this.ip.destination());
            String string2 = FormatUtils.ip(this.ip.source());
            String string3 = "" + this.tcp.source();
            String string4 = "" + this.tcp.destination();
            return string2 + ":" + string3 + " -> " + string + ":" + string4 + " Tcp fw/rev/tot pkts=[" + this.forward.size() + "/" + this.reverse.size() + "/" + this.all.size() + "]";
        }
        if (jPacket.hasHeader(this.ip)) {
            String string = FormatUtils.ip(this.ip.destination());
            String string5 = FormatUtils.ip(this.ip.source());
            String string6 = "" + this.ip.type();
            return string5 + " -> " + string + ":" + string6 + " Ip4 tot pkts=[" + this.all.size() + "]";
        }
        if (jPacket.hasHeader(this.eth)) {
            String string = FormatUtils.mac(this.eth.destination());
            String string7 = FormatUtils.mac(this.eth.source());
            String string8 = Integer.toHexString(this.eth.type());
            return string7 + " -> " + string + ":" + string8 + " Eth tot pkts=[" + this.all.size() + "]";
        }
        return this.key.toDebugString() + " packets=" + this.all.size();
    }
}

