/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.nio;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.sql.Time;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jnetpcap.nio.DisposableReference;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.nio.LinkSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DisposableGC {
    private static final long DEFAULT_CLEANUP_THREAD_TIMEOUT = 20L;
    private static DisposableGC defaultGC = new DisposableGC();
    private static final long G10 = 10000L;
    private static final long G60 = 60000L;
    private static final int MANUAL_DRAING_MAX = 2;
    static final int MIN_MEMORY_RELEASE = 0x200000;
    static final long MIN_SYSTEM_GC_INVOKE_TIMEOUT = 200L;
    static final long OUT_OF_MEMORY_TIMEOUT = 15000L;
    private Thread cleanupThread;
    private final AtomicBoolean cleanupThreadActive = new AtomicBoolean(false);
    private final AtomicBoolean cleanupThreadProcessing = new AtomicBoolean(false);
    private final AtomicLong cleanupTimeout = new AtomicLong(20L);
    private long deltaCount;
    private long deltaSize;
    final LinkSequence<DisposableReference> g0 = new LinkSequence("g0");
    final LinkSequence<DisposableReference> g10 = new LinkSequence("g10");
    final LinkSequence<DisposableReference> g60 = new LinkSequence("g60");
    private long lastSystemGCInvoke = 0L;
    private long firstSystemGCNeeded = 0L;
    final ReferenceQueue<Object> markerQueue = new ReferenceQueue();
    private Reference<Object> markerReference;
    private final Semaphore memorySemaphore = new Semaphore(0x200000);
    final ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private long totalDisposed = 1L;
    private long totalSize;
    private boolean verbose = false;
    private boolean vverbose = false;
    private boolean vvverbose = false;

    public static DisposableGC getDefault() {
        return defaultGC;
    }

    private static long mem(LinkSequence<DisposableReference> linkSequence) {
        long l = 0L;
        for (DisposableReference disposableReference : linkSequence) {
            l += (long)disposableReference.size();
        }
        return l;
    }

    private DisposableGC() {
        this.startCleanupThread();
        try {
            this.setVerbose(Boolean.parseBoolean(System.getProperty("nio.verbose", "false")));
            this.setVVerbose(Boolean.parseBoolean(System.getProperty("nio.vverbose", "false")));
            this.setVVVerbose(Boolean.parseBoolean(System.getProperty("nio.vvverbose", "false")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReference(DisposableReference disposableReference) {
        LinkSequence<DisposableReference> linkSequence = this.g0;
        synchronized (linkSequence) {
            this.g0.add(disposableReference);
        }
        if (!this.isCleanupThreadActive()) {
            this.drainRefQueueBounded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(DisposableReference disposableReference) {
        try {
            LinkSequence<DisposableReference> linkSequence = this.g0;
            synchronized (linkSequence) {
                this.memorySemaphore.release(disposableReference.size());
                ++this.totalDisposed;
                this.totalSize += (long)disposableReference.size();
                disposableReference.dispose();
                disposableReference.remove();
                if (this.g0.isEmpty() && this.g10.isEmpty() && this.g60.isEmpty()) {
                    this.g0.notifyAll();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            this.logUsage();
            throw runtimeException;
        }
    }

    public void drainRefQueue() {
        DisposableReference disposableReference;
        while ((disposableReference = (DisposableReference)this.refQueue.poll()) != null) {
            this.dispose(disposableReference);
        }
    }

    public void drainRefQueue(long l) throws IllegalArgumentException, InterruptedException {
        this.memorySemaphore.acquire(this.memorySemaphore.availablePermits());
        long l2 = l / 100L;
        while (this.memorySemaphore.availablePermits() < 0x200000) {
            DisposableReference disposableReference = (DisposableReference)this.refQueue.remove(l);
            if (disposableReference == null && l2++ < 100L) continue;
            if (disposableReference == null) break;
            this.dispose(disposableReference);
        }
    }

    void drainRefQueueBounded() {
        DisposableReference disposableReference;
        for (int i = 0; i < 2 && (disposableReference = (DisposableReference)this.refQueue.poll()) != null; ++i) {
            this.dispose(disposableReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drainRefQueueLoop() throws InterruptedException {
        this.deltaCount = 0L;
        this.deltaSize = 0L;
        long l = this.cleanupTimeout.get();
        long l2 = System.currentTimeMillis();
        while (true) {
            AtomicBoolean atomicBoolean;
            DisposableReference disposableReference;
            if ((disposableReference = (DisposableReference)this.refQueue.remove(l)) != null) {
                if (this.deltaCount == 0L) {
                    if (this.vvverbose && !this.cleanupThreadProcessing.get()) {
                        this.logBusy();
                    }
                    this.cleanupThreadProcessing.set(true);
                    atomicBoolean = this.cleanupThreadProcessing;
                    synchronized (atomicBoolean) {
                        this.cleanupThreadProcessing.notifyAll();
                    }
                }
                ++this.deltaCount;
                this.deltaSize += (long)disposableReference.size();
                if (this.vverbose && this.deltaCount % 10000L == 0L) {
                    this.sortGenerations();
                    this.logUsage();
                }
            } else if (this.deltaCount != 0L && System.currentTimeMillis() - l2 >= 1000L) {
                l2 = System.currentTimeMillis();
                this.sortGenerations();
                if (this.verbose && this.deltaCount > 0L) {
                    this.logUsage();
                }
                this.deltaCount = 0L;
                this.deltaSize = 0L;
                this.cleanupThreadProcessing.set(false);
                atomicBoolean = this.cleanupThreadProcessing;
                synchronized (atomicBoolean) {
                    this.cleanupThreadProcessing.notifyAll();
                }
                if (this.vvverbose) {
                    this.logIdle();
                }
            }
            if (disposableReference == null) {
                if (this.cleanupThreadActive.get()) {
                    if (!this.memorySemaphore.hasQueuedThreads()) continue;
                    this.invokeSystemGC();
                    continue;
                }
                if (!this.verbose) break;
                this.logFinished();
                break;
            }
            if (this.memorySemaphore.availablePermits() > 0x200000) {
                this.memorySemaphore.drainPermits();
            }
            this.dispose(disposableReference);
        }
        if (this.verbose && this.deltaCount != 0L) {
            System.out.printf("DisposableGC: disposed of %d entries [total=%dM]%n", this.deltaCount, this.totalDisposed / 1000000L);
            this.deltaCount = 0L;
        }
    }

    private String f(long l) {
        return this.f(l, -1, "");
    }

    private String f(long l, int n) {
        return this.f(l, n, "");
    }

    private String f(long l, int n, String string) {
        String string2 = "";
        double d = l;
        int n2 = 0;
        if (l > 0x10000000000L) {
            string2 = "t";
            d /= 1.099511627776E12;
            n2 = 4;
        } else if (l > 0x40000000L) {
            string2 = "g";
            d /= 1.073741824E9;
            n2 = 2;
        } else if (l > 0x100000L) {
            string2 = "m";
            d /= 1048576.0;
            n2 = 1;
        } else if (l > 1024L) {
            string2 = "k";
            d /= 1024.0;
            n2 = 0;
        } else {
            n2 = 0;
        }
        if (n != -1) {
            n2 = n;
        }
        String string3 = String.format("%%.%df%%s%%s", n2);
        return String.format(string3, d, string2, string);
    }

    private String fb(long l) {
        return this.f(l, -1, "b");
    }

    private String fb(long l, int n) {
        return this.f(l, n, "b");
    }

    public long getCleanupThreadTimeout() {
        return this.cleanupTimeout.get();
    }

    private boolean invokeSystemGC() {
        if (System.currentTimeMillis() - this.lastSystemGCInvoke < 200L) {
            return false;
        }
        if (this.vverbose) {
            this.logSystemGC();
        }
        System.gc();
        this.lastSystemGCInvoke = System.currentTimeMillis();
        this.firstSystemGCNeeded = 0L;
        return true;
    }

    public synchronized void invokeSystemGCAndWait() {
        long l = System.currentTimeMillis();
        long l2 = JMemory.availableDirectMemory();
        try {
            if (this.isCleanupThreadActive()) {
                this.memorySemaphore.acquire(this.memorySemaphore.availablePermits());
                this.memorySemaphore.tryAcquire(0x200000, 15000L, TimeUnit.MILLISECONDS);
            } else {
                this.invokeSystemGC();
                this.drainRefQueue(15000L);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.memorySemaphore.drainPermits();
        this.memorySemaphore.release(0x200000);
        if (this.vverbose) {
            System.out.printf("DisposableGC: waiting for System.gc to finish: %dms, freed=%dMbytes%n", System.currentTimeMillis() - l, (JMemory.availableDirectMemory() - l2) / 0x100000L);
        }
    }

    public synchronized void invokeSystemGCWithMarker() {
        if (this.markerReference != null && this.markerReference.get() != null || !this.isSystemGCReady()) {
            return;
        }
        if (this.vvverbose) {
            this.logMarker();
        }
        this.markerReference = new WeakReference<1>(new Object(){});
        this.invokeSystemGC();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCleanupComplete() {
        LinkSequence<DisposableReference> linkSequence = this.g0;
        synchronized (linkSequence) {
            return this.g0.isEmpty();
        }
    }

    public boolean isCleanupThreadActive() {
        return this.cleanupThreadActive.get() && this.cleanupThread.isAlive();
    }

    private final boolean isSystemGCReady() {
        if (this.firstSystemGCNeeded == 0L) {
            this.firstSystemGCNeeded = System.currentTimeMillis();
        }
        return !this.cleanupThreadProcessing.get() && System.currentTimeMillis() - this.lastSystemGCInvoke > 200L;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isVVerbose() {
        return this.vverbose;
    }

    public boolean isVVVerbose() {
        return this.vvverbose;
    }

    private void logBusy() {
        System.out.printf("DisposableGC: busy%n", new Object[0]);
    }

    private void logFinished() {
        System.out.printf("DisposableGC: finished%n", new Object[0]);
    }

    private void logIdle() {
        System.out.printf("DisposableGC: idle - waiting for system GC to collect more objects%n", new Object[0]);
    }

    private void logLimits() {
        System.out.printf("DisposableGC: current native memory allocation limits are max=%s, soft=%s%n", this.fb(JMemory.maxDirectMemory()), this.fb(JMemory.softDirectMemory()));
    }

    private void logMarker() {
        long l = System.currentTimeMillis();
        long l2 = l - l / 1000L * 1000L;
        System.out.printf("DisposableGC: soft limit breached, issued a marker at %s.%d, minimum delay=%dms%n", new Time(l), l2, 200L);
    }

    private void logSystemGC() {
        long l = System.currentTimeMillis();
        long l2 = l - l / 1000L * 1000L;
        long l3 = l - this.firstSystemGCNeeded;
        System.out.printf("DisposableGC: issued JVM GC request %s.%d waited=%dms (reserved=%s, available=%s)%n", new Time(l), l2, l3, this.fb(JMemory.reservedDirectMemory()), this.fb(JMemory.availableDirectMemory()));
    }

    private void logUsage() {
        System.out.printf("DisposableGC: [immediate=%3s(%4s)] [total=%3s(%7s), sem=%s] [gens: 0sec=%3s(%6s),10sec=%3s(%6s),60sec=%3s(%6s)]=%6s%n", this.f(this.deltaCount), this.fb(this.deltaSize, 0), this.f(this.totalDisposed), this.fb(this.totalSize), this.f(this.memorySemaphore.availablePermits()), this.f(this.g0.size()), this.fb(DisposableGC.mem(this.g0)), this.f(this.g10.size()), this.fb(DisposableGC.mem(this.g10)), this.f(this.g60.size()), this.fb(DisposableGC.mem(this.g60)), this.fb(this.memoryHeldInRefCollection()));
    }

    private long memoryHeldInRefCollection() {
        long l = 0L;
        l += DisposableGC.mem(this.g0);
        l += DisposableGC.mem(this.g10);
        return l += DisposableGC.mem(this.g60);
    }

    public void setCleanupThreadTimeout(long l) {
        this.cleanupTimeout.set(l);
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
        if (!bl) {
            this.setVVerbose(false);
            this.setVVVerbose(false);
        } else {
            this.logLimits();
        }
    }

    public void setVVerbose(boolean bl) {
        if (bl) {
            this.setVerbose(true);
        } else {
            this.setVVVerbose(false);
        }
        this.vverbose = bl;
    }

    public void setVVVerbose(boolean bl) {
        if (bl) {
            this.setVVerbose(true);
        }
        this.vvverbose = bl;
    }

    private void sortGenerations() {
        long l = System.currentTimeMillis();
        for (DisposableReference disposableReference : this.g10) {
            if (l - disposableReference.getTs() <= 60000L) break;
            this.g10.remove(disposableReference);
            this.g60.add(disposableReference);
        }
        for (DisposableReference disposableReference : this.g0) {
            if (l - disposableReference.getTs() <= 10000L) break;
            this.g0.remove(disposableReference);
            this.g10.add(disposableReference);
        }
    }

    public synchronized void startCleanupThread() {
        if (this.isCleanupThreadActive()) {
            return;
        }
        this.cleanupThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    DisposableGC.this.drainRefQueueLoop();
                }
                catch (InterruptedException interruptedException) {
                    Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                    uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), interruptedException);
                }
                finally {
                    DisposableGC.this.cleanupThreadActive.set(false);
                    DisposableGC.this.cleanupThread = null;
                    2 var1_3 = this;
                    synchronized (var1_3) {
                        this.notifyAll();
                    }
                }
            }
        }, "DisposableGC");
        this.cleanupThreadActive.set(true);
        this.cleanupThread.setDaemon(true);
        this.cleanupThread.setPriority(this.cleanupThread.getPriority() - 1);
        this.cleanupThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCleanupThread() throws InterruptedException {
        if (this.isCleanupThreadActive()) {
            Thread thread = this.cleanupThread;
            synchronized (thread) {
                this.cleanupThreadActive.set(false);
                if (this.cleanupThread != null) {
                    this.cleanupThread.wait();
                }
            }
        }
    }

    public void waitForForcableCleanup() throws InterruptedException {
        System.gc();
        while (!this.waitForFullCleanup(5000L)) {
            if (!this.verbose || this.cleanupThreadProcessing.get()) continue;
            for (int i = 0; i < this.g0.size(); ++i) {
                DisposableReference disposableReference = this.g0.get(i);
                if (disposableReference != null && disposableReference.get() == null) continue;
            }
        }
    }

    public boolean waitForForcableCleanup(long l) throws InterruptedException {
        int n = (int)(l / 100L) + 1;
        while (n-- >= 0 && !this.waitForFullCleanup(100L)) {
            this.invokeSystemGC();
        }
        return this.isCleanupComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFullCleanup() throws InterruptedException {
        LinkSequence<DisposableReference> linkSequence = this.g0;
        synchronized (linkSequence) {
            while (!this.g0.isEmpty()) {
                if (this.isCleanupThreadActive()) {
                    this.g0.wait();
                    continue;
                }
                this.drainRefQueue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForFullCleanup(long l) throws InterruptedException {
        LinkSequence<DisposableReference> linkSequence = this.g0;
        synchronized (linkSequence) {
            if (!this.g0.isEmpty()) {
                if (this.isCleanupThreadActive()) {
                    this.g0.wait(l);
                } else {
                    this.drainRefQueue();
                    if (!this.g0.isEmpty()) {
                        Thread.sleep(l);
                        this.drainRefQueue();
                    }
                }
            }
            return this.g0.isEmpty();
        }
    }
}

