/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.bugs;

import junit.framework.Assert;
import org.jnetpcap.JBufferHandler;
import org.jnetpcap.Pcap;
import org.jnetpcap.PcapHeader;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JRegistry;
import org.jnetpcap.packet.JScanner;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.PcapPacketHandler;
import org.jnetpcap.packet.TestUtils;

public class Bug2827356_PcapPacketHandler_Fails
extends TestUtils {
    public static final String SMALL_ICMP_FILE = "tests/test-small-imap.pcap";
    private Pcap pcap;

    @Override
    protected void setUp() throws Exception {
        this.pcap = TestUtils.openOffline(SMALL_ICMP_FILE);
    }

    @Override
    protected void tearDown() throws Exception {
        this.pcap.close();
        this.pcap = null;
    }

    public void testValidateHttpJBufferPacketHandler() {
        this.pcap.loop(-1, new JBufferHandler<Pcap>(){

            @Override
            public void nextPacket(PcapHeader pcapHeader, JBuffer jBuffer, Pcap pcap) {
                Assert.assertNotNull((Object)jBuffer);
            }
        }, this.pcap);
    }

    public void testValidateHttpPcapPacketHandler() {
        this.pcap.loop(-1, new PcapPacketHandler<Pcap>(){

            @Override
            public void nextPacket(PcapPacket pcapPacket, Pcap pcap) {
                Assert.assertNotNull((Object)pcapPacket);
                System.out.println(pcapPacket);
            }
        }, this.pcap);
    }

    public void testValidateHttpJBufferPacketHandlerWithLocalPacketScanner() {
        this.pcap.loop(-1, new JBufferHandler<Pcap>(){

            @Override
            public void nextPacket(PcapHeader pcapHeader, JBuffer jBuffer, Pcap pcap) {
                Assert.assertNotNull((Object)jBuffer);
                int n = JRegistry.mapDLTToId(pcap.datalink());
                PcapPacket pcapPacket = new PcapPacket(pcapHeader, jBuffer);
                Assert.assertNotNull((Object)pcapPacket);
                pcapPacket.scan(n);
            }
        }, this.pcap);
    }

    public void testValidateHttpJBufferPacketHandlerWithGlobalScanner() {
        this.pcap.loop(-1, new JBufferHandler<Pcap>(){

            @Override
            public void nextPacket(PcapHeader pcapHeader, JBuffer jBuffer, Pcap pcap) {
                Assert.assertNotNull((Object)jBuffer);
                int n = JRegistry.mapDLTToId(pcap.datalink());
                PcapPacket pcapPacket = new PcapPacket(pcapHeader, jBuffer);
                Assert.assertNotNull((Object)pcapPacket);
                JScanner jScanner = JScanner.getThreadLocal();
                jScanner.scan(pcapPacket, n);
            }
        }, this.pcap);
    }
}

