/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import de.gematik.rbellogger.util.RbelPkiIdentity;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Enumeration;
import java.util.Optional;
import lombok.Generated;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CryptoLoader {
    private static final BouncyCastleProvider BOUNCY_CASTLE_PROVIDER = new BouncyCastleProvider();

    public static X509Certificate getCertificateFromP12(byte[] crt, String p12Password) {
        try {
            KeyStore p12 = KeyStore.getInstance("pkcs12", BOUNCY_CASTLE_PROVIDER);
            p12.load(new ByteArrayInputStream(crt), p12Password.toCharArray());
            Enumeration<String> e = p12.aliases();
            if (e.hasMoreElements()) {
                String alias = e.nextElement();
                return (X509Certificate)p12.getCertificate(alias);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("Could not find certificate in P12-File");
    }

    public static X509Certificate getCertificateFromPem(byte[] crt) {
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509", BOUNCY_CASTLE_PROVIDER);
            ByteArrayInputStream in = new ByteArrayInputStream(crt);
            X509Certificate x509Certificate = (X509Certificate)certFactory.generateCertificate(in);
            if (x509Certificate == null) {
                throw new RuntimeException("Error while loading certificate!");
            }
            return x509Certificate;
        }
        catch (CertificateException ex) {
            throw new RuntimeException("Error while loading certificate!", ex);
        }
    }

    public static RbelPkiIdentity getIdentityFromP12(byte[] p12FileContent, String p12Password) {
        try {
            KeyStore p12 = KeyStore.getInstance("pkcs12", BOUNCY_CASTLE_PROVIDER);
            p12.load(new ByteArrayInputStream(p12FileContent), p12Password.toCharArray());
            Enumeration<String> e = p12.aliases();
            if (e.hasMoreElements()) {
                String alias = e.nextElement();
                X509Certificate certificate = (X509Certificate)p12.getCertificate(alias);
                PrivateKey privateKey = (PrivateKey)p12.getKey(alias, p12Password.toCharArray());
                return new RbelPkiIdentity(certificate, privateKey, Optional.empty());
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("Could not find certificate in P12-File");
    }

    public static PublicKey getEcPublicKeyFromBytes(byte[] keyBytes) {
        X509EncodedKeySpec publicKeyEncoded = new X509EncodedKeySpec(keyBytes);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            return keyFactory.generatePublic(publicKeyEncoded);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    private CryptoLoader() {
    }
}

