/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.renderer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import de.gematik.rbellogger.data.elements.RbelElement;
import de.gematik.rbellogger.data.elements.RbelHttpRequest;
import de.gematik.rbellogger.data.elements.RbelHttpResponse;
import de.gematik.rbellogger.data.elements.RbelJsonElement;
import de.gematik.rbellogger.data.elements.RbelJweElement;
import de.gematik.rbellogger.data.elements.RbelJwtElement;
import de.gematik.rbellogger.data.elements.RbelJwtSignature;
import de.gematik.rbellogger.data.elements.RbelMapElement;
import de.gematik.rbellogger.data.elements.RbelNullElement;
import de.gematik.rbellogger.data.elements.RbelStringElement;
import de.gematik.rbellogger.data.elements.RbelUriElement;
import java.util.stream.Collectors;

public class RbelMarkdownRenderer {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static String render(RbelElement element) {
        return RbelMarkdownRenderer.render(element, 0);
    }

    public static String render(RbelElement element, int depth) {
        if (element instanceof RbelHttpResponse) {
            return RbelMarkdownRenderer.render((RbelHttpResponse)element, depth + 1);
        }
        if (element instanceof RbelHttpRequest) {
            return RbelMarkdownRenderer.render((RbelHttpRequest)element, depth + 1);
        }
        if (element instanceof RbelMapElement) {
            return RbelMarkdownRenderer.render((RbelMapElement)element, depth + 1);
        }
        if (element instanceof RbelStringElement) {
            return element.getContent();
        }
        if (element instanceof RbelUriElement) {
            return RbelMarkdownRenderer.render((RbelUriElement)element, depth + 1);
        }
        if (element instanceof RbelJsonElement) {
            return RbelMarkdownRenderer.render((RbelJsonElement)element, depth + 1);
        }
        if (element instanceof RbelJwtElement) {
            return RbelMarkdownRenderer.render((RbelJwtElement)element, depth + 1);
        }
        if (element instanceof RbelJweElement) {
            return RbelMarkdownRenderer.render((RbelJweElement)element, depth + 1);
        }
        return element.getContent();
    }

    public static String render(RbelHttpResponse message, int depth) {
        StringBuilder builder = new StringBuilder().append("#".repeat(depth)).append(" Response\n").append("```\n").append(message.getResponseCode()).append("\n\n").append(RbelMarkdownRenderer.render(message.getHeader(), depth)).append("\n```\n\n");
        if (message.getBody() != null && !(message.getBody() instanceof RbelNullElement)) {
            builder.append(RbelMarkdownRenderer.render(message.getBody(), depth));
        }
        return builder.toString();
    }

    public static String render(RbelHttpRequest message, int depth) {
        StringBuilder builder = new StringBuilder().append("#".repeat(depth)).append(" Request\n").append("```\n").append(message.getMethod()).append(" ").append(RbelMarkdownRenderer.render(message.getPath())).append("\n\n").append(RbelMarkdownRenderer.render(message.getHeader(), depth)).append("\n```\n\n");
        if (message.getBody() != null && !(message.getBody() instanceof RbelNullElement)) {
            builder.append(RbelMarkdownRenderer.render(message.getBody(), depth));
        }
        return builder.toString();
    }

    public static String render(RbelJsonElement json, int depth) {
        return "```\n" + GSON.toJson(JsonParser.parseString(json.getCompleteJsonString())) + "\n```";
    }

    public static String render(RbelUriElement pathElement, int depth) {
        return pathElement.getOriginalUrl().replace("?", "\n?").replace("&", "\n&");
    }

    public static String render(RbelJwtSignature signature, int depth) {
        return "```\n" + GSON.toJson(signature) + "\n```";
    }

    public static String render(RbelJwtElement jwt, int depth) {
        return "#".repeat(depth) + " JWT\n" + "#".repeat(depth + 1) + "Header:\n" + RbelMarkdownRenderer.render(jwt.getHeader(), depth) + "\n\n" + "#".repeat(depth + 1) + "Body:\n" + RbelMarkdownRenderer.render(jwt.getBody(), depth) + "\n\n" + "#".repeat(depth + 1) + "Signature:\n" + RbelMarkdownRenderer.render(jwt.getSignature(), depth);
    }

    public static String render(RbelJweElement jwe, int depth) {
        return "#".repeat(depth) + " JWE\n" + "#".repeat(depth + 1) + "Header:\n" + RbelMarkdownRenderer.render(jwe.getHeader(), depth) + "\n\n" + "#".repeat(depth + 1) + "Body:\n" + RbelMarkdownRenderer.render(jwe.getBody(), depth) + "\n\n" + "#".repeat(depth + 1) + "Decryption:\n" + RbelMarkdownRenderer.render(jwe.getEncryptionInfo(), depth);
    }

    public static String render(RbelMapElement map, int depth) {
        return map.getElementMap().entrySet().stream().map(entry -> (String)entry.getKey() + ": " + RbelMarkdownRenderer.render((RbelElement)entry.getValue(), depth)).collect(Collectors.joining("\n"));
    }
}

