/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.elements;

import de.gematik.rbellogger.data.elements.RbelElement;
import de.gematik.rbellogger.data.elements.RbelGenericVauMessage;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import javax.crypto.SecretKey;
import lombok.Generated;

public class RbelVauErpMessage
extends RbelGenericVauMessage {
    private final String requestId;
    private final SecretKey responseKey;

    public RbelVauErpMessage(RbelElement message, byte[] encryptedMessage, String keyIdUsed, Integer pVersionNumber, String requestId, SecretKey responseKey) {
        super(message, encryptedMessage, keyIdUsed, pVersionNumber);
        this.requestId = requestId;
        this.responseKey = responseKey;
    }

    @Override
    public List<? extends RbelElement> getChildNodes() {
        return List.of(this.getMessage());
    }

    @Override
    public String getContent() {
        return Base64.getEncoder().encodeToString(this.getEncryptedMessage());
    }

    @Generated
    public static RbelVauErpMessageBuilder builder() {
        return new RbelVauErpMessageBuilder();
    }

    @Generated
    public String getRequestId() {
        return this.requestId;
    }

    @Generated
    public SecretKey getResponseKey() {
        return this.responseKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelVauErpMessage)) {
            return false;
        }
        RbelVauErpMessage other = (RbelVauErpMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        SecretKey this$responseKey = this.getResponseKey();
        SecretKey other$responseKey = other.getResponseKey();
        return !(this$responseKey == null ? other$responseKey != null : !this$responseKey.equals(other$responseKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelVauErpMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        SecretKey $responseKey = this.getResponseKey();
        result = result * 59 + ($responseKey == null ? 43 : $responseKey.hashCode());
        return result;
    }

    @Generated
    public static class RbelVauErpMessageBuilder {
        @Generated
        private RbelElement message;
        @Generated
        private byte[] encryptedMessage;
        @Generated
        private String keyIdUsed;
        @Generated
        private Integer pVersionNumber;
        @Generated
        private String requestId;
        @Generated
        private SecretKey responseKey;

        @Generated
        RbelVauErpMessageBuilder() {
        }

        @Generated
        public RbelVauErpMessageBuilder message(RbelElement message) {
            this.message = message;
            return this;
        }

        @Generated
        public RbelVauErpMessageBuilder encryptedMessage(byte[] encryptedMessage) {
            this.encryptedMessage = encryptedMessage;
            return this;
        }

        @Generated
        public RbelVauErpMessageBuilder keyIdUsed(String keyIdUsed) {
            this.keyIdUsed = keyIdUsed;
            return this;
        }

        @Generated
        public RbelVauErpMessageBuilder pVersionNumber(Integer pVersionNumber) {
            this.pVersionNumber = pVersionNumber;
            return this;
        }

        @Generated
        public RbelVauErpMessageBuilder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Generated
        public RbelVauErpMessageBuilder responseKey(SecretKey responseKey) {
            this.responseKey = responseKey;
            return this;
        }

        @Generated
        public RbelVauErpMessage build() {
            return new RbelVauErpMessage(this.message, this.encryptedMessage, this.keyIdUsed, this.pVersionNumber, this.requestId, this.responseKey);
        }

        @Generated
        public String toString() {
            return "RbelVauErpMessage.RbelVauErpMessageBuilder(message=" + this.message + ", encryptedMessage=" + Arrays.toString(this.encryptedMessage) + ", keyIdUsed=" + this.keyIdUsed + ", pVersionNumber=" + this.pVersionNumber + ", requestId=" + this.requestId + ", responseKey=" + this.responseKey + ")";
        }
    }
}

