/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.elements;

import de.gematik.rbellogger.data.elements.RbelElement;
import de.gematik.rbellogger.data.elements.RbelGenericVauMessage;
import de.gematik.rbellogger.data.elements.RbelMultiValuedMapElement;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import lombok.Generated;

public class RbelVauEpaMessage
extends RbelGenericVauMessage {
    private final RbelMultiValuedMapElement additionalHeaders;
    private final Long sequenceNumber;

    public RbelVauEpaMessage(RbelElement message, byte[] encryptedMessage, String keyIdUsed, Integer pVersionNumber, RbelMultiValuedMapElement additionalHeaders, Long sequenceNumber) {
        super(message, encryptedMessage, keyIdUsed, pVersionNumber);
        this.additionalHeaders = additionalHeaders;
        this.sequenceNumber = sequenceNumber;
    }

    @Override
    public List<? extends RbelElement> getChildNodes() {
        return List.of(this.getMessage());
    }

    @Override
    public String getContent() {
        return Base64.getEncoder().encodeToString(this.getEncryptedMessage());
    }

    @Generated
    public static RbelVauEpaMessageBuilder builder() {
        return new RbelVauEpaMessageBuilder();
    }

    @Generated
    public RbelMultiValuedMapElement getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    @Generated
    public Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelVauEpaMessage)) {
            return false;
        }
        RbelVauEpaMessage other = (RbelVauEpaMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RbelMultiValuedMapElement this$additionalHeaders = this.getAdditionalHeaders();
        RbelMultiValuedMapElement other$additionalHeaders = other.getAdditionalHeaders();
        if (this$additionalHeaders == null ? other$additionalHeaders != null : !this$additionalHeaders.equals(other$additionalHeaders)) {
            return false;
        }
        Long this$sequenceNumber = this.getSequenceNumber();
        Long other$sequenceNumber = other.getSequenceNumber();
        return !(this$sequenceNumber == null ? other$sequenceNumber != null : !((Object)this$sequenceNumber).equals(other$sequenceNumber));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelVauEpaMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RbelMultiValuedMapElement $additionalHeaders = this.getAdditionalHeaders();
        result = result * 59 + ($additionalHeaders == null ? 43 : $additionalHeaders.hashCode());
        Long $sequenceNumber = this.getSequenceNumber();
        result = result * 59 + ($sequenceNumber == null ? 43 : ((Object)$sequenceNumber).hashCode());
        return result;
    }

    @Generated
    public static class RbelVauEpaMessageBuilder {
        @Generated
        private RbelElement message;
        @Generated
        private byte[] encryptedMessage;
        @Generated
        private String keyIdUsed;
        @Generated
        private Integer pVersionNumber;
        @Generated
        private RbelMultiValuedMapElement additionalHeaders;
        @Generated
        private Long sequenceNumber;

        @Generated
        RbelVauEpaMessageBuilder() {
        }

        @Generated
        public RbelVauEpaMessageBuilder message(RbelElement message) {
            this.message = message;
            return this;
        }

        @Generated
        public RbelVauEpaMessageBuilder encryptedMessage(byte[] encryptedMessage) {
            this.encryptedMessage = encryptedMessage;
            return this;
        }

        @Generated
        public RbelVauEpaMessageBuilder keyIdUsed(String keyIdUsed) {
            this.keyIdUsed = keyIdUsed;
            return this;
        }

        @Generated
        public RbelVauEpaMessageBuilder pVersionNumber(Integer pVersionNumber) {
            this.pVersionNumber = pVersionNumber;
            return this;
        }

        @Generated
        public RbelVauEpaMessageBuilder additionalHeaders(RbelMultiValuedMapElement additionalHeaders) {
            this.additionalHeaders = additionalHeaders;
            return this;
        }

        @Generated
        public RbelVauEpaMessageBuilder sequenceNumber(Long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        @Generated
        public RbelVauEpaMessage build() {
            return new RbelVauEpaMessage(this.message, this.encryptedMessage, this.keyIdUsed, this.pVersionNumber, this.additionalHeaders, this.sequenceNumber);
        }

        @Generated
        public String toString() {
            return "RbelVauEpaMessage.RbelVauEpaMessageBuilder(message=" + this.message + ", encryptedMessage=" + Arrays.toString(this.encryptedMessage) + ", keyIdUsed=" + this.keyIdUsed + ", pVersionNumber=" + this.pVersionNumber + ", additionalHeaders=" + this.additionalHeaders + ", sequenceNumber=" + this.sequenceNumber + ")";
        }
    }
}

