/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.elements;

import de.gematik.rbellogger.data.elements.RbelElement;
import de.gematik.rbellogger.data.elements.RbelHttpMessage;
import de.gematik.rbellogger.data.elements.RbelHttpRequest;
import de.gematik.rbellogger.data.elements.RbelMultiValuedMapElement;
import java.util.Arrays;
import lombok.Generated;

public class RbelHttpResponse
extends RbelHttpMessage {
    private final int responseCode;
    private RbelHttpRequest request;

    public RbelHttpResponse(RbelMultiValuedMapElement header, RbelElement body, int responseCode, String rawMessage, byte[] rawBody) {
        super(header, body, rawBody);
        this.responseCode = responseCode;
        if (rawMessage != null) {
            this.setRawMessage(rawMessage);
        }
    }

    @Override
    public String getContent() {
        return ELEMENT_SEPARATOR + "HTTP RESPONSE " + this.responseCode + " + \n Headers:\n" + this.getHeader().getContent() + HEADER_SEPARATOR + this.getBody().getContent();
    }

    @Generated
    public static RbelHttpResponseBuilder builder() {
        return new RbelHttpResponseBuilder();
    }

    @Generated
    public int getResponseCode() {
        return this.responseCode;
    }

    @Generated
    public RbelHttpRequest getRequest() {
        return this.request;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelHttpResponse)) {
            return false;
        }
        RbelHttpResponse other = (RbelHttpResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getResponseCode() != other.getResponseCode()) {
            return false;
        }
        RbelHttpRequest this$request = this.getRequest();
        RbelHttpRequest other$request = other.getRequest();
        return !(this$request == null ? other$request != null : !((Object)this$request).equals(other$request));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelHttpResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getResponseCode();
        RbelHttpRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "RbelHttpResponse(responseCode=" + this.getResponseCode() + ", request=" + this.getRequest() + ")";
    }

    @Generated
    public void setRequest(RbelHttpRequest request) {
        this.request = request;
    }

    @Generated
    public static class RbelHttpResponseBuilder {
        @Generated
        private RbelMultiValuedMapElement header;
        @Generated
        private RbelElement body;
        @Generated
        private int responseCode;
        @Generated
        private String rawMessage;
        @Generated
        private byte[] rawBody;

        @Generated
        RbelHttpResponseBuilder() {
        }

        @Generated
        public RbelHttpResponseBuilder header(RbelMultiValuedMapElement header) {
            this.header = header;
            return this;
        }

        @Generated
        public RbelHttpResponseBuilder body(RbelElement body) {
            this.body = body;
            return this;
        }

        @Generated
        public RbelHttpResponseBuilder responseCode(int responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        @Generated
        public RbelHttpResponseBuilder rawMessage(String rawMessage) {
            this.rawMessage = rawMessage;
            return this;
        }

        @Generated
        public RbelHttpResponseBuilder rawBody(byte[] rawBody) {
            this.rawBody = rawBody;
            return this;
        }

        @Generated
        public RbelHttpResponse build() {
            return new RbelHttpResponse(this.header, this.body, this.responseCode, this.rawMessage, this.rawBody);
        }

        @Generated
        public String toString() {
            return "RbelHttpResponse.RbelHttpResponseBuilder(header=" + this.header + ", body=" + this.body + ", responseCode=" + this.responseCode + ", rawMessage=" + this.rawMessage + ", rawBody=" + Arrays.toString(this.rawBody) + ")";
        }
    }
}

