/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.elements;

import de.gematik.rbellogger.data.elements.RbelElement;
import de.gematik.rbellogger.data.elements.RbelHttpMessage;
import de.gematik.rbellogger.data.elements.RbelMultiValuedMapElement;
import de.gematik.rbellogger.data.elements.RbelUriElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public class RbelHttpRequest
extends RbelHttpMessage {
    private final String method;
    private final RbelUriElement path;

    @Override
    public List<RbelElement> getChildNodes() {
        ArrayList<RbelElement> childNodes = new ArrayList<RbelElement>();
        childNodes.add(this.path);
        childNodes.addAll(super.getChildNodes());
        return childNodes;
    }

    public RbelHttpRequest(RbelMultiValuedMapElement header, RbelElement body, String method, RbelUriElement path, String rawMessage, byte[] rawBody) {
        super(header, body, rawBody);
        this.method = method;
        this.path = path;
        if (rawMessage != null) {
            this.setRawMessage(rawMessage);
        }
    }

    @Override
    public String getContent() {
        return ELEMENT_SEPARATOR + "HTTP REQUEST: " + this.method + " - " + this.path + "\nHeaders:\n" + this.getHeader().getContent() + HEADER_SEPARATOR + this.getBody().getContent();
    }

    @Generated
    public static RbelHttpRequestBuilder builder() {
        return new RbelHttpRequestBuilder();
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public RbelUriElement getPath() {
        return this.path;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelHttpRequest)) {
            return false;
        }
        RbelHttpRequest other = (RbelHttpRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        RbelUriElement this$path = this.getPath();
        RbelUriElement other$path = other.getPath();
        return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelHttpRequest;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        RbelUriElement $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "RbelHttpRequest(method=" + this.getMethod() + ", path=" + this.getPath() + ")";
    }

    @Generated
    public static class RbelHttpRequestBuilder {
        @Generated
        private RbelMultiValuedMapElement header;
        @Generated
        private RbelElement body;
        @Generated
        private String method;
        @Generated
        private RbelUriElement path;
        @Generated
        private String rawMessage;
        @Generated
        private byte[] rawBody;

        @Generated
        RbelHttpRequestBuilder() {
        }

        @Generated
        public RbelHttpRequestBuilder header(RbelMultiValuedMapElement header) {
            this.header = header;
            return this;
        }

        @Generated
        public RbelHttpRequestBuilder body(RbelElement body) {
            this.body = body;
            return this;
        }

        @Generated
        public RbelHttpRequestBuilder method(String method) {
            this.method = method;
            return this;
        }

        @Generated
        public RbelHttpRequestBuilder path(RbelUriElement path) {
            this.path = path;
            return this;
        }

        @Generated
        public RbelHttpRequestBuilder rawMessage(String rawMessage) {
            this.rawMessage = rawMessage;
            return this;
        }

        @Generated
        public RbelHttpRequestBuilder rawBody(byte[] rawBody) {
            this.rawBody = rawBody;
            return this;
        }

        @Generated
        public RbelHttpRequest build() {
            return new RbelHttpRequest(this.header, this.body, this.method, this.path, this.rawMessage, this.rawBody);
        }

        @Generated
        public String toString() {
            return "RbelHttpRequest.RbelHttpRequestBuilder(header=" + this.header + ", body=" + this.body + ", method=" + this.method + ", path=" + this.path + ", rawMessage=" + this.rawMessage + ", rawBody=" + Arrays.toString(this.rawBody) + ")";
        }
    }
}

