/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.elements;

import de.gematik.rbellogger.data.elements.RbelElement;
import de.gematik.rbellogger.util.GenericPrettyPrinter;
import de.gematik.rbellogger.util.RbelException;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.util.Iterable;
import wiremock.com.google.common.collect.Streams;

public class RbelAsn1Element
extends RbelElement {
    private static final GenericPrettyPrinter<ASN1Encodable> ASN1_PRETTY_PRINTER = new GenericPrettyPrinter<ASN1Encodable>(asn1 -> asn1 instanceof ASN1Sequence || asn1 instanceof ASN1Set, Object::toString, asn1 -> Streams.stream((Iterable)((Object)asn1)));
    private final ASN1Encodable asn1Element;
    private final RbelElement nestedElement;
    private byte[] unparsedBytes;

    public List<RbelElement> getChildNodes() {
        return List.of(this.nestedElement);
    }

    @Override
    public List<Map.Entry<String, RbelElement>> getChildElements() {
        if (this.nestedElement == null) {
            return Collections.emptyList();
        }
        if (this.nestedElement instanceof RbelAsn1Element) {
            return List.of(Pair.of("content", this.nestedElement));
        }
        if (this.nestedElement.getChildElements().isEmpty()) {
            return List.of(Pair.of("content", this.nestedElement));
        }
        return this.nestedElement.getChildElements();
    }

    @Override
    public boolean isNestedBoundary() {
        return this.nestedElement == null || !this.nestedElement.getChildElements().isEmpty();
    }

    @Override
    public String getContent() {
        return ASN1_PRETTY_PRINTER.prettyPrint(this.asn1Element);
    }

    public byte[] getEncoded() {
        try {
            return this.asn1Element.toASN1Primitive().getEncoded();
        }
        catch (IOException e) {
            throw new RbelException("Error while encoding ASN.1 element", e);
        }
    }

    @ConstructorProperties(value={"asn1Element", "nestedElement"})
    @Generated
    public RbelAsn1Element(ASN1Encodable asn1Element, RbelElement nestedElement) {
        this.asn1Element = asn1Element;
        this.nestedElement = nestedElement;
    }

    @Generated
    public ASN1Encodable getAsn1Element() {
        return this.asn1Element;
    }

    @Generated
    public RbelElement getNestedElement() {
        return this.nestedElement;
    }

    @Generated
    public byte[] getUnparsedBytes() {
        return this.unparsedBytes;
    }

    @Generated
    public void setUnparsedBytes(byte[] unparsedBytes) {
        this.unparsedBytes = unparsedBytes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelAsn1Element)) {
            return false;
        }
        RbelAsn1Element other = (RbelAsn1Element)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ASN1Encodable this$asn1Element = this.getAsn1Element();
        ASN1Encodable other$asn1Element = other.getAsn1Element();
        if (this$asn1Element == null ? other$asn1Element != null : !this$asn1Element.equals(other$asn1Element)) {
            return false;
        }
        RbelElement this$nestedElement = this.getNestedElement();
        RbelElement other$nestedElement = other.getNestedElement();
        if (this$nestedElement == null ? other$nestedElement != null : !this$nestedElement.equals(other$nestedElement)) {
            return false;
        }
        return Arrays.equals(this.getUnparsedBytes(), other.getUnparsedBytes());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelAsn1Element;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ASN1Encodable $asn1Element = this.getAsn1Element();
        result = result * 59 + ($asn1Element == null ? 43 : $asn1Element.hashCode());
        RbelElement $nestedElement = this.getNestedElement();
        result = result * 59 + ($nestedElement == null ? 43 : $nestedElement.hashCode());
        result = result * 59 + Arrays.hashCode(this.getUnparsedBytes());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelAsn1Element(asn1Element=" + this.getAsn1Element() + ", nestedElement=" + this.getNestedElement() + ", unparsedBytes=" + Arrays.toString(this.getUnparsedBytes()) + ")";
    }
}

