/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data;

import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.elements.RbelElement;
import de.gematik.rbellogger.data.elements.RbelHttpMessage;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

public class RbelMessage {
    private final RbelHttpMessage httpMessage;
    private final long sequenceNumber;
    private final RbelHostname sender;
    private final RbelHostname recipient;
    private final String uuid = UUID.randomUUID().toString();

    public String getContent() {
        return this.httpMessage.getContent();
    }

    public List<RbelElement> findRbelPathMembers(String rbelPathExpression) {
        return this.httpMessage.findRbelPathMembers(rbelPathExpression);
    }

    public String getNote() {
        return this.httpMessage.getNote();
    }

    @ConstructorProperties(value={"httpMessage", "sequenceNumber", "sender", "recipient"})
    @Generated
    RbelMessage(RbelHttpMessage httpMessage, long sequenceNumber, RbelHostname sender, RbelHostname recipient) {
        this.httpMessage = httpMessage;
        this.sequenceNumber = sequenceNumber;
        this.sender = sender;
        this.recipient = recipient;
    }

    @Generated
    public static RbelMessageBuilder builder() {
        return new RbelMessageBuilder();
    }

    @Generated
    public RbelHttpMessage getHttpMessage() {
        return this.httpMessage;
    }

    @Generated
    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Generated
    public RbelHostname getSender() {
        return this.sender;
    }

    @Generated
    public RbelHostname getRecipient() {
        return this.recipient;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelMessage)) {
            return false;
        }
        RbelMessage other = (RbelMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RbelHttpMessage this$httpMessage = this.getHttpMessage();
        RbelHttpMessage other$httpMessage = other.getHttpMessage();
        if (this$httpMessage == null ? other$httpMessage != null : !((Object)this$httpMessage).equals(other$httpMessage)) {
            return false;
        }
        if (this.getSequenceNumber() != other.getSequenceNumber()) {
            return false;
        }
        RbelHostname this$sender = this.getSender();
        RbelHostname other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !((Object)this$sender).equals(other$sender)) {
            return false;
        }
        RbelHostname this$recipient = this.getRecipient();
        RbelHostname other$recipient = other.getRecipient();
        if (this$recipient == null ? other$recipient != null : !((Object)this$recipient).equals(other$recipient)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        return !(this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RbelHttpMessage $httpMessage = this.getHttpMessage();
        result = result * 59 + ($httpMessage == null ? 43 : ((Object)$httpMessage).hashCode());
        long $sequenceNumber = this.getSequenceNumber();
        result = result * 59 + (int)($sequenceNumber >>> 32 ^ $sequenceNumber);
        RbelHostname $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : ((Object)$sender).hashCode());
        RbelHostname $recipient = this.getRecipient();
        result = result * 59 + ($recipient == null ? 43 : ((Object)$recipient).hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelMessage(httpMessage=" + this.getHttpMessage() + ", sequenceNumber=" + this.getSequenceNumber() + ", sender=" + this.getSender() + ", recipient=" + this.getRecipient() + ", uuid=" + this.getUuid() + ")";
    }

    @Generated
    public static class RbelMessageBuilder {
        @Generated
        private RbelHttpMessage httpMessage;
        @Generated
        private long sequenceNumber;
        @Generated
        private RbelHostname sender;
        @Generated
        private RbelHostname recipient;

        @Generated
        RbelMessageBuilder() {
        }

        @Generated
        public RbelMessageBuilder httpMessage(RbelHttpMessage httpMessage) {
            this.httpMessage = httpMessage;
            return this;
        }

        @Generated
        public RbelMessageBuilder sequenceNumber(long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        @Generated
        public RbelMessageBuilder sender(RbelHostname sender) {
            this.sender = sender;
            return this;
        }

        @Generated
        public RbelMessageBuilder recipient(RbelHostname recipient) {
            this.recipient = recipient;
            return this;
        }

        @Generated
        public RbelMessage build() {
            return new RbelMessage(this.httpMessage, this.sequenceNumber, this.sender, this.recipient);
        }

        @Generated
        public String toString() {
            return "RbelMessage.RbelMessageBuilder(httpMessage=" + this.httpMessage + ", sequenceNumber=" + this.sequenceNumber + ", sender=" + this.sender + ", recipient=" + this.recipient + ")";
        }
    }
}

