/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data;

import de.gematik.rbellogger.exceptions.RbelConversionException;
import java.beans.ConstructorProperties;
import java.net.URI;
import lombok.Generated;

public class RbelHostname {
    private final String hostname;
    private final int port;

    public String toString() {
        if (this.port > 0) {
            return this.hostname + ":" + this.port;
        }
        return this.hostname;
    }

    public static RbelHostname generateFromUrl(String url) {
        try {
            URI uri = new URI(url);
            if (uri.getPort() > 0) {
                return new RbelHostname(uri.getHost(), uri.getPort());
            }
            if ("http".equals(uri.getScheme())) {
                return new RbelHostname(uri.getHost(), 80);
            }
            if ("https".equals(uri.getScheme())) {
                return new RbelHostname(uri.getHost(), 443);
            }
            throw new RbelConversionException("Could not parse Hostname from '" + url + "'");
        }
        catch (Exception e) {
            throw new RbelConversionException("Could not parse Hostname from '" + url + "'");
        }
    }

    @Generated
    public static RbelHostnameBuilder builder() {
        return new RbelHostnameBuilder();
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelHostname)) {
            return false;
        }
        RbelHostname other = (RbelHostname)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        return this.getPort() == other.getPort();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelHostname;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        result = result * 59 + this.getPort();
        return result;
    }

    @ConstructorProperties(value={"hostname", "port"})
    @Generated
    public RbelHostname(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    @Generated
    public static class RbelHostnameBuilder {
        @Generated
        private String hostname;
        @Generated
        private int port;

        @Generated
        RbelHostnameBuilder() {
        }

        @Generated
        public RbelHostnameBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @Generated
        public RbelHostnameBuilder port(int port) {
            this.port = port;
            return this;
        }

        @Generated
        public RbelHostname build() {
            return new RbelHostname(this.hostname, this.port);
        }

        @Generated
        public String toString() {
            return "RbelHostname.RbelHostnameBuilder(hostname=" + this.hostname + ", port=" + this.port + ")";
        }
    }
}

