/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter.listener;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.elements.RbelAsn1Element;
import de.gematik.rbellogger.data.elements.RbelElement;
import de.gematik.rbellogger.data.elements.RbelJsonElement;
import de.gematik.rbellogger.data.elements.RbelListElement;
import de.gematik.rbellogger.data.elements.RbelMapElement;
import de.gematik.rbellogger.util.CryptoLoader;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelX5cKeyReader
implements BiConsumer<RbelElement, RbelConverter> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelX5cKeyReader.class);

    @Override
    public void accept(RbelElement rbelElement, RbelConverter converter) {
        Optional<RbelMapElement> keyMap = Optional.ofNullable(rbelElement).map(RbelMapElement.class::cast).filter(map -> map.getElementMap().containsKey("x5c"));
        if (keyMap.isPresent()) {
            Optional<byte[]> certificateData = this.getX509Certificate(keyMap);
            Optional<String> keyId = this.getKeyId(keyMap);
            if (keyId.isPresent() && certificateData.isPresent()) {
                try {
                    X509Certificate certificate = CryptoLoader.getCertificateFromPem(certificateData.get());
                    converter.getRbelKeyManager().addKey(keyId.get(), certificate.getPublicKey(), 100);
                }
                catch (Exception e) {
                    log.warn("Exception while extracting X5C: {}", e);
                }
            }
        }
    }

    private Optional<String> getKeyId(Optional<RbelMapElement> keyMap) {
        return keyMap.filter(map -> map.getElementMap().containsKey("kid")).map(map -> map.getElementMap().get("kid")).map(RbelElement::getContent);
    }

    private Optional<byte[]> getX509Certificate(Optional<RbelMapElement> keyMap) {
        return keyMap.map(map -> map.getElementMap().get("x5c")).filter(RbelJsonElement.class::isInstance).map(RbelJsonElement.class::cast).map(RbelJsonElement::getJsonElement).filter(RbelListElement.class::isInstance).map(RbelListElement.class::cast).map(RbelListElement::getElementList).stream().flatMap(Collection::stream).filter(RbelAsn1Element.class::isInstance).map(RbelAsn1Element.class::cast).map(RbelAsn1Element::getEncoded).findFirst();
    }
}

