/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.elements.RbelElement;
import de.gematik.rbellogger.data.elements.RbelNullElement;
import de.gematik.rbellogger.data.elements.RbelXmlElement;
import de.gematik.rbellogger.util.RbelException;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Text;
import org.dom4j.tree.AbstractBranch;
import org.dom4j.tree.DefaultComment;

public class RbelXmlConverter
implements RbelConverterPlugin {
    private static final String XML_TEXT_KEY = "text";

    @Override
    public boolean canConvertElement(RbelElement rbel, RbelConverter context) {
        String content = rbel.getContent();
        return content.contains("<") && content.contains(">");
    }

    @Override
    public RbelElement convertElement(RbelElement rbel, RbelConverter context) {
        try {
            return this.buildXmlElementForNode(DocumentHelper.parseText(rbel.getContent().trim()), context);
        }
        catch (Exception e) {
            return null;
        }
    }

    private RbelXmlElement buildXmlElementForNode(Branch branch, RbelConverter converter) {
        RbelXmlElement result = new RbelXmlElement(branch);
        result.setRawMessage(branch.asXML());
        for (Object child : branch.content()) {
            String childXmlName;
            if (child instanceof Text) {
                result.put(XML_TEXT_KEY, converter.convertElement(((Text)child).getText()));
                continue;
            }
            if (child instanceof AbstractBranch) {
                childXmlName = ((AbstractBranch)child).getName();
                result.put(childXmlName, this.buildXmlElementForNode((AbstractBranch)child, converter));
                continue;
            }
            if (child instanceof Namespace) {
                childXmlName = ((Namespace)child).getPrefix();
                result.put(childXmlName, converter.convertElement(((Namespace)child).getText()));
                continue;
            }
            if (child instanceof DefaultComment) continue;
            throw new RbelException("Could not convert XML element of type " + child.getClass().getSimpleName());
        }
        if (!result.containsKey(XML_TEXT_KEY)) {
            result.put(XML_TEXT_KEY, new RbelNullElement());
        }
        if (branch instanceof Element) {
            for (Object attribute : ((Element)branch).attributes()) {
                if (!(attribute instanceof Attribute)) {
                    throw new RbelException("Could not convert XML attribute of type " + attribute.getClass().getSimpleName());
                }
                result.put(((Attribute)attribute).getName(), converter.convertElement(((Attribute)attribute).getText()));
            }
        }
        return result;
    }
}

