/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.elements.RbelBinaryElement;
import de.gematik.rbellogger.data.elements.RbelElement;
import de.gematik.rbellogger.data.elements.RbelMultiValuedMapElement;
import de.gematik.rbellogger.data.elements.RbelNestedElement;
import de.gematik.rbellogger.data.elements.RbelVauEpaMessage;
import de.gematik.rbellogger.key.RbelKey;
import de.gematik.rbellogger.util.CryptoUtils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wiremock.org.apache.commons.codec.binary.Hex;

public class RbelVauDecryptionConverter
implements RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelVauDecryptionConverter.class);

    private static RbelVauEpaMessage fromRaw(Pair<byte[], byte[]> payloadPair, RbelConverter converter, byte[] decryptedBytes) {
        byte[] raw = new byte[decryptedBytes.length - 8 - 1];
        System.arraycopy(decryptedBytes, 9, raw, 0, raw.length);
        byte[] sequenceNumberBytes = new byte[4];
        System.arraycopy(decryptedBytes, 5, sequenceNumberBytes, 0, 4);
        int sequenceNumber = ByteBuffer.wrap(sequenceNumberBytes).getInt();
        byte[] numberOfBytes_inBytes = new byte[4];
        System.arraycopy(raw, 0, numberOfBytes_inBytes, 0, 4);
        int numberOfBytes = ByteBuffer.wrap(numberOfBytes_inBytes).getInt();
        byte[] headerField_inBytes = new byte[numberOfBytes];
        System.arraycopy(raw, 4, headerField_inBytes, 0, numberOfBytes);
        String headerField = new String(headerField_inBytes, StandardCharsets.US_ASCII);
        RbelMultiValuedMapElement header = new RbelMultiValuedMapElement();
        Arrays.stream(headerField.split("\r\n")).map(field -> field.split(":", 2)).forEach(field -> header.put(field[0].trim(), converter.convertElement(field[1])));
        byte[] body = new byte[raw.length - 4 - numberOfBytes];
        System.arraycopy(raw, 4 + numberOfBytes, body, 0, body.length);
        return RbelVauEpaMessage.builder().message(converter.convertElement(body)).additionalHeaders(header).encryptedMessage(payloadPair.getValue()).keyIdUsed(Hex.encodeHexString(payloadPair.getKey())).pVersionNumber(Integer.valueOf(decryptedBytes[0])).sequenceNumber(Long.valueOf(sequenceNumber)).build();
    }

    public static Pair<byte[], byte[]> splitVauMessage(byte[] vauMessage) {
        byte[] keyID = new byte[32];
        System.arraycopy(vauMessage, 0, keyID, 0, 32);
        byte[] enc = new byte[vauMessage.length - 32];
        System.arraycopy(vauMessage, 32, enc, 0, vauMessage.length - 32);
        return Pair.of(keyID, enc);
    }

    private Optional<RbelVauEpaMessage> decipherVauMessage(byte[] content, RbelConverter converter) {
        Pair<byte[], byte[]> splitVauMessage = RbelVauDecryptionConverter.splitVauMessage(content);
        List potentialVauKeys = converter.getRbelKeyManager().getAllKeys().filter(key -> key.getKeyName().startsWith(Hex.encodeHexString((byte[])splitVauMessage.getKey()))).filter(key -> key.getKey() instanceof SecretKey).collect(Collectors.toList());
        for (RbelKey rbelKey : potentialVauKeys) {
            Optional<byte[]> decryptedBytes = CryptoUtils.decrypt(splitVauMessage.getValue(), rbelKey.getKey(), 12, 16);
            if (!decryptedBytes.isPresent()) continue;
            try {
                log.trace("Succesfully deciphered VAU message! ({})", (Object)new String(decryptedBytes.get()));
                return this.buildVauMessageFromCleartext(converter, splitVauMessage, decryptedBytes.get());
            }
            catch (RuntimeException e) {
                log.error("Exception while deciphering VAU message:", e);
                throw e;
            }
        }
        return Optional.empty();
    }

    private Optional<RbelVauEpaMessage> buildVauMessageFromCleartext(RbelConverter converter, Pair<byte[], byte[]> splitVauMessage, byte[] decryptedBytes) {
        String cleartextString = new String(decryptedBytes);
        if (cleartextString.startsWith("VAUClientSigFin") || cleartextString.startsWith("VAUServerFin")) {
            return Optional.of(RbelVauEpaMessage.builder().message(converter.convertElement(new String(decryptedBytes))).encryptedMessage(splitVauMessage.getValue()).keyIdUsed(Hex.encodeHexString(splitVauMessage.getKey())).build());
        }
        return Optional.of(RbelVauDecryptionConverter.fromRaw(splitVauMessage, converter, decryptedBytes));
    }

    @Override
    public boolean canConvertElement(RbelElement element, RbelConverter context) {
        return this.decipherVauMessage(this.getBinaryContent(element), context).isPresent();
    }

    @Override
    public RbelElement convertElement(RbelElement element, RbelConverter context) {
        log.trace("Trying to decipher '{}'...", (Object)element.getContent());
        Optional<RbelVauEpaMessage> rbelVauMessage = this.decipherVauMessage(this.getBinaryContent(element), context);
        if (rbelVauMessage.isEmpty()) {
            return element;
        }
        if (element instanceof RbelNestedElement) {
            ((RbelNestedElement)element).setNestedElement(rbelVauMessage.get());
            return element;
        }
        return rbelVauMessage.get();
    }

    private byte[] getBinaryContent(RbelElement element) {
        if (element instanceof RbelBinaryElement) {
            return ((RbelBinaryElement)element).getRawData();
        }
        return Base64.getDecoder().decode(element.getContent());
    }
}

