/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.converter.brainpool.BrainpoolCurves;
import de.gematik.rbellogger.data.elements.RbelElement;
import de.gematik.rbellogger.data.elements.RbelJweElement;
import de.gematik.rbellogger.data.elements.RbelJweEncryptionInfo;
import de.gematik.rbellogger.data.elements.RbelStringElement;
import de.gematik.rbellogger.key.RbelKey;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwe.JsonWebEncryption;

public class RbelJweConverter
implements RbelConverterPlugin {
    @Override
    public boolean canConvertElement(RbelElement rbel, RbelConverter context) {
        return this.initializeJwe(rbel).isPresent();
    }

    @Override
    public RbelElement convertElement(RbelElement rbel, RbelConverter context) {
        Optional<JsonWebEncryption> jweOptional = this.initializeJwe(rbel);
        if (jweOptional.isEmpty()) {
            throw new RuntimeException("Unable to extract JWE from element");
        }
        JsonWebEncryption jwe = jweOptional.get();
        Optional<Pair<String, String>> correctKeyAndPayload = this.findCorrectKeyAndReturnPayload(context, jwe);
        if (correctKeyAndPayload.isEmpty()) {
            return new RbelJweElement(context.convertElement(jwe.getHeaders().getFullHeaderAsJsonString()), new RbelStringElement("<Encrypted Payload>"), new RbelJweEncryptionInfo(false, null));
        }
        return new RbelJweElement(context.convertElement(jwe.getHeaders().getFullHeaderAsJsonString()), context.convertElement(correctKeyAndPayload.get().getValue()), new RbelJweEncryptionInfo(true, correctKeyAndPayload.get().getKey()));
    }

    private Optional<Pair<String, String>> findCorrectKeyAndReturnPayload(RbelConverter context, JsonWebEncryption jwe) {
        for (RbelKey keyEntry : context.getRbelKeyManager().getAllKeys().collect(Collectors.toList())) {
            try {
                jwe.setKey(keyEntry.getKey());
                return Optional.of(Pair.of(keyEntry.getKeyName(), jwe.getPayload()));
            }
            catch (Exception e) {
            }
        }
        return Optional.empty();
    }

    private Optional<JsonWebEncryption> initializeJwe(RbelElement rbel) {
        JsonWebEncryption receiverJwe = new JsonWebEncryption();
        receiverJwe.setDoKeyValidation(false);
        receiverJwe.setAlgorithmConstraints(AlgorithmConstraints.NO_CONSTRAINTS);
        try {
            receiverJwe.setCompactSerialization(rbel.getContent());
            receiverJwe.getHeaders();
            return Optional.ofNullable(receiverJwe);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    static {
        BrainpoolCurves.init();
    }
}

