/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.elements.RbelElement;
import de.gematik.rbellogger.data.elements.RbelJsonElement;
import de.gematik.rbellogger.data.elements.RbelListElement;
import de.gematik.rbellogger.data.elements.RbelMapElement;
import de.gematik.rbellogger.data.elements.RbelNullElement;
import de.gematik.rbellogger.data.elements.RbelStringElement;
import de.gematik.rbellogger.exceptions.RbelConversionException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.stream.StreamSupport;

public class RbelJsonConverter
implements RbelConverterPlugin {
    @Override
    public boolean canConvertElement(RbelElement rbel, RbelConverter context) {
        String content = rbel.getContent();
        if (content.contains("{") && content.contains("}") || content.contains("[") && content.contains("]")) {
            try {
                JsonParser.parseString(rbel.getContent());
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public RbelElement convertElement(RbelElement rbel, RbelConverter context) {
        try {
            return this.jsonElementToRbelElement(JsonParser.parseString(rbel.getContent()), context, rbel);
        }
        catch (Exception e) {
            throw new RbelConversionException(e);
        }
    }

    private RbelElement jsonElementToRbelElement(JsonElement jsonElement, RbelConverter context, RbelElement parentElement) {
        if (jsonElement.isJsonObject()) {
            LinkedHashMap<String, RbelElement> elementMap = new LinkedHashMap<String, RbelElement>();
            RbelMapElement rbelMapElement = new RbelMapElement(elementMap);
            RbelJsonElement rbelJsonElement = new RbelJsonElement(rbelMapElement, jsonElement.toString());
            rbelMapElement.setParentNode(rbelJsonElement);
            rbelJsonElement.setParentNode(parentElement);
            jsonElement.getAsJsonObject().entrySet().stream().forEach(entry -> elementMap.put((String)entry.getKey(), this.jsonElementToRbelElement((JsonElement)entry.getValue(), context, rbelMapElement)));
            rbelMapElement.getChildNodes().forEach(context::triggerPostConversionListenerFor);
            return rbelJsonElement;
        }
        if (jsonElement.isJsonArray()) {
            ArrayList<RbelElement> elementList = new ArrayList<RbelElement>();
            RbelListElement rbelListElement = new RbelListElement(elementList);
            RbelJsonElement rbelJsonElement = new RbelJsonElement(rbelListElement, jsonElement.toString());
            rbelJsonElement.setParentNode(parentElement);
            rbelListElement.setParentNode(rbelJsonElement);
            StreamSupport.stream(jsonElement.getAsJsonArray().spliterator(), false).map(el -> this.jsonElementToRbelElement((JsonElement)el, context, rbelListElement)).forEach(elementList::add);
            rbelJsonElement.getJsonElement().getChildNodes().forEach(context::triggerPostConversionListenerFor);
            return rbelJsonElement;
        }
        if (jsonElement.isJsonPrimitive()) {
            RbelStringElement stringElement = new RbelStringElement(jsonElement.getAsString());
            stringElement.setParentNode(parentElement);
            RbelElement element = context.convertElement(stringElement);
            if (jsonElement.getAsJsonPrimitive().isString()) {
                element.setRawMessage("\"" + jsonElement.getAsString() + "\"");
            } else {
                element.setRawMessage(jsonElement.getAsString());
            }
            return element;
        }
        return new RbelNullElement();
    }
}

