/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.elements.RbelBinaryElement;
import de.gematik.rbellogger.data.elements.RbelElement;
import de.gematik.rbellogger.data.elements.RbelHttpResponse;
import de.gematik.rbellogger.data.elements.RbelMultiValuedMapElement;
import de.gematik.rbellogger.data.elements.RbelNestedElement;
import de.gematik.rbellogger.data.elements.RbelStringElement;
import de.gematik.rbellogger.util.BinaryClassifier;
import de.gematik.rbellogger.util.RbelArrayUtils;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RbelHttpResponseConverter
implements RbelConverterPlugin {
    private static final String eol = "\r\n";

    @Override
    public boolean canConvertElement(RbelElement rbel, RbelConverter context) {
        return (rbel instanceof RbelStringElement || rbel instanceof RbelBinaryElement) && rbel.getContent().startsWith("HTTP");
    }

    @Override
    public RbelElement convertElement(RbelElement rbel, RbelConverter context) {
        int separator = rbel.getContent().indexOf("\r\n\r\n");
        if (separator == -1) {
            throw new RuntimeException("Unexpected HTTP-Message encountered (did not find double \\r\\n break. Did you read the message from the HDD and your OS messed with the line breaks?)");
        }
        Map<String, List<RbelElement>> headerMap = Arrays.stream(rbel.getContent().substring(0, separator += 2 * eol.length()).split(eol)).filter(line -> !line.isEmpty() && !line.startsWith("HTTP")).map(line -> this.parseStringToKeyValuePair((String)line, context)).collect(Collectors.groupingBy(e -> (String)e.getKey(), Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        RbelMultiValuedMapElement header = new RbelMultiValuedMapElement(headerMap);
        byte[] bodyData = this.extractBodyData(rbel, separator, headerMap);
        boolean isBinaryData = BinaryClassifier.isBinary(bodyData);
        RbelNestedElement bodyElement = isBinaryData ? new RbelBinaryElement(bodyData) : new RbelStringElement(new String(bodyData));
        return RbelHttpResponse.builder().header(header).body(context.convertElement(bodyElement)).responseCode(Integer.parseInt(rbel.getContent().split("\\s")[1])).rawMessage(rbel.getContent()).rawBody(bodyData).build();
    }

    private byte[] extractBodyData(RbelElement rbel, int separator, Map<String, List<RbelElement>> headerMap) {
        byte[] inputData = this.getInputData(rbel);
        if (headerMap.containsKey("Transfer-Encoding") && headerMap.get("Transfer-Encoding") != null && !headerMap.get("Transfer-Encoding").isEmpty() && headerMap.get("Transfer-Encoding").get(0).getContent().equals("chunked")) {
            separator = rbel.getContent().indexOf(eol, separator) + eol.length();
            return Arrays.copyOfRange(inputData, Math.min(inputData.length, separator), RbelArrayUtils.indexOf(inputData, "\r\n0\r\n".getBytes(), separator));
        }
        return Arrays.copyOfRange(inputData, Math.min(inputData.length, separator), inputData.length);
    }

    private byte[] getInputData(RbelElement rbel) {
        if (rbel instanceof RbelBinaryElement) {
            return ((RbelBinaryElement)rbel).getRawData();
        }
        return rbel.getContent().getBytes();
    }

    protected AbstractMap.SimpleImmutableEntry<String, RbelElement> parseStringToKeyValuePair(String line, RbelConverter context) {
        int colon = line.indexOf(58);
        if (colon == -1) {
            throw new IllegalArgumentException("Header malformed: '" + line + "'");
        }
        String key = line.substring(0, colon).trim();
        RbelStringElement el = new RbelStringElement(line.substring(colon + 1).trim());
        return new AbstractMap.SimpleImmutableEntry<String, RbelElement>(key, context.convertElement(el));
    }
}

