/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelHttpResponseConverter;
import de.gematik.rbellogger.data.elements.RbelBinaryElement;
import de.gematik.rbellogger.data.elements.RbelElement;
import de.gematik.rbellogger.data.elements.RbelHttpRequest;
import de.gematik.rbellogger.data.elements.RbelMapElement;
import de.gematik.rbellogger.data.elements.RbelMultiValuedMapElement;
import de.gematik.rbellogger.data.elements.RbelStringElement;
import de.gematik.rbellogger.data.elements.RbelUriElement;
import de.gematik.rbellogger.util.BinaryClassifier;
import de.gematik.rbellogger.util.RbelArrayUtils;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RbelHttpRequestConverter
extends RbelHttpResponseConverter {
    private static final String eol = "\r\n";

    @Override
    public boolean canConvertElement(RbelElement rbel, RbelConverter context) {
        if (StringUtils.isEmpty(rbel.getContent())) {
            return false;
        }
        String firstLine = new String(this.getContent(rbel), StandardCharsets.US_ASCII).split("\n")[0].trim();
        return !(!firstLine.startsWith("GET ") && !firstLine.startsWith("POST ") && !firstLine.startsWith("PUT ") && !firstLine.startsWith("DELETE ") || !firstLine.endsWith("HTTP/1.0") && !firstLine.endsWith("HTTP/1.1") && !firstLine.endsWith("HTTP/2.0"));
    }

    @Override
    public RbelElement convertElement(RbelElement rbel, RbelConverter context) {
        byte[] messageContent = this.getContent(rbel);
        String messageHeader = new String(messageContent, StandardCharsets.US_ASCII).split("\r\n\r\n")[0];
        int space = messageHeader.indexOf(" ");
        int space2 = messageHeader.indexOf(" ", space + 1);
        String method = messageHeader.substring(0, space);
        String path = messageHeader.substring(space + 1, space2);
        String[] lines = messageHeader.split(eol);
        int bodySeparator = Arrays.asList(lines).indexOf("");
        Map<String, List<RbelElement>> headerMap = Arrays.stream(lines).limit(bodySeparator == -1 ? (long)lines.length : (long)bodySeparator).filter(line -> !line.isEmpty() && !line.startsWith(method)).map(line -> this.parseStringToKeyValuePair((String)line, context)).collect(Collectors.groupingBy(e -> (String)e.getKey(), Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        RbelMultiValuedMapElement headers = new RbelMultiValuedMapElement(headerMap);
        RbelElement pathElement = context.convertElement(path);
        if (!(pathElement instanceof RbelUriElement)) {
            throw new RuntimeException("Encountered ill-formatted path: " + path);
        }
        byte[] bodyData = this.extractBodyData(messageContent, messageHeader.length() + 4, headers);
        RbelHttpRequest rbelHttpRequest = RbelHttpRequest.builder().header(headers).body(this.convertBodyToRbelElement(bodyData, headers, context)).method(method).path((RbelUriElement)pathElement).rawMessage(rbel.getContent()).rawBody(bodyData).build();
        return rbelHttpRequest;
    }

    private byte[] extractBodyData(byte[] inputData, int separator, RbelMultiValuedMapElement headerMap) {
        if (this.hasContentTypeMatching(headerMap, "Transfer-Encoding", "chunked")) {
            separator = new String(inputData).indexOf(eol, separator) + eol.length();
            return Arrays.copyOfRange(inputData, separator, RbelArrayUtils.indexOf(inputData, "0\r\n".getBytes(), separator));
        }
        return Arrays.copyOfRange(inputData, Math.min(inputData.length, separator), inputData.length);
    }

    private byte[] getContent(RbelElement rbel) {
        if (rbel instanceof RbelBinaryElement) {
            return ((RbelBinaryElement)rbel).getRawData();
        }
        if (rbel instanceof RbelStringElement) {
            return rbel.getContent().getBytes();
        }
        throw new RuntimeException("Unhandleable Content");
    }

    private RbelElement convertBodyToRbelElement(byte[] bodyData, RbelMultiValuedMapElement headerMap, RbelConverter context) {
        if (this.hasContentTypeMatching(headerMap, "Content-Type", "application/x-www-form-urlencoded")) {
            return new RbelMapElement(Stream.of(new String(bodyData).split("&")).map(param -> param.split("=")).filter(params -> ((String[])params).length == 2).map(paramList -> Pair.of(paramList[0], context.convertElement(paramList[1]))).collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
        }
        if (BinaryClassifier.isBinary(bodyData)) {
            return context.convertElement(new RbelBinaryElement(bodyData));
        }
        return context.convertElement(new RbelStringElement(new String(bodyData)));
    }

    private boolean hasContentTypeMatching(RbelMultiValuedMapElement headerMap, String headerKey, String prefix) {
        return headerMap.getAll(headerKey).stream().map(RbelElement::getContent).anyMatch(str -> str.startsWith(prefix));
    }
}

