/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.converter.brainpool.BrainpoolCurves;
import de.gematik.rbellogger.data.elements.RbelBinaryElement;
import de.gematik.rbellogger.data.elements.RbelElement;
import de.gematik.rbellogger.data.elements.RbelNestedElement;
import de.gematik.rbellogger.data.elements.RbelVauErpMessage;
import de.gematik.rbellogger.key.RbelKey;
import de.gematik.rbellogger.util.CryptoUtils;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wiremock.org.apache.commons.codec.binary.Hex;

public class RbelErpVauDecryptionConverter
implements RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelErpVauDecryptionConverter.class);

    private Optional<byte[]> decrypt(byte[] encMessage, ECPrivateKey secretKey) {
        try {
            if (encMessage[0] != 1) {
                return Optional.empty();
            }
            ECPublicKey otherSidePublicKey = this.extractPublicKeyFromVauMessage(encMessage);
            byte[] sharedSecret = CryptoUtils.ecka(secretKey, otherSidePublicKey);
            byte[] aesKeyBytes = CryptoUtils.hkdf(sharedSecret, "ecies-vau-transport", 16);
            SecretKeySpec aesKey = new SecretKeySpec(aesKeyBytes, "AES");
            return CryptoUtils.decrypt(Arrays.copyOfRange(encMessage, 65, encMessage.length), aesKey);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private ECPublicKey extractPublicKeyFromVauMessage(byte[] encMessage) throws NoSuchAlgorithmException, InvalidKeySpecException {
        ECPoint ecPoint = new ECPoint(new BigInteger(1, Arrays.copyOfRange(encMessage, 1, 33)), new BigInteger(1, Arrays.copyOfRange(encMessage, 33, 65)));
        ECPublicKeySpec keySpec = new ECPublicKeySpec(ecPoint, BrainpoolCurves.BP256);
        return (ECPublicKey)KeyFactory.getInstance("EC").generatePublic(keySpec);
    }

    private Optional<RbelVauErpMessage> decipherVauMessage(RbelElement element, RbelConverter converter) {
        byte[] content = this.getBinaryContent(element);
        List potentialVauKeys = converter.getRbelKeyManager().getAllKeys().filter(key -> key.getKey() instanceof ECPrivateKey || key.getKey() instanceof SecretKey).collect(Collectors.toList());
        for (RbelKey rbelKey : potentialVauKeys) {
            Optional<byte[]> decryptedBytes = this.decrypt(content, rbelKey.getKey());
            if (!decryptedBytes.isPresent()) continue;
            try {
                log.trace("Succesfully deciphered VAU message! ({})", (Object)new String(decryptedBytes.get()));
                if (this.isVauResponse(decryptedBytes)) {
                    return this.buildVauMessageFromCleartextResponse(converter, decryptedBytes.get(), content, rbelKey.getKeyName());
                }
                return this.buildVauMessageFromCleartextRequest(converter, decryptedBytes.get(), content, rbelKey.getKeyName());
            }
            catch (RuntimeException e) {
                log.error("Exception while deciphering VAU message:", e);
                throw e;
            }
        }
        return Optional.empty();
    }

    private boolean isVauResponse(Optional<byte[]> decryptedBytes) {
        return decryptedBytes.map(bytes -> new String((byte[])bytes, StandardCharsets.US_ASCII)).map(s2 -> s2.split("1 [\\da-f]{32} ").length).map(length -> length > 1).orElse(false);
    }

    private Optional<byte[]> decrypt(byte[] content, Key key) {
        if (key instanceof ECPrivateKey) {
            return this.decrypt(content, (ECPrivateKey)key);
        }
        if (key instanceof SecretKey) {
            return CryptoUtils.decrypt(content, key, 12, 16);
        }
        throw new RuntimeException("Unexpected key-type encountered (" + key.getClass().getSimpleName() + ")");
    }

    private Optional<RbelVauErpMessage> buildVauMessageFromCleartextRequest(RbelConverter converter, byte[] decryptedBytes, byte[] encryptedMessage, String keyName) {
        String[] vauMessageParts = new String(decryptedBytes).split(" ", 5);
        SecretKeySpec responseKey = this.buildAesKeyFromHex(vauMessageParts[3]);
        converter.getRbelKeyManager().addKey("VAU Response-Key", responseKey, 0);
        return Optional.of(RbelVauErpMessage.builder().message(converter.convertElement(vauMessageParts[4])).encryptedMessage(encryptedMessage).requestId(vauMessageParts[2]).pVersionNumber(Integer.parseInt(vauMessageParts[0])).responseKey(responseKey).keyIdUsed(keyName).build());
    }

    private Optional<RbelVauErpMessage> buildVauMessageFromCleartextResponse(RbelConverter converter, byte[] decryptedBytes, byte[] encryptedMessage, String keyName) {
        String[] vauMessageParts = new String(decryptedBytes).split(" ", 3);
        return Optional.of(RbelVauErpMessage.builder().message(converter.convertElement(vauMessageParts[2])).encryptedMessage(encryptedMessage).requestId(vauMessageParts[1]).pVersionNumber(Integer.parseInt(vauMessageParts[0])).keyIdUsed(keyName).build());
    }

    private SecretKeySpec buildAesKeyFromHex(String hexEncodedKey) {
        try {
            return new SecretKeySpec(Hex.decodeHex(hexEncodedKey), "AES");
        }
        catch (Exception e) {
            throw new RuntimeException("Error during Key decoding", e);
        }
    }

    @Override
    public boolean canConvertElement(RbelElement element, RbelConverter context) {
        return this.decipherVauMessage(element, context).isPresent();
    }

    @Override
    public RbelElement convertElement(RbelElement element, RbelConverter context) {
        log.trace("Trying to decipher '{}'...", (Object)element.getContent());
        Optional<RbelVauErpMessage> rbelVauMessage = this.decipherVauMessage(element, context);
        if (rbelVauMessage.isEmpty()) {
            return element;
        }
        if (element instanceof RbelNestedElement) {
            ((RbelNestedElement)element).setNestedElement(rbelVauMessage.get());
            return element;
        }
        return rbelVauMessage.get();
    }

    private byte[] getBinaryContent(RbelElement element) {
        if (element instanceof RbelBinaryElement) {
            return ((RbelBinaryElement)element).getRawData();
        }
        return Base64.getDecoder().decode(element.getContent());
    }
}

