/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelBase64JsonConverter;
import de.gematik.rbellogger.converter.RbelBearerTokenConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.converter.RbelErpVauDecryptionConverter;
import de.gematik.rbellogger.converter.RbelHttpRequestConverter;
import de.gematik.rbellogger.converter.RbelHttpResponseConverter;
import de.gematik.rbellogger.converter.RbelJsonConverter;
import de.gematik.rbellogger.converter.RbelJweConverter;
import de.gematik.rbellogger.converter.RbelJwtConverter;
import de.gematik.rbellogger.converter.RbelUriConverter;
import de.gematik.rbellogger.converter.RbelValueShader;
import de.gematik.rbellogger.converter.RbelVauDecryptionConverter;
import de.gematik.rbellogger.converter.RbelXmlConverter;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.RbelMessage;
import de.gematik.rbellogger.data.elements.RbelBinaryElement;
import de.gematik.rbellogger.data.elements.RbelElement;
import de.gematik.rbellogger.data.elements.RbelHttpMessage;
import de.gematik.rbellogger.data.elements.RbelHttpRequest;
import de.gematik.rbellogger.data.elements.RbelHttpResponse;
import de.gematik.rbellogger.data.elements.RbelStringElement;
import de.gematik.rbellogger.exceptions.RbelConversionException;
import de.gematik.rbellogger.key.RbelKeyManager;
import java.beans.ConstructorProperties;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ClassUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelConverter.class);
    private final List<RbelMessage> messageHistory;
    private final RbelKeyManager rbelKeyManager;
    private final RbelValueShader rbelValueShader;
    private final Map<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>> postConversionListener;
    private final Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> preConversionMappers;
    private final List<RbelConverterPlugin> converterPlugins;
    private long messageSequenceNumber;

    public RbelElement convertElement(byte[] input) {
        return this.convertElement(new RbelBinaryElement(input));
    }

    public RbelElement convertElement(String input) {
        return this.convertElement(new RbelStringElement(input));
    }

    public RbelElement convertElement(RbelElement rawInput) {
        log.trace("Converting {}...", (Object)rawInput);
        RbelElement convertedInput = this.filterInputThroughPreConversionMappers(rawInput);
        RbelElement result = this.converterPlugins.stream().filter(plugin -> {
            try {
                return plugin.canConvertElement(convertedInput, this);
            }
            catch (Exception e) {
                return false;
            }
        }).map(plugin -> plugin.convertElement(convertedInput, this)).filter(Objects::nonNull).findFirst().orElse(convertedInput);
        if (convertedInput.getRawMessage() == null) {
            result.setRawMessage(convertedInput.getContent());
        } else {
            result.setRawMessage(convertedInput.getRawMessage());
        }
        return result;
    }

    private RbelMessage findLastRequest() {
        List<RbelMessage> messageHistory = this.getMessageHistory();
        for (int i = messageHistory.size() - 1; i >= 0; --i) {
            if (!(this.messageHistory.get(i).getHttpMessage() instanceof RbelHttpRequest)) continue;
            return this.messageHistory.get(i);
        }
        return null;
    }

    private RbelElement filterInputThroughPreConversionMappers(RbelElement input) {
        RbelElement value = input;
        for (BiFunction mapper : this.preConversionMappers.entrySet().stream().filter(entry -> input.getClass().isAssignableFrom((Class)entry.getKey())).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList())) {
            RbelElement newValue = (RbelElement)mapper.apply(value, this);
            if (newValue != value) {
                value = this.filterInputThroughPreConversionMappers(newValue);
                continue;
            }
            value = newValue;
        }
        return value;
    }

    public void registerListener(Class<? extends RbelElement> clazz, BiConsumer<RbelElement, RbelConverter> listener) {
        this.postConversionListener.computeIfAbsent(clazz, key -> new ArrayList()).add(listener);
    }

    public void triggerPostConversionListenerFor(RbelElement element) {
        ArrayList superclasses = new ArrayList(ClassUtils.getAllSuperclasses(element.getClass()));
        superclasses.add(element.getClass());
        superclasses.stream().filter(this.postConversionListener::containsKey).map(this.postConversionListener::get).flatMap(Collection::stream).forEach(consumer -> consumer.accept(element, this));
    }

    public void registerMapper(Class<? extends RbelElement> clazz, BiFunction<RbelElement, RbelConverter, RbelElement> mapper) {
        this.preConversionMappers.computeIfAbsent(clazz, key -> new ArrayList()).add(mapper);
    }

    public void addConverter(RbelConverterPlugin converter) {
        this.converterPlugins.add(converter);
    }

    public RbelMessage parseMessage(byte[] content, RbelHostname sender, RbelHostname recipient) {
        RbelElement rbelHttpMessage = this.convertElement(content);
        return this.parseMessage(rbelHttpMessage, sender, recipient);
    }

    public RbelMessage parseMessage(RbelElement rbelHttpMessage, RbelHostname sender, RbelHostname recipient) {
        RbelMessage lastRequest;
        if (!(rbelHttpMessage instanceof RbelHttpMessage)) {
            throw new RbelConversionException("Illegal type encountered: Content of http-Message was parsed as " + rbelHttpMessage.getClass().getSimpleName() + ". Expected RbelHttpMessage (Rbel can only handle HTTP messages right now)");
        }
        if (rbelHttpMessage instanceof RbelHttpResponse && (lastRequest = this.findLastRequest()) != null) {
            ((RbelHttpResponse)rbelHttpMessage).setRequest((RbelHttpRequest)lastRequest.getHttpMessage());
        }
        RbelMessage rbelMessage = RbelMessage.builder().httpMessage((RbelHttpMessage)rbelHttpMessage).recipient(recipient).sender(sender).sequenceNumber(this.messageSequenceNumber++).build();
        rbelHttpMessage.setRbelMessage(rbelMessage);
        rbelHttpMessage.triggerPostConversionListener(this);
        this.messageHistory.add(rbelMessage);
        return rbelMessage;
    }

    @Generated
    public static RbelConverterBuilder builder() {
        return new RbelConverterBuilder();
    }

    @ConstructorProperties(value={"rbelKeyManager", "rbelValueShader", "messageSequenceNumber"})
    @Generated
    private RbelConverter(RbelKeyManager rbelKeyManager, RbelValueShader rbelValueShader, long messageSequenceNumber) {
        Security.addProvider(new BouncyCastleProvider());
        this.messageHistory = new ArrayList<RbelMessage>();
        this.postConversionListener = new HashMap<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>>();
        this.preConversionMappers = new HashMap<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>>();
        this.converterPlugins = new ArrayList<RbelConverterPlugin>(List.of(new RbelHttpResponseConverter(), new RbelHttpRequestConverter(), new RbelJwtConverter(), new RbelJsonConverter(), new RbelXmlConverter(), new RbelJweConverter(), new RbelUriConverter(), new RbelBearerTokenConverter(), new RbelBase64JsonConverter(), new RbelVauDecryptionConverter(), new RbelErpVauDecryptionConverter()));
        this.messageSequenceNumber = 0L;
        this.rbelKeyManager = rbelKeyManager;
        this.rbelValueShader = rbelValueShader;
        this.messageSequenceNumber = messageSequenceNumber;
    }

    @Generated
    public List<RbelMessage> getMessageHistory() {
        return this.messageHistory;
    }

    @Generated
    public RbelKeyManager getRbelKeyManager() {
        return this.rbelKeyManager;
    }

    @Generated
    public RbelValueShader getRbelValueShader() {
        return this.rbelValueShader;
    }

    @Generated
    public Map<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>> getPostConversionListener() {
        return this.postConversionListener;
    }

    @Generated
    public Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> getPreConversionMappers() {
        return this.preConversionMappers;
    }

    @Generated
    public List<RbelConverterPlugin> getConverterPlugins() {
        return this.converterPlugins;
    }

    @Generated
    public long getMessageSequenceNumber() {
        return this.messageSequenceNumber;
    }

    @Generated
    public static class RbelConverterBuilder {
        @Generated
        private RbelKeyManager rbelKeyManager;
        @Generated
        private RbelValueShader rbelValueShader;
        @Generated
        private long messageSequenceNumber;

        @Generated
        RbelConverterBuilder() {
        }

        @Generated
        public RbelConverterBuilder rbelKeyManager(RbelKeyManager rbelKeyManager) {
            this.rbelKeyManager = rbelKeyManager;
            return this;
        }

        @Generated
        public RbelConverterBuilder rbelValueShader(RbelValueShader rbelValueShader) {
            this.rbelValueShader = rbelValueShader;
            return this;
        }

        @Generated
        public RbelConverterBuilder messageSequenceNumber(long messageSequenceNumber) {
            this.messageSequenceNumber = messageSequenceNumber;
            return this;
        }

        @Generated
        public RbelConverter build() {
            return new RbelConverter(this.rbelKeyManager, this.rbelValueShader, this.messageSequenceNumber);
        }

        @Generated
        public String toString() {
            return "RbelConverter.RbelConverterBuilder(rbelKeyManager=" + this.rbelKeyManager + ", rbelValueShader=" + this.rbelValueShader + ", messageSequenceNumber=" + this.messageSequenceNumber + ")";
        }
    }
}

