/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.captures.RbelCapturer;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.elements.RbelElement;
import de.gematik.rbellogger.key.RbelKey;
import java.beans.ConstructorProperties;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import lombok.Generated;

public class RbelConfiguration {
    private Map<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>> postConversionListener = new HashMap<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>>();
    private Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> preConversionMappers = new HashMap<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>>();
    private List<Consumer<RbelConverter>> initializers = new ArrayList<Consumer<RbelConverter>>();
    private Map<String, RbelKey> keys = new HashMap<String, RbelKey>();
    private RbelCapturer capturer;
    private boolean activateAsn1Parsing = true;

    public <T extends RbelElement> RbelConfiguration addPostConversionListener(Class<T> clazz, BiConsumer<T, RbelConverter> consumer) {
        if (!this.postConversionListener.containsKey(clazz)) {
            this.postConversionListener.put(clazz, new ArrayList());
        }
        this.postConversionListener.get(clazz).add((rawKey, context) -> consumer.accept((Object)rawKey, (RbelConverter)context));
        return this;
    }

    public <T extends RbelElement> RbelConfiguration addPreConversionMapper(Class<T> clazz, BiFunction<T, RbelConverter, RbelElement> mapper) {
        if (!this.preConversionMappers.containsKey(clazz)) {
            this.preConversionMappers.put(clazz, new ArrayList());
        }
        this.preConversionMappers.get(clazz).add((rawKey, context) -> (RbelElement)mapper.apply((Object)rawKey, (RbelConverter)context));
        return this;
    }

    public RbelConfiguration addInitializer(Consumer<RbelConverter> initializer) {
        this.initializers.add(initializer);
        return this;
    }

    public RbelConfiguration addKey(String keyId, Key key, int precedence) {
        this.keys.put(keyId, RbelKey.builder().key(key).keyName(keyId).precedence(precedence).build());
        return this;
    }

    public RbelConfiguration addCapturer(RbelCapturer capturer) {
        this.capturer = capturer;
        return this;
    }

    @Generated
    public Map<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>> getPostConversionListener() {
        return this.postConversionListener;
    }

    @Generated
    public Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> getPreConversionMappers() {
        return this.preConversionMappers;
    }

    @Generated
    public List<Consumer<RbelConverter>> getInitializers() {
        return this.initializers;
    }

    @Generated
    public Map<String, RbelKey> getKeys() {
        return this.keys;
    }

    @Generated
    public RbelCapturer getCapturer() {
        return this.capturer;
    }

    @Generated
    public boolean isActivateAsn1Parsing() {
        return this.activateAsn1Parsing;
    }

    @Generated
    public void setPostConversionListener(Map<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>> postConversionListener) {
        this.postConversionListener = postConversionListener;
    }

    @Generated
    public void setPreConversionMappers(Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> preConversionMappers) {
        this.preConversionMappers = preConversionMappers;
    }

    @Generated
    public void setInitializers(List<Consumer<RbelConverter>> initializers) {
        this.initializers = initializers;
    }

    @Generated
    public void setKeys(Map<String, RbelKey> keys) {
        this.keys = keys;
    }

    @Generated
    public void setCapturer(RbelCapturer capturer) {
        this.capturer = capturer;
    }

    @Generated
    public void setActivateAsn1Parsing(boolean activateAsn1Parsing) {
        this.activateAsn1Parsing = activateAsn1Parsing;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelConfiguration)) {
            return false;
        }
        RbelConfiguration other = (RbelConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>> this$postConversionListener = this.getPostConversionListener();
        Map<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>> other$postConversionListener = other.getPostConversionListener();
        if (this$postConversionListener == null ? other$postConversionListener != null : !((Object)this$postConversionListener).equals(other$postConversionListener)) {
            return false;
        }
        Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> this$preConversionMappers = this.getPreConversionMappers();
        Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> other$preConversionMappers = other.getPreConversionMappers();
        if (this$preConversionMappers == null ? other$preConversionMappers != null : !((Object)this$preConversionMappers).equals(other$preConversionMappers)) {
            return false;
        }
        List<Consumer<RbelConverter>> this$initializers = this.getInitializers();
        List<Consumer<RbelConverter>> other$initializers = other.getInitializers();
        if (this$initializers == null ? other$initializers != null : !((Object)this$initializers).equals(other$initializers)) {
            return false;
        }
        Map<String, RbelKey> this$keys = this.getKeys();
        Map<String, RbelKey> other$keys = other.getKeys();
        if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
            return false;
        }
        RbelCapturer this$capturer = this.getCapturer();
        RbelCapturer other$capturer = other.getCapturer();
        if (this$capturer == null ? other$capturer != null : !((Object)this$capturer).equals(other$capturer)) {
            return false;
        }
        return this.isActivateAsn1Parsing() == other.isActivateAsn1Parsing();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>> $postConversionListener = this.getPostConversionListener();
        result = result * 59 + ($postConversionListener == null ? 43 : ((Object)$postConversionListener).hashCode());
        Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> $preConversionMappers = this.getPreConversionMappers();
        result = result * 59 + ($preConversionMappers == null ? 43 : ((Object)$preConversionMappers).hashCode());
        List<Consumer<RbelConverter>> $initializers = this.getInitializers();
        result = result * 59 + ($initializers == null ? 43 : ((Object)$initializers).hashCode());
        Map<String, RbelKey> $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        RbelCapturer $capturer = this.getCapturer();
        result = result * 59 + ($capturer == null ? 43 : ((Object)$capturer).hashCode());
        result = result * 59 + (this.isActivateAsn1Parsing() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "RbelConfiguration(postConversionListener=" + this.getPostConversionListener() + ", preConversionMappers=" + this.getPreConversionMappers() + ", initializers=" + this.getInitializers() + ", keys=" + this.getKeys() + ", capturer=" + this.getCapturer() + ", activateAsn1Parsing=" + this.isActivateAsn1Parsing() + ")";
    }

    @ConstructorProperties(value={"postConversionListener", "preConversionMappers", "initializers", "keys", "capturer", "activateAsn1Parsing"})
    @Generated
    public RbelConfiguration(Map<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>> postConversionListener, Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> preConversionMappers, List<Consumer<RbelConverter>> initializers, Map<String, RbelKey> keys, RbelCapturer capturer, boolean activateAsn1Parsing) {
        this.postConversionListener = postConversionListener;
        this.preConversionMappers = preConversionMappers;
        this.initializers = initializers;
        this.keys = keys;
        this.capturer = capturer;
        this.activateAsn1Parsing = activateAsn1Parsing;
    }

    @Generated
    public RbelConfiguration() {
    }
}

