/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.elements.RbelAsn1Element;
import de.gematik.rbellogger.data.elements.RbelBinaryElement;
import de.gematik.rbellogger.data.elements.RbelBooleanElement;
import de.gematik.rbellogger.data.elements.RbelDateTimeElement;
import de.gematik.rbellogger.data.elements.RbelElement;
import de.gematik.rbellogger.data.elements.RbelIntegerElement;
import de.gematik.rbellogger.data.elements.RbelListElement;
import de.gematik.rbellogger.data.elements.RbelMapElement;
import de.gematik.rbellogger.data.elements.RbelStringElement;
import de.gematik.rbellogger.util.RbelException;
import java.text.ParseException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.util.Iterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelAsn1Converter
implements RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelAsn1Converter.class);

    @Override
    public boolean canConvertElement(RbelElement rbel, RbelConverter context) {
        return true;
    }

    @Override
    public RbelElement convertElement(RbelElement rbel, RbelConverter context) {
        return this.convertElementToAsn1Optional(rbel, context).orElse(null);
    }

    private Optional<RbelAsn1Element> convertElementToAsn1Optional(RbelElement rbel, RbelConverter context) {
        return Optional.ofNullable(rbel).filter(RbelBinaryElement.class::isInstance).map(RbelBinaryElement.class::cast).map(RbelBinaryElement::getRawData).flatMap(data -> this.tryToParseAsn1Structure((byte[])data, context)).or(() -> this.safeConvertBase64Using(rbel.getContent(), Base64.getDecoder(), context)).or(() -> this.safeConvertBase64Using(rbel.getContent(), Base64.getUrlDecoder(), context)).or(() -> this.safeConvertBase64Using(rbel.getContent(), Base64.getMimeDecoder(), context));
    }

    private Optional<RbelAsn1Element> safeConvertBase64Using(String input, Base64.Decoder decoder, RbelConverter context) {
        try {
            return Optional.ofNullable(decoder.decode(input)).flatMap(data -> this.tryToParseAsn1Structure((byte[])data, context));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<RbelAsn1Element> tryToParseAsn1Structure(byte[] data, RbelConverter converter) {
        try (ASN1InputStream input = new ASN1InputStream(data);){
            ASN1Primitive primitive = input.readObject();
            if (primitive != null) {
                ASN1Sequence asn1 = ASN1Sequence.getInstance(primitive);
                RbelAsn1Element asn1Element = this.encaseAsn1Element(asn1, converter);
                if (input.available() != 0) {
                    log.warn("Found a ASN.1-Stream with more then a single element. The rest of the element will be skipped");
                    asn1Element.setUnparsedBytes(input.readAllBytes());
                }
                Optional<RbelAsn1Element> optional = Optional.of(asn1Element);
                return optional;
            }
            Optional<RbelAsn1Element> optional = Optional.empty();
            return optional;
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private RbelAsn1Element encaseAsn1Element(ASN1Encodable asn1, RbelConverter converter) {
        if (asn1 instanceof ASN1Sequence || asn1 instanceof ASN1Set) {
            ArrayList<RbelElement> rbelSequence = new ArrayList<RbelElement>();
            for (ASN1Encodable encodable : (Iterable)((Object)asn1)) {
                rbelSequence.add(this.encaseAsn1Element(encodable, converter));
            }
            return new RbelAsn1Element(asn1, new RbelListElement(rbelSequence));
        }
        if (asn1 instanceof ASN1TaggedObject) {
            return new RbelAsn1Element(asn1, new RbelMapElement(Map.of("tag", new RbelIntegerElement(((ASN1TaggedObject)asn1).getTagNo()), "content", this.encaseAsn1Element(((ASN1TaggedObject)asn1).getObject(), converter))));
        }
        if (asn1 instanceof ASN1Integer) {
            return new RbelAsn1Element(asn1, new RbelIntegerElement(((ASN1Integer)asn1).getValue()));
        }
        if (asn1 instanceof ASN1ObjectIdentifier) {
            return new RbelAsn1Element(asn1, converter.convertElement(((ASN1ObjectIdentifier)asn1).getId()));
        }
        if (asn1 instanceof ASN1OctetString) {
            return new RbelAsn1Element(asn1, converter.convertElement(((ASN1OctetString)asn1).getOctets()));
        }
        if (asn1 instanceof ASN1BitString) {
            return new RbelAsn1Element(asn1, converter.convertElement(((ASN1BitString)asn1).getOctets()));
        }
        if (asn1 instanceof ASN1String) {
            return new RbelAsn1Element(asn1, converter.convertElement(((ASN1String)((Object)asn1)).getString()));
        }
        if (asn1 instanceof ASN1Boolean) {
            return new RbelAsn1Element(asn1, new RbelBooleanElement(((ASN1Boolean)asn1).isTrue()));
        }
        if (asn1 instanceof ASN1Null) {
            return new RbelAsn1Element(asn1, new RbelStringElement("Real ASN.1 null"));
        }
        if (asn1 instanceof ASN1UTCTime) {
            try {
                return new RbelAsn1Element(asn1, new RbelDateTimeElement(ZonedDateTime.ofInstant(((ASN1UTCTime)asn1).getAdjustedDate().toInstant(), ZoneId.of("UTC"))));
            }
            catch (ParseException e) {
                throw new RbelException("Error during time-conversion of " + asn1, e);
            }
        }
        log.warn("Unable to parse {}, using fallback Null...", (Object)asn1.getClass().getSimpleName());
        return new RbelAsn1Element(asn1, new RbelStringElement("fuck"));
    }
}

