/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger;

import de.gematik.rbellogger.captures.RbelCapturer;
import de.gematik.rbellogger.converter.RbelAsn1Converter;
import de.gematik.rbellogger.converter.RbelConfiguration;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelValueShader;
import de.gematik.rbellogger.converter.listener.RbelVauKeyDeriver;
import de.gematik.rbellogger.converter.listener.RbelX5cKeyReader;
import de.gematik.rbellogger.data.RbelMessage;
import de.gematik.rbellogger.data.elements.RbelElement;
import de.gematik.rbellogger.data.elements.RbelMapElement;
import de.gematik.rbellogger.data.elements.RbelNestedJsonElement;
import de.gematik.rbellogger.key.RbelKeyManager;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import lombok.Generated;

public class RbelLogger {
    private final RbelConverter rbelConverter;
    private final RbelCapturer rbelCapturer;
    private final RbelValueShader valueShader;
    private final RbelKeyManager rbelKeyManager;

    public static RbelLogger build() {
        return RbelLogger.build(new RbelConfiguration());
    }

    public static RbelLogger build(RbelConfiguration configuration) {
        Objects.requireNonNull(configuration);
        RbelConverter rbelConverter = RbelConverter.builder().rbelKeyManager(new RbelKeyManager()).rbelValueShader(new RbelValueShader()).build();
        rbelConverter.registerListener(RbelElement.class, (el, conv) -> {
            if (el.getRbelMessage() == null && el.getParentNode() != null) {
                el.setRbelMessage(el.getParentNode().getRbelMessage());
            }
        });
        rbelConverter.registerListener(RbelMapElement.class, new RbelX5cKeyReader());
        rbelConverter.registerListener(RbelNestedJsonElement.class, new RbelVauKeyDeriver());
        if (configuration.getPostConversionListener() != null) {
            configuration.getPostConversionListener().entrySet().stream().forEach(entry -> ((List)entry.getValue()).stream().forEach(listener -> rbelConverter.registerListener((Class)entry.getKey(), (BiConsumer<RbelElement, RbelConverter>)listener)));
            rbelConverter.getPostConversionListener().putAll(configuration.getPostConversionListener());
        }
        if (configuration.getPreConversionMappers() != null) {
            configuration.getPreConversionMappers().entrySet().stream().forEach(entry -> ((List)entry.getValue()).stream().forEach(listener -> rbelConverter.registerMapper((Class)entry.getKey(), (BiFunction<RbelElement, RbelConverter, RbelElement>)listener)));
            rbelConverter.getPostConversionListener().putAll(configuration.getPostConversionListener());
        }
        rbelConverter.registerListener(RbelElement.class, rbelConverter.getRbelValueShader().getPostConversionListener());
        for (Consumer<RbelConverter> initializer : configuration.getInitializers()) {
            initializer.accept(rbelConverter);
        }
        rbelConverter.getRbelKeyManager().addAll(configuration.getKeys());
        if (configuration.getCapturer() != null) {
            configuration.getCapturer().setRbelConverter(rbelConverter);
        }
        if (configuration.isActivateAsn1Parsing()) {
            rbelConverter.addConverter(new RbelAsn1Converter());
        }
        return RbelLogger.builder().rbelConverter(rbelConverter).rbelCapturer(configuration.getCapturer()).rbelKeyManager(rbelConverter.getRbelKeyManager()).valueShader(rbelConverter.getRbelValueShader()).build();
    }

    public List<RbelMessage> getMessageHistory() {
        return this.rbelConverter.getMessageHistory();
    }

    @Generated
    private static RbelLoggerBuilder builder() {
        return new RbelLoggerBuilder();
    }

    @Generated
    public RbelConverter getRbelConverter() {
        return this.rbelConverter;
    }

    @Generated
    public RbelCapturer getRbelCapturer() {
        return this.rbelCapturer;
    }

    @Generated
    public RbelValueShader getValueShader() {
        return this.valueShader;
    }

    @Generated
    public RbelKeyManager getRbelKeyManager() {
        return this.rbelKeyManager;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelLogger)) {
            return false;
        }
        RbelLogger other = (RbelLogger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RbelConverter this$rbelConverter = this.getRbelConverter();
        RbelConverter other$rbelConverter = other.getRbelConverter();
        if (this$rbelConverter == null ? other$rbelConverter != null : !this$rbelConverter.equals(other$rbelConverter)) {
            return false;
        }
        RbelCapturer this$rbelCapturer = this.getRbelCapturer();
        RbelCapturer other$rbelCapturer = other.getRbelCapturer();
        if (this$rbelCapturer == null ? other$rbelCapturer != null : !((Object)this$rbelCapturer).equals(other$rbelCapturer)) {
            return false;
        }
        RbelValueShader this$valueShader = this.getValueShader();
        RbelValueShader other$valueShader = other.getValueShader();
        if (this$valueShader == null ? other$valueShader != null : !((Object)this$valueShader).equals(other$valueShader)) {
            return false;
        }
        RbelKeyManager this$rbelKeyManager = this.getRbelKeyManager();
        RbelKeyManager other$rbelKeyManager = other.getRbelKeyManager();
        return !(this$rbelKeyManager == null ? other$rbelKeyManager != null : !this$rbelKeyManager.equals(other$rbelKeyManager));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelLogger;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RbelConverter $rbelConverter = this.getRbelConverter();
        result = result * 59 + ($rbelConverter == null ? 43 : $rbelConverter.hashCode());
        RbelCapturer $rbelCapturer = this.getRbelCapturer();
        result = result * 59 + ($rbelCapturer == null ? 43 : ((Object)$rbelCapturer).hashCode());
        RbelValueShader $valueShader = this.getValueShader();
        result = result * 59 + ($valueShader == null ? 43 : ((Object)$valueShader).hashCode());
        RbelKeyManager $rbelKeyManager = this.getRbelKeyManager();
        result = result * 59 + ($rbelKeyManager == null ? 43 : $rbelKeyManager.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelLogger(rbelConverter=" + this.getRbelConverter() + ", rbelCapturer=" + this.getRbelCapturer() + ", valueShader=" + this.getValueShader() + ", rbelKeyManager=" + this.getRbelKeyManager() + ")";
    }

    @ConstructorProperties(value={"rbelConverter", "rbelCapturer", "valueShader", "rbelKeyManager"})
    @Generated
    private RbelLogger(RbelConverter rbelConverter, RbelCapturer rbelCapturer, RbelValueShader valueShader, RbelKeyManager rbelKeyManager) {
        this.rbelConverter = rbelConverter;
        this.rbelCapturer = rbelCapturer;
        this.valueShader = valueShader;
        this.rbelKeyManager = rbelKeyManager;
    }

    @Generated
    private static class RbelLoggerBuilder {
        @Generated
        private RbelConverter rbelConverter;
        @Generated
        private RbelCapturer rbelCapturer;
        @Generated
        private RbelValueShader valueShader;
        @Generated
        private RbelKeyManager rbelKeyManager;

        @Generated
        RbelLoggerBuilder() {
        }

        @Generated
        private RbelLoggerBuilder rbelConverter(RbelConverter rbelConverter) {
            this.rbelConverter = rbelConverter;
            return this;
        }

        @Generated
        private RbelLoggerBuilder rbelCapturer(RbelCapturer rbelCapturer) {
            this.rbelCapturer = rbelCapturer;
            return this;
        }

        @Generated
        private RbelLoggerBuilder valueShader(RbelValueShader valueShader) {
            this.valueShader = valueShader;
            return this;
        }

        @Generated
        private RbelLoggerBuilder rbelKeyManager(RbelKeyManager rbelKeyManager) {
            this.rbelKeyManager = rbelKeyManager;
            return this;
        }

        @Generated
        private RbelLogger build() {
            return new RbelLogger(this.rbelConverter, this.rbelCapturer, this.valueShader, this.rbelKeyManager);
        }

        @Generated
        public String toString() {
            return "RbelLogger.RbelLoggerBuilder(rbelConverter=" + this.rbelConverter + ", rbelCapturer=" + this.rbelCapturer + ", valueShader=" + this.valueShader + ", rbelKeyManager=" + this.rbelKeyManager + ")";
        }
    }
}

