/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Optional;

public class RbelPkiIdentity {
    private X509Certificate certificate;
    private PrivateKey privateKey;
    private Optional<String> keyId;

    public static RbelPkiIdentityBuilder builder() {
        return new RbelPkiIdentityBuilder();
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public Optional<String> getKeyId() {
        return this.keyId;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public void setKeyId(Optional<String> keyId) {
        this.keyId = keyId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelPkiIdentity)) {
            return false;
        }
        RbelPkiIdentity other = (RbelPkiIdentity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        X509Certificate this$certificate = this.getCertificate();
        X509Certificate other$certificate = other.getCertificate();
        if (this$certificate == null ? other$certificate != null : !((Object)this$certificate).equals(other$certificate)) {
            return false;
        }
        PrivateKey this$privateKey = this.getPrivateKey();
        PrivateKey other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        Optional<String> this$keyId = this.getKeyId();
        Optional<String> other$keyId = other.getKeyId();
        return !(this$keyId == null ? other$keyId != null : !((Object)this$keyId).equals(other$keyId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RbelPkiIdentity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        X509Certificate $certificate = this.getCertificate();
        result = result * 59 + ($certificate == null ? 43 : ((Object)$certificate).hashCode());
        PrivateKey $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        Optional<String> $keyId = this.getKeyId();
        result = result * 59 + ($keyId == null ? 43 : ((Object)$keyId).hashCode());
        return result;
    }

    public String toString() {
        return "RbelPkiIdentity(certificate=" + this.getCertificate() + ", privateKey=" + this.getPrivateKey() + ", keyId=" + this.getKeyId() + ")";
    }

    public RbelPkiIdentity(X509Certificate certificate, PrivateKey privateKey, Optional<String> keyId) {
        this.certificate = certificate;
        this.privateKey = privateKey;
        this.keyId = keyId;
    }

    public RbelPkiIdentity() {
    }

    public static class RbelPkiIdentityBuilder {
        private X509Certificate certificate;
        private PrivateKey privateKey;
        private Optional<String> keyId;

        RbelPkiIdentityBuilder() {
        }

        public RbelPkiIdentityBuilder certificate(X509Certificate certificate) {
            this.certificate = certificate;
            return this;
        }

        public RbelPkiIdentityBuilder privateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public RbelPkiIdentityBuilder keyId(Optional<String> keyId) {
            this.keyId = keyId;
            return this;
        }

        public RbelPkiIdentity build() {
            return new RbelPkiIdentity(this.certificate, this.privateKey, this.keyId);
        }

        public String toString() {
            return "RbelPkiIdentity.RbelPkiIdentityBuilder(certificate=" + this.certificate + ", privateKey=" + this.privateKey + ", keyId=" + this.keyId + ")";
        }
    }
}

