/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter.listener;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelJsonElement;
import de.gematik.rbellogger.data.RbelListElement;
import de.gematik.rbellogger.data.RbelMapElement;
import de.gematik.rbellogger.key.RbelKey;
import de.gematik.rbellogger.util.CryptoLoader;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiConsumer;

public class RbelX5cKeyReader
implements BiConsumer<RbelElement, RbelConverter> {
    @Override
    public void accept(RbelElement rbelElement, RbelConverter converter) {
        Optional<RbelMapElement> keyMap = Optional.ofNullable(rbelElement).map(RbelMapElement.class::cast).filter(map -> map.getElementMap().containsKey("x5c"));
        if (keyMap.isPresent()) {
            Optional<String> x509Certificate = this.getX509Certificate(keyMap);
            Optional<String> keyId = this.getKeyId(keyMap);
            if (keyId.isPresent() && x509Certificate.isPresent()) {
                X509Certificate certificate = CryptoLoader.getCertificateFromPem(Base64.getDecoder().decode(x509Certificate.get()));
                converter.getRbelKeyManager().addKey(keyId.get(), certificate.getPublicKey(), RbelKey.PRECEDENCE_X5C_HEADER_VALUE);
            }
        }
    }

    private Optional<String> getKeyId(Optional<RbelMapElement> keyMap) {
        return keyMap.filter(map -> map.getElementMap().containsKey("kid")).map(map -> map.getElementMap().get("kid")).map(RbelElement::getContent);
    }

    private Optional<String> getX509Certificate(Optional<RbelMapElement> keyMap) {
        return keyMap.map(map -> map.getElementMap().get("x5c")).filter(RbelJsonElement.class::isInstance).map(RbelJsonElement.class::cast).map(RbelJsonElement::getJsonElement).filter(RbelListElement.class::isInstance).map(RbelListElement.class::cast).map(RbelListElement::getElementList).stream().flatMap(Collection::stream).map(RbelElement::getContent).findFirst();
    }
}

