/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelXmlElement;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Text;
import org.dom4j.tree.AbstractBranch;

public class RbelXmlConverter
implements RbelConverterPlugin {
    private static final String XML_TEXT_KEY = "text";

    @Override
    public boolean canConvertElement(RbelElement rbel, RbelConverter context) {
        try {
            DocumentHelper.parseText((String)rbel.getContent());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public RbelElement convertElement(RbelElement rbel, RbelConverter context) {
        try {
            return this.buildXmlElementForNode((Branch)DocumentHelper.parseText((String)rbel.getContent()), context);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private RbelXmlElement buildXmlElementForNode(Branch branch, RbelConverter converter) {
        RbelXmlElement result = new RbelXmlElement(branch);
        for (Object child : branch.content()) {
            String childXmlName;
            if (child instanceof Text) {
                result.put(XML_TEXT_KEY, converter.convertMessage(((Text)child).getText()));
                continue;
            }
            if (child instanceof AbstractBranch) {
                childXmlName = ((AbstractBranch)child).getName();
                result.put(childXmlName, this.buildXmlElementForNode((Branch)((AbstractBranch)child), converter));
                continue;
            }
            if (child instanceof Namespace) {
                childXmlName = ((Namespace)child).getPrefix();
                result.put(childXmlName, converter.convertMessage(((Namespace)child).getText()));
                continue;
            }
            throw new RuntimeException("Could not convert XML element of type " + child.getClass().getSimpleName());
        }
        if (branch instanceof Element) {
            for (Object attribute : ((Element)branch).attributes()) {
                if (!(attribute instanceof Attribute)) {
                    throw new RuntimeException("Could not convert XML attribute of type " + attribute.getClass().getSimpleName());
                }
                result.put(((Attribute)attribute).getName(), converter.convertMessage(((Attribute)attribute).getText()));
            }
        }
        return result;
    }
}

