/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelJsonConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelStringElement;
import java.util.Base64;
import java.util.Optional;

public class RbelBase64JsonConverter
extends RbelJsonConverter {
    @Override
    public boolean canConvertElement(RbelElement rbel, RbelConverter context) {
        return this.safeConvertBase64Using(rbel.getContent(), Base64.getDecoder(), context).or(() -> this.safeConvertBase64Using(rbel.getContent(), Base64.getUrlDecoder(), context)).or(() -> this.safeConvertBase64Using(rbel.getContent(), Base64.getMimeDecoder(), context)).isPresent();
    }

    @Override
    public RbelElement convertElement(RbelElement rbel, RbelConverter context) {
        return this.safeConvertBase64Using(rbel.getContent(), Base64.getDecoder(), context).or(() -> this.safeConvertBase64Using(rbel.getContent(), Base64.getUrlDecoder(), context)).or(() -> this.safeConvertBase64Using(rbel.getContent(), Base64.getMimeDecoder(), context)).orElseThrow();
    }

    private Optional<RbelElement> safeConvertBase64Using(String input, Base64.Decoder decoder, RbelConverter context) {
        try {
            return Optional.ofNullable(decoder.decode(input)).filter(json -> super.canConvertElement(new RbelStringElement(new String((byte[])json)), context)).map(json -> super.convertElement(new RbelStringElement(new String((byte[])json)), context));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

