/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.apps;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.captures.PCapCapture;
import de.gematik.rbellogger.captures.RbelCapturer;
import de.gematik.rbellogger.captures.WiremockCapture;
import de.gematik.rbellogger.converter.RbelConfiguration;
import de.gematik.rbellogger.converter.initializers.RbelKeyFolderInitializer;
import de.gematik.rbellogger.data.RbelJweElement;
import de.gematik.rbellogger.key.RbelKey;
import de.gematik.rbellogger.key.RbelKeyManager;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.Pcaps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wiremock.org.apache.commons.codec.digest.DigestUtils;

public class RbelLoggerApplication {
    private static final Logger log = LoggerFactory.getLogger(RbelLoggerApplication.class);
    @Parameter(names={"-device", "-d"}, description="Listen on PCAP-Device. (Starts the application in PCAP-mode)")
    private String deviceName;
    @Parameter(names={"-keyFolder"}, description="A folder to be scanned for key-material. Default is '.'. P12-Files in this folder are collected and will be used to decipher object or check signatures.")
    private String keyFolder = ".";
    @Parameter(names={"-list-devices"}, description="List all available PCAP-devices.")
    private boolean listDevices;
    @Parameter(names={"-pcap"}, description="Read the data from the following pcap-file. (Starts the application in offline-PCAP-mode)")
    private String pcapFile;
    @Parameter(names={"-filter"}, description="Define a filter for a PCAP-capture")
    private String filter;
    @Parameter(names={"--proxyFor", "-p"}, description="Start a proxy server for the given url. (Starts the application in Wiremock-Mode)")
    private String proxyFor;
    @Parameter(names={"-dump"}, description="Should the captured messages be print to standard-out immediately?")
    private boolean printMessageToSystemOut;
    @Parameter(names={"-html"}, description="Write the captured traffic to the following file. Default is 'out.html'.")
    private String htmlFile;
    @Parameter(names={"-h", "--help", "-?"}, description="Show help")
    private boolean help;

    public static void main(String[] args) {
        RbelLoggerApplication.setWindowsNpcapPath();
        RbelLoggerApplication main = new RbelLoggerApplication();
        JCommander jCommander = JCommander.newBuilder().addObject((Object)main).build();
        jCommander.parse(args);
        if (main.help) {
            jCommander.usage();
            return;
        }
        main.run();
    }

    private static void setWindowsNpcapPath() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            Object prop = System.getProperty("jna.library.path");
            prop = prop == null || ((String)prop).isEmpty() ? "C:/Windows/System32/Npcap" : (String)prop + ";C:/Windows/System32/Npcap";
            System.setProperty("jna.library.path", (String)prop);
        }
    }

    public void run() {
        if (this.printMessageToSystemOut) {
            log.info("Activated system out channel");
        }
        if (this.listDevices) {
            this.printAllPcapDevicesToSystemOut();
            return;
        }
        RbelLogger rbelLogger = RbelLogger.build(new RbelConfiguration().addKey("IDP symmetricEncryptionKey", new SecretKeySpec(DigestUtils.sha256((String)"geheimerSchluesselDerNochGehashtWird"), "AES"), RbelKey.PRECEDENCE_KEY_FOLDER).addInitializer(new RbelKeyFolderInitializer(this.keyFolder)).addPostConversionListener(RbelJweElement.class, RbelKeyManager.RBEL_IDP_TOKEN_KEY_LISTENER).addCapturer(this.getCapturer()));
        if (StringUtils.isNotBlank((CharSequence)this.htmlFile)) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    FileUtils.writeStringToFile((File)new File(this.htmlFile), (String)RbelHtmlRenderer.render(rbelLogger.getMessageHistory()), (Charset)Charset.defaultCharset());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                log.info("Saved HTML report to " + new File(this.htmlFile).getAbsolutePath());
            }));
        }
        while (true) {
            try {
                while (true) {
                    Thread.sleep(10L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private RbelCapturer getCapturer() {
        if (StringUtils.isNotBlank((CharSequence)this.deviceName)) {
            return PCapCapture.builder().printMessageToSystemOut(true).deviceName(this.deviceName).filter(this.filter).build();
        }
        if (StringUtils.isNotBlank((CharSequence)this.proxyFor)) {
            return WiremockCapture.builder().proxyFor(this.proxyFor).build();
        }
        throw new IllegalStateException("Either deviceName or proxyFor has to be set!");
    }

    private void printAllPcapDevicesToSystemOut() throws PcapNativeException {
        Pcaps.findAllDevs().forEach(dev -> log.info((dev.isUp() ? "UP " : "DOWN ") + dev.getName() + " - " + dev.getDescription()));
    }

    private static String $default$htmlFile() {
        return "out.html";
    }

    private static boolean $default$help() {
        return false;
    }

    public static RbelLoggerApplicationBuilder builder() {
        return new RbelLoggerApplicationBuilder();
    }

    public RbelLoggerApplication() {
        this.htmlFile = RbelLoggerApplication.$default$htmlFile();
        this.help = RbelLoggerApplication.$default$help();
    }

    public RbelLoggerApplication(String deviceName, String keyFolder, boolean listDevices, String pcapFile, String filter, String proxyFor, boolean printMessageToSystemOut, String htmlFile, boolean help) {
        this.deviceName = deviceName;
        this.keyFolder = keyFolder;
        this.listDevices = listDevices;
        this.pcapFile = pcapFile;
        this.filter = filter;
        this.proxyFor = proxyFor;
        this.printMessageToSystemOut = printMessageToSystemOut;
        this.htmlFile = htmlFile;
        this.help = help;
    }

    public static class RbelLoggerApplicationBuilder {
        private String deviceName;
        private String keyFolder;
        private boolean listDevices;
        private String pcapFile;
        private String filter;
        private String proxyFor;
        private boolean printMessageToSystemOut;
        private boolean htmlFile$set;
        private String htmlFile$value;
        private boolean help$set;
        private boolean help$value;

        RbelLoggerApplicationBuilder() {
        }

        public RbelLoggerApplicationBuilder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public RbelLoggerApplicationBuilder keyFolder(String keyFolder) {
            this.keyFolder = keyFolder;
            return this;
        }

        public RbelLoggerApplicationBuilder listDevices(boolean listDevices) {
            this.listDevices = listDevices;
            return this;
        }

        public RbelLoggerApplicationBuilder pcapFile(String pcapFile) {
            this.pcapFile = pcapFile;
            return this;
        }

        public RbelLoggerApplicationBuilder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public RbelLoggerApplicationBuilder proxyFor(String proxyFor) {
            this.proxyFor = proxyFor;
            return this;
        }

        public RbelLoggerApplicationBuilder printMessageToSystemOut(boolean printMessageToSystemOut) {
            this.printMessageToSystemOut = printMessageToSystemOut;
            return this;
        }

        public RbelLoggerApplicationBuilder htmlFile(String htmlFile) {
            this.htmlFile$value = htmlFile;
            this.htmlFile$set = true;
            return this;
        }

        public RbelLoggerApplicationBuilder help(boolean help) {
            this.help$value = help;
            this.help$set = true;
            return this;
        }

        public RbelLoggerApplication build() {
            String htmlFile$value = this.htmlFile$value;
            if (!this.htmlFile$set) {
                htmlFile$value = RbelLoggerApplication.$default$htmlFile();
            }
            boolean help$value = this.help$value;
            if (!this.help$set) {
                help$value = RbelLoggerApplication.$default$help();
            }
            return new RbelLoggerApplication(this.deviceName, this.keyFolder, this.listDevices, this.pcapFile, this.filter, this.proxyFor, this.printMessageToSystemOut, htmlFile$value, help$value);
        }

        public String toString() {
            return "RbelLoggerApplication.RbelLoggerApplicationBuilder(deviceName=" + this.deviceName + ", keyFolder=" + this.keyFolder + ", listDevices=" + this.listDevices + ", pcapFile=" + this.pcapFile + ", filter=" + this.filter + ", proxyFor=" + this.proxyFor + ", printMessageToSystemOut=" + this.printMessageToSystemOut + ", htmlFile$value=" + this.htmlFile$value + ", help$value=" + this.help$value + ")";
        }
    }
}

