/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.jnetpcap.util.JLogger;
import org.jnetpcap.util.config.ConfigString;
import org.jnetpcap.util.config.JConfig;

public class TestExpandableString
extends TestCase {
    private static final String COMPANY = "ACNE, Inc.";
    private static final String JNP = "org.jnetpcap";
    private static final String SUFFIX = ".ext";
    private static Map<String, String> variables;
    private static Properties properties;
    private static Logger logger;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        logger.setLevel(Level.OFF);
    }

    public void testName() {
        ConfigString configString = new ConfigString("${name}", variables, properties);
        TestExpandableString.assertTrue((String)"sub failed in expand", (boolean)configString.expand("mark"));
        TestExpandableString.assertEquals((String)"mark", (String)configString.toString());
        configString.reset();
    }

    public void testNameTwice() {
        ConfigString configString = new ConfigString("${name}${name}", variables, properties);
        TestExpandableString.assertTrue((String)"sub failed in expand", (boolean)configString.expand("mark"));
        TestExpandableString.assertEquals((String)"markmark", (String)configString.toString());
        configString.reset();
    }

    public void testNameTrice() {
        ConfigString configString = new ConfigString("${name}${name}-.sdfo.${name}", variables, properties);
        TestExpandableString.assertTrue((String)"sub failed in expand", (boolean)configString.expand("mark"));
        TestExpandableString.assertEquals((String)"markmark-.sdfo.mark", (String)configString.toString());
        configString.reset();
    }

    public void testOneVariable() {
        ConfigString configString = new ConfigString("${jnp}", variables, properties);
        TestExpandableString.assertTrue((String)"sub failed in expand", (boolean)configString.expand("mark", variables));
        TestExpandableString.assertEquals((String)JNP, (String)configString.toString());
        configString.reset();
    }

    public void testNameAndOneVariable() {
        ConfigString configString = new ConfigString("${jnp}.${name}", variables, properties);
        TestExpandableString.assertTrue((String)"sub failed in expand", (boolean)configString.expand("mark", variables));
        TestExpandableString.assertEquals((String)"org.jnetpcap.mark", (String)configString.toString());
        configString.reset();
    }

    public void testNameAndTwoVariables() {
        ConfigString configString = new ConfigString("${jnp}.${name}_${company}", variables, properties);
        TestExpandableString.assertTrue((String)"sub failed in expand", (boolean)configString.expand("mark", variables));
        TestExpandableString.assertEquals((String)"org.jnetpcap.mark_ACNE, Inc.", (String)configString.toString());
        configString.reset();
    }

    public void testTwoNamesAndTwoVariables() {
        ConfigString configString = new ConfigString("${jnp}.${name}_${company} ${name}", variables, properties);
        TestExpandableString.assertTrue((String)"sub failed in expand", (boolean)configString.expand("mark", variables));
        TestExpandableString.assertEquals((String)"org.jnetpcap.mark_ACNE, Inc. mark", (String)configString.toString());
        configString.reset();
    }

    public void testOneProperty() {
        ConfigString configString = new ConfigString("before @{a.b} after", variables, properties);
        TestExpandableString.assertTrue((String)"sub failed in expand", (boolean)configString.expand("mark", properties));
        TestExpandableString.assertEquals((String)"before A.B after", (String)configString.toString());
        configString.reset();
    }

    public void testTwoProperties() {
        ConfigString configString = new ConfigString("before @{a.b} after @{a.b.c}", variables, properties);
        TestExpandableString.assertTrue((String)"sub failed in expand", (boolean)configString.expand("mark", properties));
        TestExpandableString.assertEquals((String)"before A.B after A.B.C", (String)configString.toString());
        configString.reset();
    }

    public void testTwoSameProperties() {
        ConfigString configString = new ConfigString("before @{a.b} after @{a.b}", variables, properties);
        TestExpandableString.assertTrue((String)"sub failed in expand", (boolean)configString.expand("mark", properties));
        TestExpandableString.assertEquals((String)"before A.B after A.B", (String)configString.toString());
        configString.reset();
    }

    public void testOneNameAndTwoProperties() {
        ConfigString configString = new ConfigString("before @{a.b} ${name} @{a.b.c}", variables, properties);
        TestExpandableString.assertTrue((String)"sub failed in expand", (boolean)configString.expand("mark", properties));
        TestExpandableString.assertEquals((String)"before A.B mark A.B.C", (String)configString.toString());
        configString.reset();
    }

    public void testNameWithinAProperty() {
        ConfigString configString = new ConfigString("@{a.${name}.c}", variables, properties);
        TestExpandableString.assertTrue((String)"sub failed in expand", (boolean)configString.expand("b", properties));
        TestExpandableString.assertEquals((String)"A.B.C", (String)configString.toString());
        configString.reset();
    }

    public void testSUFFIXVariableWithinAProperty() {
        ConfigString configString = new ConfigString("@{a.${name}${suffix}}", variables, properties);
        TestExpandableString.assertTrue((String)"sub failed in expand", (boolean)configString.expand("b", variables, properties));
        TestExpandableString.assertEquals((String)"A.B.gotcha", (String)configString.toString());
        configString.reset();
    }

    public void testRecursiveProperties() {
        ConfigString configString = new ConfigString("@{a.a}", variables, properties);
        TestExpandableString.assertTrue((String)"sub failed in expand", (boolean)configString.expand("", variables, properties));
        TestExpandableString.assertEquals((String)"c.c", (String)configString.toString());
        configString.reset();
    }

    public void testRecursiveVariables() {
        ConfigString configString = new ConfigString("${A.A}", variables, properties);
        TestExpandableString.assertTrue((String)"sub failed in expand", (boolean)configString.expand("", variables, properties));
        TestExpandableString.assertEquals((String)"C.C", (String)configString.toString());
        configString.reset();
    }

    public void testQuotes() {
        ConfigString configString = new ConfigString("'${A.A}'", variables, properties);
        TestExpandableString.assertTrue((String)"sub failed in expand", (boolean)configString.expand("", variables, properties));
        TestExpandableString.assertEquals((String)"'${A.A}'", (String)configString.toString());
        configString.reset();
    }

    public void testQuotesTwice() {
        ConfigString configString = new ConfigString("'${A.A}' and '@{a.${b}}'", variables, properties);
        TestExpandableString.assertTrue((String)"sub failed in expand", (boolean)configString.expand("", variables, properties));
        TestExpandableString.assertEquals((String)"'${A.A}' and '@{a.${b}}'", (String)configString.toString());
        configString.reset();
    }

    public void testQuotesWithEscapedSubQuote() {
        ConfigString configString = new ConfigString("'${A.\\'A}' and '@{a.${b}}'", variables, properties);
        TestExpandableString.assertTrue((String)"sub failed in expand", (boolean)configString.expand("", variables, properties));
        TestExpandableString.assertEquals((String)"'${A.\\'A}' and '@{a.${b}}'", (String)configString.toString());
        configString.reset();
    }

    public void testComplexString() {
        String string = "'File(@{$resolver}.${name}})' \\\r\n'File(@{$resolver}.dir}/${name}@{${resolver}.suffix})' \\\r\n'File(@{user.dir}/${name}@{${resolver}.suffix})' \\\r\n'File(@{user.home}/@{${resolver}.subdir}/${name}@{${resolver}.suffix})' \\\r\n'File(@{java.io.tmpdir}/${name}@{${resolver}.suffix})' \\\r\n'Classpath(${name}@{${resolver}.suffix})'\r\n";
        ConfigString configString = new ConfigString(string, variables, properties);
        configString.expand("mark", variables, properties);
        configString.remove("\r\n");
        configString.remove("\\\r\n");
    }

    static {
        logger = JLogger.getLogger(JConfig.class);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("jnp", JNP);
        hashMap.put("company", COMPANY);
        hashMap.put("suffix", SUFFIX);
        hashMap.put("A.A", "${B.B}");
        hashMap.put("B.B", "C.C");
        variables = Collections.unmodifiableMap(hashMap);
        properties = new Properties();
        properties.setProperty("a.b", "A.B");
        properties.setProperty("a.b.c", "A.B.C");
        properties.setProperty("a.b.c.d", "A.B.C.D");
        properties.setProperty("a.b.ext", "A.B.gotcha");
        properties.setProperty("a.a", "@{b.b}");
        properties.setProperty("b.b", "c.c");
    }
}

