/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet.structure;

import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.format.JFormatter;
import org.jnetpcap.packet.structure.AnnotatedField;
import org.jnetpcap.packet.structure.AnnotatedFieldMethod;
import org.jnetpcap.packet.structure.JField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedJField
extends JField {
    protected JField[] subFields;
    private final String name;
    private final String nicname;
    private final JFormatter.Priority priority;
    protected JFormatter.Style style;
    private final AnnotatedFieldMethod value;
    private final AnnotatedFieldMethod offset;
    private final AnnotatedFieldMethod length;
    private final AnnotatedFieldMethod display;
    private final AnnotatedFieldMethod description;
    private final AnnotatedFieldMethod mask;
    private final AnnotatedFieldMethod check;
    private final AnnotatedFieldMethod units;

    public static AnnotatedJField fromAnnotatedField(AnnotatedField annotatedField) {
        JField[] jFieldArray = new AnnotatedJField[annotatedField.getSubFields().size()];
        int n = 0;
        for (AnnotatedField annotatedField2 : annotatedField.getSubFields()) {
            jFieldArray[n++] = AnnotatedJField.fromAnnotatedField(annotatedField2);
        }
        AnnotatedJField.sortFieldByOffset(jFieldArray, null, false);
        return new AnnotatedJField(annotatedField, jFieldArray);
    }

    public static JField[] fromAnnotatedFields(AnnotatedField[] annotatedFieldArray) {
        JField[] jFieldArray = new JField[annotatedFieldArray.length];
        for (int i = 0; i < annotatedFieldArray.length; ++i) {
            jFieldArray[i] = AnnotatedJField.fromAnnotatedField(annotatedFieldArray[i]);
        }
        return jFieldArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("name=").append(this.name);
        stringBuilder.append(", nicname=").append(this.nicname);
        stringBuilder.append(", parent=").append(this.getParent());
        stringBuilder.append(", priority=").append((Object)this.priority);
        stringBuilder.append(", style=").append((Object)this.style);
        return stringBuilder.toString();
    }

    public AnnotatedJField(AnnotatedField annotatedField, JField[] jFieldArray) {
        this.subFields = jFieldArray;
        this.priority = annotatedField.getPriority();
        this.name = annotatedField.getName();
        this.nicname = annotatedField.getNicname();
        annotatedField.getDisplay();
        annotatedField.getUnits();
        this.style = annotatedField.getStyle();
        this.value = annotatedField.getRuntime().getFunctionMap().get((Object)Field.Property.VALUE);
        this.offset = annotatedField.getRuntime().getFunctionMap().get((Object)Field.Property.OFFSET);
        this.length = annotatedField.getRuntime().getFunctionMap().get((Object)Field.Property.LENGTH);
        this.display = annotatedField.getRuntime().getFunctionMap().get((Object)Field.Property.DISPLAY);
        this.description = annotatedField.getRuntime().getFunctionMap().get((Object)Field.Property.DESCRIPTION);
        this.mask = annotatedField.getRuntime().getFunctionMap().get((Object)Field.Property.MASK);
        this.check = annotatedField.getRuntime().getFunctionMap().get((Object)Field.Property.CHECK);
        this.units = annotatedField.getRuntime().getFunctionMap().get((Object)Field.Property.UNITS);
        for (JField jField : this.subFields) {
            jField.setParent(this);
        }
    }

    @Override
    public JField[] getSubFields() {
        return this.subFields;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNicname() {
        return this.nicname;
    }

    @Override
    public JFormatter.Priority getPriority() {
        return this.priority;
    }

    @Override
    public JFormatter.Style getStyle() {
        return this.style;
    }

    @Override
    public boolean hasSubFields() {
        return this.subFields.length != 0;
    }

    @Override
    public void setStyle(JFormatter.Style style) {
        this.style = style;
    }

    @Override
    public String getUnits(JHeader jHeader) {
        return this.units.stringMethod(jHeader, this.name);
    }

    @Override
    public boolean hasField(JHeader jHeader) {
        return this.check.booleanMethod(jHeader, this.name);
    }

    @Override
    public String getDisplay(JHeader jHeader) {
        return this.display.stringMethod(jHeader, this.name);
    }

    @Override
    public int getLength(JHeader jHeader) {
        return this.length.intMethod(jHeader, this.name);
    }

    @Override
    public long getMask(JHeader jHeader) {
        return this.mask.longMethod(jHeader, this.name);
    }

    @Override
    public int getOffset(JHeader jHeader) {
        return this.offset.intMethod(jHeader, this.name);
    }

    @Override
    public String getValueDescription(JHeader jHeader) {
        return this.description.stringMethod(jHeader, this.name);
    }

    @Override
    public <T> T getValue(Class<T> clazz, JHeader jHeader) {
        return (T)this.value.objectMethod(jHeader, this.name);
    }

    @Override
    public Object getValue(JHeader jHeader) {
        return this.value.objectMethod(jHeader, this.name);
    }

    @Override
    public long longValue(JHeader jHeader) {
        Object object = this.getValue(jHeader);
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        if (object instanceof String) {
            return Long.parseLong(object.toString());
        }
        throw new IllegalStateException("unknown format encountered");
    }
}

