/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.jnetpcap.header.BindNetworkFamily;
import org.jnetpcap.header.MyHeader;
import org.jnetpcap.packet.AbstractBinding;
import org.jnetpcap.packet.JBinding;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.JRegistry;
import org.jnetpcap.packet.JScan;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.RegistryHeaderErrors;
import org.jnetpcap.packet.TestUtils;
import org.jnetpcap.packet.UnregisteredHeaderException;
import org.jnetpcap.packet.annotate.Bind;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.Scanner;
import org.jnetpcap.packet.structure.AnnotatedBindMethod;
import org.jnetpcap.packet.structure.AnnotatedBinding;
import org.jnetpcap.packet.structure.AnnotatedHeaderLengthMethod;
import org.jnetpcap.packet.structure.HeaderDefinitionError;
import org.jnetpcap.protocol.JProtocol;
import org.jnetpcap.protocol.lan.Ethernet;
import org.jnetpcap.protocol.network.Ip4;
import org.jnetpcap.protocol.network.Ip6;

public class TestJRegistry
extends TestCase {
    private List<HeaderDefinitionError> errors = new ArrayList<HeaderDefinitionError>();

    protected void setUp() throws Exception {
        this.errors.clear();
        AnnotatedBinding.clearCache();
        AnnotatedBindMethod.clearCache();
        AnnotatedHeaderLengthMethod.clearCache();
    }

    protected void tearDown() throws Exception {
        if (!this.errors.isEmpty()) {
            System.out.println("Found errors:");
            for (HeaderDefinitionError headerDefinitionError : this.errors) {
                System.out.println(headerDefinitionError.getMessage());
            }
            TestJRegistry.fail((String)("Found " + this.errors.size() + " header definition errors"));
        }
    }

    public void testCoreProtocolRegistrationByJProtocol() throws UnregisteredHeaderException {
        for (JProtocol jProtocol : JProtocol.values()) {
            TestJRegistry.assertEquals((String)jProtocol.toString(), (int)jProtocol.getId(), (int)JRegistry.lookupId(jProtocol));
        }
    }

    public void testCoreProtocolRegistrationByClass() throws UnregisteredHeaderException {
        System.out.println(JRegistry.toDebugString());
        for (JProtocol jProtocol : JProtocol.values()) {
            TestJRegistry.assertEquals((String)jProtocol.toString(), (int)jProtocol.getId(), (int)JRegistry.lookupId(jProtocol.getHeaderClass()));
        }
    }

    public void testCoreProtocolRegistrationByName() throws UnregisteredHeaderException {
        TestJRegistry.assertEquals((String)JProtocol.ETHERNET.toString(), (int)1, (int)JRegistry.lookupId(Ethernet.class));
        TestJRegistry.assertEquals((String)JProtocol.IP4.toString(), (int)2, (int)JRegistry.lookupId(Ip4.class));
        TestJRegistry.assertEquals((String)JProtocol.IP6.toString(), (int)3, (int)JRegistry.lookupId(Ip6.class));
    }

    public void testExtractBindingFromJHeader() {
        AnnotatedBinding.inspectJHeaderClass(MyHeader.class, this.errors);
    }

    public void testJHeaderAnnotatedBindingWithPacket() {
        JBinding[] jBindingArray = AnnotatedBinding.inspectJHeaderClass(MyHeader.class, this.errors);
        JBinding jBinding = jBindingArray[0];
        System.out.println(jBinding.toString());
        PcapPacket pcapPacket = TestUtils.getPcapPacket("tests/test-afs.pcap", 0);
        TestJRegistry.assertTrue((String)"ethernet binding", (boolean)jBinding.isBound(pcapPacket, 0));
    }

    public void testAllClassAnnotatedBindingWithPacket() {
        JBinding[] jBindingArray = AnnotatedBinding.inspectClass(BindNetworkFamily.class, this.errors);
        TestJRegistry.assertTrue((String)"no bindings found", (jBindingArray.length > 0 ? 1 : 0) != 0);
        JBinding jBinding = jBindingArray[0];
        PcapPacket pcapPacket = TestUtils.getPcapPacket("tests/test-afs.pcap", 0);
        System.out.println(jBinding.toString());
        TestJRegistry.assertTrue((String)jBinding.toString(), (boolean)jBinding.isBound(pcapPacket, 0));
    }

    public void testAnnonymousBinding() {
        new AbstractBinding<Ethernet>(Ip4.class, Ethernet.class){

            @Override
            public boolean isBound(JPacket jPacket, Ethernet ethernet) {
                return ethernet.type() == 2048;
            }
        };
        Object object = new Object(){

            @Bind(from=Ip4.class, to=Ethernet.class)
            public boolean bindIp4ToEthernet(JPacket jPacket, Ethernet ethernet) {
                return ethernet.type() == 2048;
            }
        };
        AnnotatedBinding.inspectObject(object, this.errors);
    }

    public void testRegistryDump() throws RegistryHeaderErrors {
        JRegistry.register(MyHeader.class);
        JRegistry.lookupId(MyHeader.class);
        Object object = new Object(){

            @Bind(from=Ip4.class, to=MyHeader.class)
            public boolean bindIp4ToMyHeader(JPacket jPacket, MyHeader myHeader) {
                return myHeader.type() == 2048;
            }

            @Scanner(value=Ip4.class)
            public void scanIp4(JScan jScan) {
            }
        };
        JRegistry.addBindings(object);
        JRegistry.setScanners(object);
        System.out.println(JRegistry.toDebugString());
        JRegistry.clearScanners(object);
        System.out.println(JRegistry.toDebugString());
    }

    private static class TestHeader
    extends JHeader {
        private TestHeader() {
        }

        @Field(offset=0, length=8)
        public int field1() {
            return super.getUByte(0);
        }

        @Field(offset=8)
        public int field2() {
            return super.getUByte(0);
        }

        @Dynamic(value=Field.Property.LENGTH)
        public int field2Length() {
            return this.field1() * 8;
        }
    }

    private static class TestBindings {
        private TestBindings() {
        }

        @Bind(from=Ip4.class, to=Ethernet.class)
        public static boolean bindIp4ToEthernet(JPacket jPacket, Ethernet ethernet) {
            return ethernet.type() == 2048;
        }
    }

    public static class TestBinding
    extends JBinding.DefaultJBinding {
        public TestBinding(int n, int n2, int ... nArray) {
            super(n, n2, nArray);
        }

        public int scanForNextHeader(JPacket jPacket, int n) {
            throw new UnsupportedOperationException("Not implemented yet");
        }

        @Override
        public int getSourceId() {
            throw new UnsupportedOperationException("Not implemented yet");
        }

        @Override
        public boolean isBound(JPacket jPacket, int n) {
            throw new UnsupportedOperationException("Not implemented yet");
        }
    }
}

