/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import de.gematik.rbellogger.converter.RbelJexlExecutor;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.exceptions.RbelPathException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class RbelPathExecutor {
    private final RbelElement rbelElement;
    private final String rbelPath;

    private static boolean tryToParseInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static List<RbelElement> findAllChildsRecursive(RbelElement element) {
        List<? extends RbelElement> childNodes = element.getChildNodes();
        ArrayList<RbelElement> result = new ArrayList<RbelElement>(childNodes);
        childNodes.stream().map(RbelPathExecutor::findAllChildsRecursive).filter(Objects::nonNull).flatMap(Collection::stream).forEach(result::add);
        return result;
    }

    public List<RbelElement> execute() {
        if (!this.rbelPath.startsWith("$")) {
            throw new RbelPathException("RbelPath expressions always start with $.");
        }
        List<String> keys = List.of(this.rbelPath.substring(2).split("\\.(?![^\\(]*\\))"));
        List<RbelElement> candidates = List.of(this.rbelElement);
        for (String key : keys) {
            candidates = candidates.stream().map(element -> this.resolveRbelPathElement(key, (RbelElement)element)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        }
        return candidates;
    }

    private List<? extends RbelElement> resolveRbelPathElement(String key, RbelElement element) {
        if (key.startsWith("[") && key.endsWith("]")) {
            return this.executeFunctionalExpression(key.substring(1, key.length() - 1).trim(), element);
        }
        if (key.contains("[") && key.endsWith("]")) {
            String[] parts = key.split("\\[");
            String subKey = parts[0];
            List<? extends RbelElement> keySelectionResult = this.executeNonFunctionalExpression(subKey, element);
            int selectionIndex = Integer.parseInt(parts[1].substring(0, parts[1].length() - 1));
            if (keySelectionResult.size() <= selectionIndex) {
                return Collections.emptyList();
            }
            return List.of(keySelectionResult.get(selectionIndex));
        }
        return this.executeNonFunctionalExpression(key, element);
    }

    private List<? extends RbelElement> executeNonFunctionalExpression(String key, RbelElement element) {
        if (key.isEmpty()) {
            return RbelPathExecutor.findAllChildsRecursive(element);
        }
        if (key.equals("*")) {
            return element.getChildNodes();
        }
        return element.getAll(key);
    }

    private List<? extends RbelElement> executeFunctionalExpression(String functionExpression, RbelElement element) {
        if (functionExpression.startsWith("'") && functionExpression.endsWith("'")) {
            return element.getAll(functionExpression.substring(1, functionExpression.length() - 1));
        }
        if (functionExpression.equals("*")) {
            return element.getChildNodes();
        }
        if (functionExpression.startsWith("?")) {
            if (functionExpression.startsWith("?(") && functionExpression.endsWith(")")) {
                return this.findChildNodesByJexlExpression(element, functionExpression.substring(2, functionExpression.length() - 1));
            }
            throw new RbelPathException("Invalid JEXL-Expression encountered (Does not start with '?(' and end with ')'): " + functionExpression);
        }
        throw new RbelPathException("Unknown function expression encountered: " + functionExpression);
    }

    private List<RbelElement> findChildNodesByJexlExpression(RbelElement element, String jexl) {
        RbelJexlExecutor executor = new RbelJexlExecutor();
        return element.getChildElements().stream().filter(candidate -> executor.matchesAsJexlExpression(candidate.getValue(), jexl, Optional.of((String)candidate.getKey()))).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public RbelPathExecutor(RbelElement rbelElement, String rbelPath) {
        this.rbelElement = rbelElement;
        this.rbelPath = rbelPath;
    }
}

