/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHttpMessage;
import de.gematik.rbellogger.data.RbelHttpRequest;
import de.gematik.rbellogger.data.RbelMultiValuedMapElement;

public class RbelHttpResponse
extends RbelHttpMessage {
    private final int responseCode;
    private RbelHttpRequest request;

    public RbelHttpResponse(RbelMultiValuedMapElement header, RbelElement body, int responseCode) {
        super(header, body);
        this.responseCode = responseCode;
    }

    @Override
    public String getContent() {
        return ELEMENT_SEPARATOR + "HTTP RESPONSE " + this.responseCode + " + \n Headers:\n" + this.getHeader().getContent() + HEADER_SEPARATOR + this.getBody().getContent();
    }

    public static RbelHttpResponseBuilder builder() {
        return new RbelHttpResponseBuilder();
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public RbelHttpRequest getRequest() {
        return this.request;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelHttpResponse)) {
            return false;
        }
        RbelHttpResponse other = (RbelHttpResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getResponseCode() != other.getResponseCode()) {
            return false;
        }
        RbelHttpRequest this$request = this.getRequest();
        RbelHttpRequest other$request = other.getRequest();
        return !(this$request == null ? other$request != null : !((Object)this$request).equals(other$request));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RbelHttpResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getResponseCode();
        RbelHttpRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RbelHttpResponse(responseCode=" + this.getResponseCode() + ", request=" + this.getRequest() + ")";
    }

    public void setRequest(RbelHttpRequest request) {
        this.request = request;
    }

    public static class RbelHttpResponseBuilder {
        private RbelMultiValuedMapElement header;
        private RbelElement body;
        private int responseCode;

        RbelHttpResponseBuilder() {
        }

        public RbelHttpResponseBuilder header(RbelMultiValuedMapElement header) {
            this.header = header;
            return this;
        }

        public RbelHttpResponseBuilder body(RbelElement body) {
            this.body = body;
            return this;
        }

        public RbelHttpResponseBuilder responseCode(int responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public RbelHttpResponse build() {
            return new RbelHttpResponse(this.header, this.body, this.responseCode);
        }

        public String toString() {
            return "RbelHttpResponse.RbelHttpResponseBuilder(header=" + this.header + ", body=" + this.body + ", responseCode=" + this.responseCode + ")";
        }
    }
}

