/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHttpMessage;
import de.gematik.rbellogger.data.RbelMultiValuedMapElement;
import de.gematik.rbellogger.data.RbelUriElement;
import java.util.ArrayList;
import java.util.List;

public class RbelHttpRequest
extends RbelHttpMessage {
    private final String method;
    private final RbelUriElement path;

    @Override
    public List<RbelElement> getChildNodes() {
        ArrayList<RbelElement> childNodes = new ArrayList<RbelElement>();
        childNodes.add(this.path);
        childNodes.addAll(super.getChildNodes());
        return childNodes;
    }

    public RbelHttpRequest(RbelMultiValuedMapElement header, RbelElement body, String method, RbelUriElement path) {
        super(header, body);
        this.method = method;
        this.path = path;
    }

    @Override
    public String getContent() {
        return ELEMENT_SEPARATOR + "HTTP REQUEST: " + this.method + " - " + this.path + "\nHeaders:\n" + this.getHeader().getContent() + HEADER_SEPARATOR + this.getBody().getContent();
    }

    public static RbelHttpRequestBuilder builder() {
        return new RbelHttpRequestBuilder();
    }

    public String getMethod() {
        return this.method;
    }

    public RbelUriElement getPath() {
        return this.path;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelHttpRequest)) {
            return false;
        }
        RbelHttpRequest other = (RbelHttpRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        RbelUriElement this$path = this.getPath();
        RbelUriElement other$path = other.getPath();
        return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RbelHttpRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        RbelUriElement $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RbelHttpRequest(method=" + this.getMethod() + ", path=" + this.getPath() + ")";
    }

    public static class RbelHttpRequestBuilder {
        private RbelMultiValuedMapElement header;
        private RbelElement body;
        private String method;
        private RbelUriElement path;

        RbelHttpRequestBuilder() {
        }

        public RbelHttpRequestBuilder header(RbelMultiValuedMapElement header) {
            this.header = header;
            return this;
        }

        public RbelHttpRequestBuilder body(RbelElement body) {
            this.body = body;
            return this;
        }

        public RbelHttpRequestBuilder method(String method) {
            this.method = method;
            return this;
        }

        public RbelHttpRequestBuilder path(RbelUriElement path) {
            this.path = path;
            return this;
        }

        public RbelHttpRequest build() {
            return new RbelHttpRequest(this.header, this.body, this.method, this.path);
        }

        public String toString() {
            return "RbelHttpRequest.RbelHttpRequestBuilder(header=" + this.header + ", body=" + this.body + ", method=" + this.method + ", path=" + this.path + ")";
        }
    }
}

