/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelCurlHttpMessageConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHttpRequest;
import de.gematik.rbellogger.data.RbelMapElement;
import de.gematik.rbellogger.data.RbelMultiValuedMapElement;
import de.gematik.rbellogger.data.RbelStringElement;
import de.gematik.rbellogger.data.RbelUriElement;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RbelHttpRequestConverter
extends RbelCurlHttpMessageConverter {
    @Override
    public boolean canConvertElement(RbelElement rbel, RbelConverter context) {
        if (StringUtils.isEmpty(rbel.getContent())) {
            return false;
        }
        String firstLine = rbel.getContent().split("\n")[0].trim();
        return !(!(rbel instanceof RbelStringElement) || !firstLine.startsWith("GET ") && !firstLine.startsWith("POST ") && !firstLine.startsWith("PUT ") && !firstLine.startsWith("DELETE ") || !firstLine.endsWith("HTTP/1.0") && !firstLine.endsWith("HTTP/1.1") && !firstLine.endsWith("HTTP/2.0"));
    }

    @Override
    public RbelElement convertElement(RbelElement rbel, RbelConverter context) {
        int space = rbel.getContent().indexOf(" ");
        int space2 = rbel.getContent().indexOf(" ", space + 1);
        String method = rbel.getContent().substring(0, space);
        String path = rbel.getContent().substring(space + 1, space2);
        String[] lines = rbel.getContent().split(RbelHttpRequestConverter.findLineSeparator(rbel.getContent()));
        int bodySeparator = Arrays.asList(lines).indexOf("");
        Map<String, List<RbelElement>> headerMap = Arrays.stream(lines).limit(bodySeparator == -1 ? (long)lines.length : (long)bodySeparator).filter(line -> !line.isEmpty() && !line.startsWith(method)).map(line -> this.parseStringToKeyValuePair((String)line, context)).collect(Collectors.groupingBy(e -> (String)e.getKey(), Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        RbelMultiValuedMapElement headers = new RbelMultiValuedMapElement(headerMap);
        String bodyStr = bodySeparator == -1 ? "" : lines[lines.length - 1];
        RbelElement pathElement = context.convertMessage(path);
        if (!(pathElement instanceof RbelUriElement)) {
            throw new RuntimeException("Encountered ill-formatted path: " + path);
        }
        RbelHttpRequest rbelHttpRequest = new RbelHttpRequest(headers, context.convertMessage(this.convertBodyToRbelElement(bodyStr, headers, context)), method, (RbelUriElement)pathElement);
        return rbelHttpRequest;
    }

    private RbelElement convertBodyToRbelElement(String bodyStr, RbelMultiValuedMapElement headerMap, RbelConverter context) {
        if (headerMap.containsKey("Content-Type") && this.hasContentTypeFormUrlEncoded(headerMap)) {
            return new RbelMapElement(Stream.of(bodyStr.split("&")).map(param -> param.split("=")).filter(params -> ((String[])params).length == 2).map(paramList -> Pair.of(paramList[0], context.convertMessage(paramList[1]))).collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
        }
        return new RbelStringElement(bodyStr);
    }

    private boolean hasContentTypeFormUrlEncoded(RbelMultiValuedMapElement headerMap) {
        return headerMap.getAll("Content-Type").stream().map(RbelElement::getContent).anyMatch(str -> str.startsWith("application/x-www-form-urlencoded"));
    }
}

