/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelBase64JsonConverter;
import de.gematik.rbellogger.converter.RbelBearerTokenConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.converter.RbelCurlHttpMessageConverter;
import de.gematik.rbellogger.converter.RbelHttpRequestConverter;
import de.gematik.rbellogger.converter.RbelJsonConverter;
import de.gematik.rbellogger.converter.RbelJweConverter;
import de.gematik.rbellogger.converter.RbelJwtConverter;
import de.gematik.rbellogger.converter.RbelUriConverter;
import de.gematik.rbellogger.converter.RbelValueShader;
import de.gematik.rbellogger.converter.RbelXmlConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHttpMessage;
import de.gematik.rbellogger.data.RbelHttpRequest;
import de.gematik.rbellogger.data.RbelHttpResponse;
import de.gematik.rbellogger.data.RbelStringElement;
import de.gematik.rbellogger.key.RbelKeyManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelConverter {
    private static final Logger log = LoggerFactory.getLogger(RbelConverter.class);
    private final List<RbelElement> messageHistory = new ArrayList<RbelElement>();
    private final RbelKeyManager rbelKeyManager;
    private final RbelValueShader rbelValueShader;
    private final Map<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>> postConversionListener = new HashMap<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>>();
    private final Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> preConversionMappers = new HashMap<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>>();
    private final List<RbelConverterPlugin> converterPlugins = new ArrayList<RbelBase64JsonConverter>(List.of(new RbelCurlHttpMessageConverter(), new RbelHttpRequestConverter(), new RbelJwtConverter(), new RbelJsonConverter(), new RbelXmlConverter(), new RbelJweConverter(), new RbelUriConverter(), new RbelBearerTokenConverter(), new RbelBase64JsonConverter()));

    public RbelElement convertMessage(String input) {
        return this.convertMessage(new RbelStringElement(input));
    }

    public RbelElement convertMessage(RbelElement rawInput) {
        log.trace("Converting {}...", (Object)rawInput);
        RbelElement convertedInput = this.filterInputThroughPreConversionMappers(rawInput);
        RbelElement result = this.converterPlugins.stream().filter(plugin -> {
            try {
                return plugin.canConvertElement(convertedInput, this);
            }
            catch (Exception e) {
                return false;
            }
        }).map(plugin -> plugin.convertElement(convertedInput, this)).findFirst().orElse(convertedInput);
        if (convertedInput.getRawMessage() == null) {
            result.setRawMessage(convertedInput.getContent());
        } else {
            result.setRawMessage(convertedInput.getRawMessage());
        }
        if (result instanceof RbelHttpMessage) {
            this.messageHistory.add(result);
            if (result instanceof RbelHttpResponse) {
                ((RbelHttpResponse)result).setRequest(this.findLastRequest());
            }
            result.triggerPostConversionListener(this);
        }
        return result;
    }

    private RbelHttpRequest findLastRequest() {
        for (int i = this.messageHistory.size() - 1; i >= 0; --i) {
            if (!(this.messageHistory.get(i) instanceof RbelHttpRequest)) continue;
            return (RbelHttpRequest)this.messageHistory.get(i);
        }
        return null;
    }

    private RbelElement filterInputThroughPreConversionMappers(RbelElement input) {
        RbelElement value = input;
        for (BiFunction mapper : this.preConversionMappers.entrySet().stream().filter(entry -> input.getClass().isAssignableFrom((Class)entry.getKey())).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList())) {
            RbelElement newValue = (RbelElement)mapper.apply(value, this);
            if (newValue != value) {
                value = this.filterInputThroughPreConversionMappers(newValue);
                continue;
            }
            value = newValue;
        }
        return value;
    }

    public void registerListener(Class<? extends RbelElement> clazz, BiConsumer<RbelElement, RbelConverter> listener) {
        this.postConversionListener.computeIfAbsent(clazz, key -> new ArrayList()).add(listener);
    }

    public void triggerPostConversionListenerFor(RbelElement element) {
        ArrayList superclasses = new ArrayList(ClassUtils.getAllSuperclasses(element.getClass()));
        superclasses.add(element.getClass());
        superclasses.stream().filter(this.postConversionListener::containsKey).map(this.postConversionListener::get).flatMap(Collection::stream).forEach(consumer -> consumer.accept(element, this));
    }

    public void registerMapper(Class<? extends RbelElement> clazz, BiFunction<RbelElement, RbelConverter, RbelElement> mapper) {
        this.preConversionMappers.computeIfAbsent(clazz, key -> new ArrayList()).add(mapper);
    }

    public static RbelConverterBuilder builder() {
        return new RbelConverterBuilder();
    }

    private RbelConverter(RbelKeyManager rbelKeyManager, RbelValueShader rbelValueShader) {
        this.rbelKeyManager = rbelKeyManager;
        this.rbelValueShader = rbelValueShader;
    }

    public List<RbelElement> getMessageHistory() {
        return this.messageHistory;
    }

    public RbelKeyManager getRbelKeyManager() {
        return this.rbelKeyManager;
    }

    public RbelValueShader getRbelValueShader() {
        return this.rbelValueShader;
    }

    public Map<Class<? extends RbelElement>, List<BiConsumer<RbelElement, RbelConverter>>> getPostConversionListener() {
        return this.postConversionListener;
    }

    public Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> getPreConversionMappers() {
        return this.preConversionMappers;
    }

    public List<RbelConverterPlugin> getConverterPlugins() {
        return this.converterPlugins;
    }

    public static class RbelConverterBuilder {
        private RbelKeyManager rbelKeyManager;
        private RbelValueShader rbelValueShader;

        RbelConverterBuilder() {
        }

        public RbelConverterBuilder rbelKeyManager(RbelKeyManager rbelKeyManager) {
            this.rbelKeyManager = rbelKeyManager;
            return this;
        }

        public RbelConverterBuilder rbelValueShader(RbelValueShader rbelValueShader) {
            this.rbelValueShader = rbelValueShader;
            return this;
        }

        public RbelConverter build() {
            return new RbelConverter(this.rbelKeyManager, this.rbelValueShader);
        }

        public String toString() {
            return "RbelConverter.RbelConverterBuilder(rbelKeyManager=" + this.rbelKeyManager + ", rbelValueShader=" + this.rbelValueShader + ")";
        }
    }
}

