/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.captures;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.MultiValue;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.Response;
import de.gematik.rbellogger.captures.RbelCapturer;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHttpRequest;
import de.gematik.rbellogger.data.RbelHttpResponse;
import de.gematik.rbellogger.data.RbelMapElement;
import de.gematik.rbellogger.data.RbelMultiValuedMapElement;
import de.gematik.rbellogger.data.RbelUriElement;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wiremock.com.google.common.net.MediaType;

public class WiremockCapture
extends RbelCapturer {
    private static final Logger log = LoggerFactory.getLogger(WiremockCapture.class);
    private final String proxyFor;
    private final ProxySettings proxySettings;
    private final WireMockConfiguration wireMockConfiguration;
    private WireMockServer wireMockServer;
    private boolean isInitialized;

    public WiremockCapture(RbelConverter rbelConverter, String proxyFor, ProxySettings proxySettings, WireMockConfiguration wireMockConfiguration) {
        super(rbelConverter);
        this.proxyFor = proxyFor;
        this.proxySettings = proxySettings;
        this.wireMockConfiguration = wireMockConfiguration;
    }

    @Override
    public WiremockCapture initialize() {
        if (this.isInitialized) {
            return this;
        }
        log.info("Starting Wiremock-Capture. This will boot a proxy-server for the target url '{}'", (Object)this.proxyFor);
        WireMockConfiguration wireMockConfiguration = this.getWireMockConfiguration();
        this.wireMockServer = new WireMockServer(wireMockConfiguration);
        this.wireMockServer.start();
        this.wireMockServer.stubFor(WireMock.any(WireMock.anyUrl()).willReturn(WireMock.aResponse().proxiedFrom(this.proxyFor)));
        this.wireMockServer.addMockServiceRequestListener((request, response) -> {
            this.getRbelConverter().convertMessage(this.requestToRbelMessage(request));
            this.getRbelConverter().convertMessage(this.responseToRbelMessage(response));
        });
        log.info("Started Wiremock-Server at '{}'.", (Object)this.wireMockServer.baseUrl());
        this.isInitialized = true;
        return this;
    }

    private WireMockConfiguration getWireMockConfiguration() {
        if (this.wireMockConfiguration != null) {
            return this.wireMockConfiguration;
        }
        WireMockConfiguration wireMockConfiguration = WireMockConfiguration.options().dynamicPort().trustAllProxyTargets(true).enableBrowserProxying(false);
        if (this.proxySettings != null) {
            wireMockConfiguration.proxyVia(this.proxySettings);
        }
        return wireMockConfiguration;
    }

    private RbelElement requestToRbelMessage(Request request) {
        return RbelHttpRequest.builder().method(request.getMethod().getName()).path(this.getRequestUrl(request)).header(this.mapHeader(request.getHeaders())).body(this.getRbelConverter().convertMessage(this.convertMessageBody(request.getBodyAsString(), request.getHeaders().getContentTypeHeader()))).build().setRawMessage(request.getMethod().toString() + " " + request.getUrl() + " HTTP/1.1\n" + request.getHeaders().all().stream().map(MultiValue::toString).collect(Collectors.joining("\n")) + "\n\n" + request.getBodyAsString());
    }

    private RbelUriElement getRequestUrl(Request request) {
        RbelElement pathElement = this.getRbelConverter().convertMessage((this.proxyFor == null ? "" : this.proxyFor) + request.getUrl());
        if (pathElement instanceof RbelUriElement) {
            return (RbelUriElement)pathElement;
        }
        throw new RuntimeException("Non-matching URL-component: " + pathElement.getContent());
    }

    private RbelElement responseToRbelMessage(Response response) {
        return RbelHttpResponse.builder().responseCode(response.getStatus()).header(this.mapHeader(response.getHeaders())).body(this.getRbelConverter().convertMessage(this.convertMessageBody(response.getBodyAsString(), response.getHeaders().getContentTypeHeader()))).build().setRawMessage("HTTP/1.1 " + response.getStatus() + " " + (response.getStatusMessage() != null ? response.getStatusMessage() : "") + "\n" + response.getHeaders().all().stream().map(MultiValue::toString).collect(Collectors.joining("\n")) + "\n\n" + response.getBodyAsString());
    }

    private RbelElement convertMessageBody(String bodyAsString, ContentTypeHeader contentTypeHeader) {
        if (Optional.ofNullable(contentTypeHeader).map(ContentTypeHeader::mimeTypePart).map(mime -> mime.equals(MediaType.FORM_DATA.toString())).orElse(false).booleanValue()) {
            try {
                return new RbelMapElement(Stream.of(bodyAsString.split("&")).map(str -> str.split("=")).collect(Collectors.toMap(array -> array[0], array -> this.getRbelConverter().convertMessage(array[1]))));
            }
            catch (Exception e) {
                log.warn("Unable to parse form-data '" + bodyAsString + "'. Using fallback");
                return this.getRbelConverter().convertMessage(bodyAsString);
            }
        }
        return this.getRbelConverter().convertMessage(bodyAsString);
    }

    private RbelMultiValuedMapElement mapHeader(HttpHeaders headers) {
        Map<String, List<RbelElement>> headersMap = headers.all().stream().collect(Collectors.toMap(e -> e.key(), e -> e.values().stream().map(v -> this.getRbelConverter().convertMessage((String)v)).collect(Collectors.toList())));
        return new RbelMultiValuedMapElement(headersMap);
    }

    public String getProxyAdress() {
        return "http://localhost:" + this.wireMockServer.port();
    }

    @Override
    public void close() {
        if (this.wireMockServer.isRunning()) {
            this.wireMockServer.stop();
        }
    }

    public static WiremockCaptureBuilder builder() {
        return new WiremockCaptureBuilder();
    }

    public String getProxyFor() {
        return this.proxyFor;
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public WireMockServer getWireMockServer() {
        return this.wireMockServer;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WiremockCapture)) {
            return false;
        }
        WiremockCapture other = (WiremockCapture)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$proxyFor = this.getProxyFor();
        String other$proxyFor = other.getProxyFor();
        if (this$proxyFor == null ? other$proxyFor != null : !this$proxyFor.equals(other$proxyFor)) {
            return false;
        }
        ProxySettings this$proxySettings = this.getProxySettings();
        ProxySettings other$proxySettings = other.getProxySettings();
        if (this$proxySettings == null ? other$proxySettings != null : !this$proxySettings.equals(other$proxySettings)) {
            return false;
        }
        WireMockConfiguration this$wireMockConfiguration = this.getWireMockConfiguration();
        WireMockConfiguration other$wireMockConfiguration = other.getWireMockConfiguration();
        if (this$wireMockConfiguration == null ? other$wireMockConfiguration != null : !this$wireMockConfiguration.equals(other$wireMockConfiguration)) {
            return false;
        }
        WireMockServer this$wireMockServer = this.getWireMockServer();
        WireMockServer other$wireMockServer = other.getWireMockServer();
        if (this$wireMockServer == null ? other$wireMockServer != null : !this$wireMockServer.equals(other$wireMockServer)) {
            return false;
        }
        return this.isInitialized() == other.isInitialized();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WiremockCapture;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $proxyFor = this.getProxyFor();
        result = result * 59 + ($proxyFor == null ? 43 : $proxyFor.hashCode());
        ProxySettings $proxySettings = this.getProxySettings();
        result = result * 59 + ($proxySettings == null ? 43 : $proxySettings.hashCode());
        WireMockConfiguration $wireMockConfiguration = this.getWireMockConfiguration();
        result = result * 59 + ($wireMockConfiguration == null ? 43 : $wireMockConfiguration.hashCode());
        WireMockServer $wireMockServer = this.getWireMockServer();
        result = result * 59 + ($wireMockServer == null ? 43 : $wireMockServer.hashCode());
        result = result * 59 + (this.isInitialized() ? 79 : 97);
        return result;
    }

    public static class WiremockCaptureBuilder {
        private RbelConverter rbelConverter;
        private String proxyFor;
        private ProxySettings proxySettings;
        private WireMockConfiguration wireMockConfiguration;

        WiremockCaptureBuilder() {
        }

        public WiremockCaptureBuilder rbelConverter(RbelConverter rbelConverter) {
            this.rbelConverter = rbelConverter;
            return this;
        }

        public WiremockCaptureBuilder proxyFor(String proxyFor) {
            this.proxyFor = proxyFor;
            return this;
        }

        public WiremockCaptureBuilder proxySettings(ProxySettings proxySettings) {
            this.proxySettings = proxySettings;
            return this;
        }

        public WiremockCaptureBuilder wireMockConfiguration(WireMockConfiguration wireMockConfiguration) {
            this.wireMockConfiguration = wireMockConfiguration;
            return this;
        }

        public WiremockCapture build() {
            return new WiremockCapture(this.rbelConverter, this.proxyFor, this.proxySettings, this.wireMockConfiguration);
        }

        public String toString() {
            return "WiremockCapture.WiremockCaptureBuilder(rbelConverter=" + this.rbelConverter + ", proxyFor=" + this.proxyFor + ", proxySettings=" + this.proxySettings + ", wireMockConfiguration=" + this.wireMockConfiguration + ")";
        }
    }
}

