/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.network;

import java.util.EnumSet;
import java.util.Set;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JHeaderChecksum;
import org.jnetpcap.packet.JHeaderMap;
import org.jnetpcap.packet.JHeaderType;
import org.jnetpcap.packet.JSubHeader;
import org.jnetpcap.packet.annotate.BindingVariable;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.FieldSetter;
import org.jnetpcap.packet.annotate.FlowKey;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.annotate.HeaderLength;
import org.jnetpcap.packet.annotate.Protocol;
import org.jnetpcap.packet.annotate.ProtocolSuite;
import org.jnetpcap.util.checksum.Checksum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Protocol(suite=Protocol.Suite.NETWORK)
@Header(name="Ip4", nicname="Ip", osi=Header.Layer.NETWORK, suite=ProtocolSuite.NETWORK, spec={"RFC792"}, description="ip version 4")
public class Ip4
extends JHeaderMap<Ip4>
implements JHeaderChecksum {
    public static final int DIFF_CODEPOINT = 252;
    public static final int DIFF_ECE = 1;
    public static final int DIFF_ECT = 2;
    public static final int FLAG_DONT_FRAGMENT = 2;
    public static final int FLAG_MORE_FRAGMENTS = 1;
    public static final int FLAG_RESERVED = 4;
    public static final int ID = 2;
    private int hashcode;

    @HeaderLength
    public static int getHeaderLength(JBuffer jBuffer, int n) {
        return (jBuffer.getUByte(n) & 0xF) * 4;
    }

    @Override
    public int calculateChecksum() {
        return Checksum.inChecksumShouldBe(this.checksum(), Checksum.inChecksum(this, 0, this.size()));
    }

    @Override
    @Field(offset=80, length=16, format="%x")
    public int checksum() {
        return this.getUShort(10);
    }

    @Override
    @FieldSetter
    public boolean checksum(int n) {
        this.setUShort(10, n);
        return true;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String checksumDescription() {
        int n = this.calculateChecksum();
        if (this.checksum() == n) {
            return "correct";
        }
        return "incorrect: 0x" + Integer.toHexString(n).toUpperCase();
    }

    @BindingVariable(value=BindingVariable.MatchType.FUNCTION)
    public boolean checkType(int n) {
        return this.type() == n && this.offset() == 0;
    }

    public void clearFlags(int n) {
        int n2 = this.getUByte(6);
        this.setUByte(6, n2 &= ~(n << 5));
    }

    @Override
    protected void decodeHeader() {
        this.optionsBitmap = 0L;
        this.hashcode = this.id() << 16 ^ this.sourceToInt() ^ this.destinationToInt() ^ this.type();
        int n = this.hlen() * 4;
        block4: for (int i = 20; i < n; ++i) {
            int n2 = this.getUByte(i) & 0x1F;
            this.optionsOffsets[n2] = i;
            this.optionsBitmap |= (long)(1 << n2);
            IpOption.OptionCode optionCode = IpOption.OptionCode.valueOf(n2);
            if (optionCode == null) break;
            switch (optionCode) {
                case NO_OP: {
                    this.optionsLength[n2] = 1;
                    continue block4;
                }
                case END_OF_OPTION_LIST: {
                    this.optionsLength[n2] = n - i;
                    i = n;
                    continue block4;
                }
                default: {
                    int n3 = this.getUByte(i + 1);
                    i += n3;
                    this.optionsLength[n2] = n3;
                }
            }
        }
    }

    @Field(offset=128, length=32, format="#ip4#")
    @FlowKey(index=0)
    public byte[] destination() {
        return this.getByteArray(16, 4);
    }

    @FieldSetter
    public void destination(byte[] byArray) {
        this.setByteArray(16, byArray);
    }

    public byte[] destinationToByteArray(byte[] byArray) {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("address must be 4 byte long");
        }
        return this.getByteArray(16, byArray);
    }

    public int destinationToInt() {
        return this.getInt(16);
    }

    @Field(offset=48, length=3, format="%x")
    public int flags() {
        return this.getUByte(6) >> 5;
    }

    @FieldSetter
    public void flags(int n) {
        int n2 = this.getUByte(6) & 0x1F;
        this.setUByte(6, n2 |= n << 5);
    }

    @Field(parent="flags", offset=1, length=1, display="DF: do not fragment")
    public int flags_DF() {
        return (this.flags() & 2) >> 1;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String flags_DFDescription() {
        return this.flags_DF() > 0 ? "set" : "not set";
    }

    @Field(parent="flags", offset=0, length=1, display="MF: more fragments", nicname="M")
    public int flags_MF() {
        return this.flags() & 1;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String flags_MFDescription() {
        return this.flags_MF() > 0 ? "set" : "not set";
    }

    @Field(parent="flags", offset=2, length=1, display="reserved")
    public int flags_Reserved() {
        return (this.flags() & 4) >> 3;
    }

    public Set<Flag> flagsEnum() {
        EnumSet<Flag> enumSet = EnumSet.noneOf(Flag.class);
        if (this.flags_DF() > 0) {
            enumSet.add(Flag.DF);
        }
        if (this.flags_MF() > 0) {
            enumSet.add(Flag.MF);
        }
        return enumSet;
    }

    public int hashCode() {
        return this.hashcode;
    }

    @Field(offset=4, length=4, format="%d")
    public int hlen() {
        return this.getUByte(0) & 0xF;
    }

    @FieldSetter
    public void hlen(int n) {
        int n2 = this.getUByte(0) & 0xF0;
        this.setUByte(0, n2 |= n & 0xF);
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String hlenDescription() {
        String string = "" + this.hlen() + " * 4 = " + this.hlen() * 4 + " bytes";
        return this.hlen() == 5 ? string + ", No Ip Options" : string + ", Ip Options Present";
    }

    @Field(offset=32, length=16, format="%x")
    public int id() {
        return this.getUShort(4);
    }

    @FieldSetter
    public void id(int n) {
        this.setUShort(4, n);
    }

    @Override
    public boolean isChecksumValid() {
        return Checksum.inChecksum(this, 0, this.size()) == 0;
    }

    public boolean isFragment() {
        return this.offset() != 0 || this.flags_MF() > 0;
    }

    @Field(offset=16, length=16, format="%d")
    public int length() {
        return this.getUShort(2);
    }

    @FieldSetter
    public void length(int n) {
        this.setUShort(2, n);
    }

    @Field(offset=51, length=13, format="%d")
    public int offset() {
        return this.getUShort(6) & 0x1FFF;
    }

    @FieldSetter
    public void offset(int n) {
        int n2 = this.getUShort(6) & 0xFFFFE000;
        this.setUShort(6, n2 |= n & 0x1FFF);
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String offsetDescription() {
        return this.offset() == 0 ? null : "" + this.offset() + " * 8 = " + this.offset() * 8 + " bytes";
    }

    @Override
    public boolean recalculateChecksum() {
        return this.checksum(this.calculateChecksum());
    }

    @Field(offset=96, length=32, format="#ip4#")
    @FlowKey(index=0)
    public byte[] source() {
        return this.getByteArray(12, 4);
    }

    @FieldSetter
    public void source(byte[] byArray) {
        this.setByteArray(12, byArray);
    }

    public byte[] sourceToByteArray(byte[] byArray) {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("address must be 4 byte long");
        }
        return this.getByteArray(12, byArray);
    }

    public int sourceToInt() {
        return this.getInt(12);
    }

    @Field(offset=8, length=8, format="%x", display="diffserv")
    public int tos() {
        return this.getUByte(1);
    }

    @FieldSetter
    public void tos(int n) {
        this.setUByte(1, n);
    }

    @Field(parent="tos", offset=2, length=6, display="code point")
    public int tos_Codepoint() {
        return (this.tos() & 0xFC) >> 2;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String tos_CodepointDescription() {
        return this.tos_Codepoint() > 0 ? "code point " + this.tos_Codepoint() : "not set";
    }

    @Field(parent="tos", offset=0, length=1, display="ECE bit")
    public int tos_ECE() {
        return (this.tos() & 1) >> 0;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String tos_ECEDescription() {
        return this.tos_ECE() > 0 ? "set" : "not set";
    }

    @Field(parent="tos", offset=1, length=1, display="ECN bit")
    public int tos_ECN() {
        return (this.tos() & 2) >> 1;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String tos_ECNDescription() {
        return this.tos_ECN() > 0 ? "set" : "not set";
    }

    @Field(offset=64, length=8, format="%d", description="time to live")
    public int ttl() {
        return this.getUByte(8);
    }

    @FieldSetter
    public void ttl(int n) {
        this.setUByte(8, n);
    }

    @Field(offset=72, length=8, format="%d")
    @FlowKey(index=1)
    public int type() {
        return this.getUByte(9);
    }

    @FieldSetter
    public void type(int n) {
        this.setUByte(9, n);
    }

    public void type(Ip4Type ip4Type) {
        this.setUByte(9, ip4Type.typeValues[0]);
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String typeDescription() {
        String string = Ip4Type.toString(this.type());
        return this.offset() == 0 ? "next: " + string : "ip fragment" + (string == null ? "" : " of " + string + " PDU");
    }

    public Ip4Type typeEnum() {
        return Ip4Type.valueOf(this.type());
    }

    @Field(offset=0, length=4, format="%d")
    public int version() {
        return this.getUByte(0) >> 4;
    }

    @FieldSetter
    public void version(int n) {
        this.setUByte(0, this.hlen() | n << 4);
    }

    @Header(id=18)
    public static class Traceroute
    extends IpOption {
        @Field(offset=8, length=8)
        public int length() {
            return this.getUByte(1);
        }

        @FieldSetter
        public void length(int n) {
            this.setUByte(1, n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Header(id=4)
    public static class Timestamp
    extends IpOption {
        public static final int FLAG_TIMESTAMP_WITH_IP = 1;
        public static final int FLAG_TIMESTAMPS_PRESPECIFIED = 2;
        public static final int MASK_FLAGS = 15;
        public static final int MASK_OVERFLOW = 240;

        @HeaderLength
        public static int headerLength(JBuffer jBuffer, int n) {
            return jBuffer.getUByte(1);
        }

        public byte[] address(int n) {
            if ((this.flags() & 1) == 0) {
                return null;
            }
            return this.getByteArray(n * 4 + 4, 4);
        }

        @Field(offset=32, format="%s")
        public Entry[] entries() {
            int n = this.flags();
            if ((n & 1) == 0) {
                return this.entriesTimestampOnly();
            }
            return this.entriesWithIp();
        }

        @Dynamic(value=Field.Property.LENGTH)
        public int entriesLength() {
            return (this.length() - 4) * 8;
        }

        private Entry[] entriesTimestampOnly() {
            int n = this.length() - 4;
            Entry[] entryArray = new Entry[n / 4];
            int n2 = 4;
            int n3 = 0;
            while (n2 < n) {
                Entry entry = entryArray[n3] = new Entry();
                entry.address = this.getByteArray(n2, 4);
                entry.timestamp = this.getUInt(n2 + 4);
                n2 += 8;
                ++n3;
            }
            return entryArray;
        }

        private Entry[] entriesWithIp() {
            int n = this.length() - 4;
            Entry[] entryArray = new Entry[n / 4];
            int n2 = 4;
            int n3 = 0;
            while (n2 < n) {
                Entry entry = entryArray[n3] = new Entry();
                entry.timestamp = this.getUInt(n2 + 4);
                n2 += 4;
                ++n3;
            }
            return entryArray;
        }

        @Field(offset=28, length=4)
        public int flags() {
            return this.getUByte(3) & 0xF;
        }

        @FieldSetter
        public void flags(int n) {
            this.setUByte(3, n & 0xF);
        }

        public Set<Flag> flagsEnum() {
            EnumSet<Flag> enumSet = EnumSet.noneOf(Flag.class);
            int n = this.flags();
            if ((n & 1) == 1) {
                enumSet.add(Flag.TIMESTAMP_WITH_IP);
            }
            if ((n & 2) == 2) {
                enumSet.add(Flag.TIMESTAMPS_PRESPECIFIED);
            }
            return enumSet;
        }

        @Field(offset=8, length=8)
        public int length() {
            return this.getUByte(1);
        }

        @FieldSetter
        public void length(int n) {
            this.setUByte(1, n);
        }

        @Field(offset=16, length=16)
        public int offset() {
            return this.getUByte(2);
        }

        @FieldSetter
        public void offset(int n) {
            this.setUByte(2, n);
        }

        @Field(offset=24, length=4)
        public int overflow() {
            return (this.getUByte(3) & 0xF0) >> 4;
        }

        @FieldSetter
        public void overflow(int n) {
            this.setUByte(3, n << 4 | this.flags());
        }

        public long timestamp(int n) {
            if ((this.flags() & 1) == 0) {
                return this.getUInt(n * 4 + 4);
            }
            return this.getUInt(n * 4 + 8);
        }

        public int timestampsCount() {
            if ((this.flags() & 1) == 0) {
                return (this.length() - 4) / 4;
            }
            return (this.length() - 4) / 8;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Flag {
            TIMESTAMP_WITH_IP,
            TIMESTAMPS_PRESPECIFIED;

        }

        public static class Entry {
            public byte[] address;
            public long timestamp;
        }
    }

    @Header(id=9)
    public static class StrictSourceRoute
    extends Routing {
    }

    @Header(id=8)
    public static class StreamId
    extends IpOption {
        @Field(offset=8, length=8)
        public int length() {
            return this.getUByte(1);
        }

        @FieldSetter
        public void length(int n) {
            this.setUByte(1, n);
        }

        @Field(offset=16, length=16, format="%x")
        public int streamId() {
            return this.getUShort(2);
        }

        @FieldSetter
        public void streamId(int n) {
            this.setUShort(2, n);
        }
    }

    @Header(id=21)
    public static class SelectiveDirectedBroadcastMode
    extends IpOption {
        @Field(offset=8, length=8)
        public int length() {
            return this.getUByte(1);
        }

        @FieldSetter
        public void length(int n) {
            this.setUByte(1, n);
        }
    }

    @Header(id=2)
    public static class Security
    extends IpOption {
        @Field(offset=32, length=16)
        public int compartments() {
            return this.getUShort(4);
        }

        @FieldSetter
        public void compartments(int n) {
            this.setUShort(4, n);
        }

        @Field(offset=64, length=24)
        public int control() {
            return this.getUShort(8) << 8 | this.getUByte(10);
        }

        @FieldSetter
        public void control(int n) {
            throw new UnsupportedOperationException("Not implemented yet");
        }

        @Field(offset=48, length=16)
        public int handling() {
            return this.getUShort(6);
        }

        @Field(offset=8, length=8)
        public int length() {
            return this.getUByte(1);
        }

        @FieldSetter
        public void length(int n) {
            this.setUByte(1, n);
        }

        @Field(offset=16, length=16)
        public int security() {
            return this.getUShort(2);
        }

        @FieldSetter
        public void security(int n) {
            this.setUShort(2, n);
        }

        public void security(SecurityType securityType) {
            this.security(securityType.type);
        }

        public SecurityType securityEnum() {
            return SecurityType.valueOf(this.security());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum SecurityType {
            CONFIDENTIAL(61749),
            EFTO(30874),
            MMMM(48205),
            PROG(24102),
            RESTRICTED(44819),
            SECRET(55176),
            UNCLASSIFIED(0);

            private final int type;

            public static SecurityType valueOf(int n) {
                for (SecurityType securityType : SecurityType.values()) {
                    if (securityType.getType() != n) continue;
                    return securityType;
                }
                return null;
            }

            private SecurityType(int n2) {
                this.type = n2;
            }

            public final int getType() {
                return this.type;
            }
        }
    }

    public static abstract class Routing
    extends IpOption {
        @FieldSetter
        public void address(byte[][] byArray) {
            for (int i = 0; i < byArray.length; ++i) {
                this.address(i, byArray[i]);
            }
        }

        public byte[] address(int n) {
            return this.getByteArray(n * 4 + 3, 4);
        }

        public void address(int n, byte[] byArray) {
            this.setByteArray(n * 4 + 3, byArray);
        }

        @Field(offset=24, length=0, format="#ip4[]#")
        public byte[][] addressArray() {
            byte[][] byArrayArray = new byte[this.addressCount()][];
            for (int i = 0; i < this.addressCount(); ++i) {
                byArrayArray[i] = this.address(i);
            }
            return byArrayArray;
        }

        public int addressCount() {
            return (this.length() - 3) / 4;
        }

        @Field(offset=8, length=8)
        public int length() {
            return this.getUByte(1);
        }

        @FieldSetter
        public void length(int n) {
            this.setUByte(1, n);
        }

        @Dynamic(value=Field.Property.DESCRIPTION)
        public String lengthDescription() {
            return "(" + this.length() + " - 3)/" + 4 + " = " + this.addressCount() + " routes";
        }

        @Field(offset=16, length=8)
        public int offset() {
            return this.getUByte(2);
        }

        @FieldSetter
        public void offset(int n) {
            this.setUByte(2, n);
        }

        @Dynamic(value=Field.Property.DESCRIPTION)
        public String offsetDescription() {
            return "offset points at route #" + (this.offset() / 4 - 1) + "";
        }
    }

    @Header(id=20)
    public static class RouterAlert
    extends IpOption {
        @Field(offset=16, length=16)
        public int action() {
            return super.getUShort(2);
        }

        @Dynamic(value=Field.Property.DESCRIPTION)
        public String actionDescription() {
            return this.actionEnum().toString();
        }

        public Action actionEnum() {
            return Action.valueOf(this.action());
        }

        @Field(offset=8, length=8)
        public int length() {
            return this.getUByte(1);
        }

        @FieldSetter
        public void length(int n) {
            this.setUByte(1, n);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Action {
            EXAMINE_PACKET(0);

            private final int value;

            public static Action valueOf(int n) {
                for (Action action : Action.values()) {
                    if (action.value != n) continue;
                    return action;
                }
                return null;
            }

            private Action(int n2) {
                this.value = n2;
            }

            public int value() {
                return this.value;
            }
        }
    }

    @Header(id=7)
    public static class RecordRoute
    extends Routing {
    }

    @Header(id=1)
    public static class NoOp
    extends IpOption {
    }

    @Header(id=12)
    public static class MtuReply
    extends IpOption {
        @Field(offset=8, length=8)
        public int length() {
            return this.getUByte(1);
        }

        @FieldSetter
        public void length(int n) {
            this.setUByte(1, n);
        }
    }

    @Header(id=11)
    public static class MtuProbe
    extends IpOption {
        @Field(offset=8, length=8)
        public int length() {
            return this.getUByte(1);
        }

        @FieldSetter
        public void length(int n) {
            this.setUByte(1, n);
        }
    }

    @Header(id=3)
    public static class LooseSourceRoute
    extends Routing {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class IpOption
    extends JSubHeader<Ip4> {
        @HeaderLength
        public static int headerLength(JBuffer jBuffer, int n) {
            return jBuffer.getUByte(1);
        }

        @Field(offset=0, length=8, format="%d")
        public int code() {
            return this.getUByte(0);
        }

        @FieldSetter
        public void code(int n) {
            this.setUByte(0, this.code() & 0xE0 | n & 0x1F);
        }

        @Field(parent="code", offset=5, length=2, display="class", format="%d")
        public int code_Class() {
            return (this.code() & 0x60) >> 5;
        }

        @Dynamic(value=Field.Property.DESCRIPTION)
        public String code_ClassDescription() {
            return this.code_ClassEnum().toString();
        }

        public CodeClass code_ClassEnum() {
            return CodeClass.valueOf(this.code_Class());
        }

        @Field(parent="code", offset=7, length=1, display="copy", format="%d")
        public int code_Copy() {
            return (this.code() & 0x80) >> 7;
        }

        @Dynamic(value=Field.Property.DESCRIPTION)
        public String code_CopyDescription() {
            return this.code_Copy() > 0 ? "copy to all fragments" : "do not copy to fragments";
        }

        @Field(parent="code", offset=0, length=5, display="type", format="%d")
        public int code_Type() {
            return this.code() & 0x1F;
        }

        @Dynamic(value=Field.Property.DESCRIPTION)
        public String code_TypeDescription() {
            return OptionCode.valueOf(this.code() & 0x1F).toString();
        }

        public OptionCode codeEnum() {
            return OptionCode.values()[this.getUByte(0) & 0x1F];
        }

        public void optionCode(OptionCode optionCode) {
            this.code(optionCode.ordinal());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum OptionCode {
            ADDRESS_EXTENSION(19),
            DYNAMIC_PACKET_STATE(23),
            ENCODE(15),
            END_OF_OPTION_LIST(0),
            EXPERIMENTAL_ACCESS_CONTROL(14),
            EXPERIMENTAL_FLOW_CONTROL(13),
            EXPERIMENTAL_MEASUREMENT(10),
            EXTENDED_IP(17),
            IMI_TRAFFIC_DESCRIPTOR(16),
            LOOSE_SOURCE_ROUTE(3),
            MTU_PROBE(11),
            MTU_REPLY(12),
            NO_OP(1),
            QUICK_START(25),
            RECORD_ROUTE(7),
            ROUTER_ALERT(20),
            SECURITY(2),
            SELECTIVE_DIRECTED_BROADCAST_MOST(21),
            STREAM_ID(8),
            STRICT_SOURCE_ROUTE(9),
            TIMESTAMP(4),
            TRACEROUTE(18),
            UNASSIGNED1(5),
            UNASSIGNED2(6),
            UPSTREAM_MULTICAST_PACKET(24);

            public final int id;

            public static OptionCode valueOf(int n) {
                for (OptionCode optionCode : OptionCode.values()) {
                    if (optionCode.id != n) continue;
                    return optionCode;
                }
                return null;
            }

            private OptionCode(int n2) {
                this.id = n2;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum CodeClass {
            CONTROL(0),
            DEBUG(2),
            RESERVED1(1),
            RESERVED2(3);

            private final int cl;

            public static CodeClass valueOf(int n) {
                for (CodeClass codeClass : CodeClass.values()) {
                    if (n != codeClass.cl) continue;
                    return codeClass;
                }
                return null;
            }

            private CodeClass(int n2) {
                this.cl = n2;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Ip4Type implements JHeaderType
    {
        AH("Authentication Header", 51),
        ANY_LOC("any host internal protocol", 61),
        ARGUS("ARGUS", 13),
        BBN_RCC_MON("BBN RCC Monitoring", 10),
        BNA("BNA", 49),
        CBT("CBT", 7),
        CHAOS("Chaos", 16),
        DCCP("Datagram Congestion Control Protocol", 33),
        DCN_MEAS("DCN Measurement Subsystems", 19),
        DDP("Datagram Delivery Protocol", 37),
        DSR("Dynamic Source Routing Protocol", 48),
        EGP("Exterior Gateway Protocol", 8),
        EMCON("EMCON", 14),
        ESP("Encap Security Payload", 50),
        FC("Fibre Channel", 133),
        GGP("Gateway-to-Gateway", 3),
        GRE("General Routing Encapsulation", 47),
        HMP("Host Monitoring", 20),
        HOPORT("IPv6 Hop-by-Hop Option", 0),
        I_NLSP("Integrated Net Layer Security  TUBA", 52),
        ICMP("Internet Control Message", 1),
        IDPR("Inter-Domain Policy Routing Protocol", 35),
        IDPR_CMTP("IDPR Control Message Transport Proto", 38),
        IDRP("Inter-Domain Routing Protocol", 45),
        IGMP("Internet Group Management", 2),
        IGP("any private interior gateway", 9),
        IL("IL Transport Protocol", 40),
        IP("IP in IP (encapsulation)", 4),
        IPIP("IP-within-IP Encapsulation Protocol", 94),
        IPv6("Ipv6", 41),
        IPv6_FRAG("Fragment Header for IPv6", 44),
        IPv6_ICMP("ICMP for IPv6", 58),
        IPv6_NoNxt("No Next Header for IPv6", 59),
        IPv6_Opts("Destination Options for IPv6", 60),
        IPv6_ROUTE("Ipv6", 43),
        IPX_In_IP("IPX in IP", 111),
        IRTP("Internet Reliable Transaction", 28),
        ISO_TP4("ISO Transport Protocol Class 4", 29),
        LEAF_1("Leaf-1", 25),
        LEAF_2("Leaf-2", 26),
        MERIT_INP("MERIT Internodal Protocol", 32),
        MFE_NSP("MFE Network Services Protocol", 31),
        MOBILE("IP Mobility", 55),
        MPLS_in_IP("MPLS-in-IP", 137),
        MUX("Multiplexing", 18),
        NARP("NBMA Address Resolution Protocol", 54),
        NETBLT("Bulk Data Transfer Protocol", 30),
        NVP_II("Network Voice Protocol", 11),
        PIM("Protocol Independent Multicast", 103),
        PRM("Packet Radio Measurement", 21),
        PUP("PUP", 12),
        RDP("Reliable Data Protocol", 27),
        RSVP("Reservation Protocol", 46),
        SDRP("Source Demand Routing Protocol", 42),
        SKIP("SKIP", 57),
        SCTP("SCTP", 132),
        ST("Stream", 5),
        STP("Schedule Transfer Protocol", 118),
        SWIPE("IP with Encryption", 53),
        TCP("Transmission Control", 6),
        THIRD_PC("Third Party Connect Protocol", 34),
        TLSP("Transport Layer Security Protocol", 56),
        TP_PLUS("TP++ Transport Protocol", 39),
        TRUNK_1("Trunk-1", 23),
        TRUNK_2("Trunk-2", 24),
        UDP("User Datagram", 17),
        XNET("Cross Net Debugger", 15),
        XNS_IDP("XEROX NS IDP", 22),
        XTP("XTP", 36);

        private final String description;
        private final int[] typeValues;

        public static String toString(int n) {
            for (Ip4Type ip4Type : Ip4Type.values()) {
                for (int n2 : ip4Type.typeValues) {
                    if (n2 != n) continue;
                    return ip4Type.description;
                }
            }
            return Integer.toString(n);
        }

        public static Ip4Type valueOf(int n) {
            for (Ip4Type ip4Type : Ip4Type.values()) {
                for (int n2 : ip4Type.typeValues) {
                    if (n2 != n) continue;
                    return ip4Type;
                }
            }
            return null;
        }

        private Ip4Type(int ... nArray) {
            this.typeValues = nArray;
            this.description = this.name().toLowerCase();
        }

        private Ip4Type(String string2, int ... nArray) {
            this.typeValues = nArray;
            this.description = string2;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final int[] getTypeValues() {
            return this.typeValues;
        }
    }

    @Header(id=16)
    public static class IMITrafficDescriptor
    extends IpOption {
        @Field(offset=8, length=8)
        public int length() {
            return this.getUByte(1);
        }

        @FieldSetter
        public void length(int n) {
            this.setUByte(1, n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flag {
        DF,
        MF;

    }

    @Header(id=17)
    public static class ExtendedIp
    extends IpOption {
        @Field(offset=8, length=8)
        public int length() {
            return this.getUByte(1);
        }

        @FieldSetter
        public void length(int n) {
            this.setUByte(1, n);
        }
    }

    @Header(id=10)
    public static class ExperimentalMeasurement
    extends IpOption {
        @Field(offset=8, length=8)
        public int length() {
            return this.getUByte(1);
        }

        @FieldSetter
        public void length(int n) {
            this.setUByte(1, n);
        }
    }

    @Header(id=13)
    public static class ExperimentalFlowControl
    extends IpOption {
        @Field(offset=8, length=8)
        public int length() {
            return this.getUByte(1);
        }

        @FieldSetter
        public void length(int n) {
            this.setUByte(1, n);
        }
    }

    @Header(id=14)
    public static class ExperimentalAccessControl
    extends IpOption {
        @Field(offset=8, length=8)
        public int length() {
            return this.getUByte(1);
        }

        @FieldSetter
        public void length(int n) {
            this.setUByte(1, n);
        }
    }

    @Header(id=15)
    public static class Encode
    extends IpOption {
        @Field(offset=8, length=8)
        public int length() {
            return this.getUByte(1);
        }

        @FieldSetter
        public void length(int n) {
            this.setUByte(1, n);
        }
    }

    @Header(id=19)
    public static class AddressExtension
    extends IpOption {
        @Field(offset=8, length=8)
        public int length() {
            return this.getUByte(1);
        }

        @FieldSetter
        public void length(int n) {
            this.setUByte(1, n);
        }
    }
}

