/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jnetpcap.JBufferHandler;
import org.jnetpcap.Pcap;
import org.jnetpcap.PcapBpfProgram;
import org.jnetpcap.PcapHeader;
import org.jnetpcap.PcapIf;
import org.jnetpcap.PcapTask;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.JPacketHandler;
import org.jnetpcap.packet.JPcapRecordBuffer;
import org.jnetpcap.packet.JRegistry;
import org.jnetpcap.packet.JScanner;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.PcapPacketHandler;

public class TestUtils
extends TestCase {
    public static final String AFS = "tests/test-afs.pcap";
    public static final Appendable DEV_NULL = new Appendable(){

        @Override
        public Appendable append(char c) throws IOException {
            return this;
        }

        @Override
        public Appendable append(CharSequence charSequence) throws IOException {
            return this;
        }

        @Override
        public Appendable append(CharSequence charSequence, int n, int n2) throws IOException {
            return this;
        }
    };
    public static final TestPrintStream DISCARD = new TestPrintStream(new OutputStream(){

        @Override
        public void write(byte[] byArray) throws IOException {
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
        }

        @Override
        public void write(int n) throws IOException {
        }
    });
    public static TestPrintStream err = new TestPrintStream(System.err);
    private static final Stack<TestPrintStream> errStack = new Stack();
    public static final String HTTP = "tests/test-http-jpeg.pcap";
    public static final String IP6 = "tests/test-ipv6.pcap";
    public static final String L2TP = "tests/test-l2tp.pcap";
    public static final String MYSQL = "tests/test-mysql.pcap";
    public static TestPrintStream out = new TestPrintStream(System.out);
    private static final Stack<TestPrintStream> outStack = new Stack();
    public static final String REASEMBLY = "tests/test-ipreassembly.pcap";
    public static final TestPrintStream SAVE = new TestPrintStream(new OutputStream(){

        @Override
        public void close() throws IOException {
            this.flush();
        }

        @Override
        public void flush() throws IOException {
            if (SAVE_BUFFER.size() != 0) {
                SAVE_BUFFER = new ByteArrayOutputStream();
            }
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            SAVE_BUFFER.write(byArray);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            SAVE_BUFFER.write(byArray, n, n2);
        }

        @Override
        public void write(int n) throws IOException {
            SAVE_BUFFER.write(n);
        }
    }){

        @Override
        public int size() {
            return SAVE_BUFFER.size();
        }

        public String toString() {
            return SAVE_BUFFER.toString();
        }
    };
    public static ByteArrayOutputStream SAVE_BUFFER = new ByteArrayOutputStream();
    public static final String VLAN = "tests/test-vlan.pcap";
    public static final int WIRESHARK_INDEX = 1;

    public static JFrame displayInFrame(JComponent jComponent) {
        JFrame jFrame = new JFrame("TestUtils");
        jFrame.getContentPane().add(jComponent);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setSize(new Dimension(400, 800));
        jFrame.setAlwaysOnTop(true);
        jFrame.pack();
        jFrame.setVisible(true);
        return jFrame;
    }

    public static String[] getDirFileList(File file, String string) {
        String[] stringArray = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".pcap");
            }
        });
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = file.toString() + "/" + stringArray[i];
        }
        return stringArray;
    }

    public static long getFileSizeAggregate(String[] stringArray) {
        int n = 0;
        for (String string : stringArray) {
            n = (int)((long)n + new File(string).length());
        }
        return n;
    }

    public static Iterable<PcapPacket> getIterable(final String string) {
        return new Iterable<PcapPacket>(){

            @Override
            public Iterator<PcapPacket> iterator() {
                return TestUtils.getPcapPacketIterator(string, 0, Integer.MAX_VALUE);
            }
        };
    }

    public static Iterable<PcapPacket> getIterable(final String string, final String string2) {
        return new Iterable<PcapPacket>(){

            @Override
            public Iterator<PcapPacket> iterator() {
                return TestUtils.getPcapPacketIterator(string, 0, Integer.MAX_VALUE, string2);
            }
        };
    }

    public static Iterable<JPacket> getJPacketIterable(final String string, final int n, final int n2) {
        return new Iterable<JPacket>(){

            @Override
            public Iterator<JPacket> iterator() {
                final Iterator<PcapPacket> iterator = TestUtils.getPcapPacketIterator(string, n, n2);
                return new Iterator<JPacket>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public JPacket next() {
                        return (JPacket)iterator.next();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PcapPacket getPcapPacket(String string, final int n) {
        StringBuilder stringBuilder = new StringBuilder();
        Pcap pcap = Pcap.openOffline(string, stringBuilder);
        if (pcap == null) {
            System.err.println(stringBuilder.toString());
            return null;
        }
        final PcapPacket pcapPacket = new PcapPacket(2048);
        try {
            pcap.loop(-1, new JBufferHandler<Pcap>(){
                int i = 0;

                @Override
                public void nextPacket(PcapHeader pcapHeader, JBuffer jBuffer, Pcap pcap) {
                    if (this.i++ == n) {
                        PcapPacket pcapPacket2 = new PcapPacket(pcapHeader, jBuffer);
                        pcapPacket2.scan(JRegistry.mapDLTToId(pcap.datalink()));
                        pcapPacket2.transferStateAndDataTo(pcapPacket);
                        pcap.breakloop();
                        return;
                    }
                }
            }, pcap);
        }
        finally {
            pcap.close();
        }
        return pcapPacket;
    }

    public static Iterator<PcapPacket> getPcapPacketIterator(String string, int n, int n2) {
        return TestUtils.getPcapPacketIterator(string, n, n2, null);
    }

    public static Iterator<PcapPacket> getPcapPacketIterator(String string, int n, int n2, String string2) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        Pcap pcap = Pcap.openOffline(string, stringBuilder);
        TestUtils.assertNotNull((Object)stringBuilder.toString());
        if (string2 != null) {
            object = new PcapBpfProgram();
            if (pcap.compile((PcapBpfProgram)object, string2, 0, -256) != 0) {
                System.err.printf("pcap filter %s: %s\n", pcap.getErr(), string2);
                return null;
            }
            pcap.setFilter((PcapBpfProgram)object);
        }
        object = new Exchanger();
        PcapTask<Pcap> pcapTask = new PcapTask<Pcap>(pcap, n2 - n, pcap, (Exchanger)object, n2, n){
            final /* synthetic */ Exchanger val$barrier;
            final /* synthetic */ int val$end;
            final /* synthetic */ int val$start;
            {
                this.val$barrier = exchanger;
                this.val$end = n2;
                this.val$start = n3;
                super(pcap, n, pcap2);
            }

            @Override
            public void run() {
                try {
                    this.val$barrier.exchange(null);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.result = this.pcap.loop(this.val$end - this.val$start, new PcapPacketHandler<Pcap>(){
                    int i = 0;

                    @Override
                    public void nextPacket(PcapPacket pcapPacket, Pcap pcap) {
                        Assert.assertNotNull((Object)pcapPacket);
                        if (this.i >= val$start) {
                            try {
                                val$barrier.exchange(pcapPacket);
                            }
                            catch (InterruptedException interruptedException) {
                                throw new IllegalStateException(interruptedException);
                            }
                        }
                        ++this.i;
                    }
                }, this.pcap);
                try {
                    this.val$barrier.exchange(null, 1000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception);
                }
            }
        };
        try {
            pcapTask.start();
            ((Exchanger)object).exchange(null);
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
        return new Iterator<PcapPacket>((Exchanger)object){
            PcapPacket packet;
            final /* synthetic */ Exchanger val$barrier;
            {
                this.val$barrier = exchanger;
            }

            @Override
            public boolean hasNext() {
                try {
                    this.packet = this.val$barrier.exchange(null, 1000L, TimeUnit.MILLISECONDS);
                    return this.packet != null;
                }
                catch (Exception exception) {
                    return false;
                }
            }

            @Override
            public PcapPacket next() {
                return this.packet;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Invalid operation for readonly offline read");
            }
        };
    }

    public static JPcapRecordBuffer loadAllPacketsFromFiles(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = (int)TestUtils.getFileSizeAggregate(stringArray);
        final JPcapRecordBuffer jPcapRecordBuffer = new JPcapRecordBuffer(n);
        for (String string : stringArray) {
            Pcap pcap = Pcap.openOffline(string, stringBuilder);
            TestUtils.assertNotNull((String)stringBuilder.toString(), (Object)pcap);
            try {
                pcap.loop(-1, new JBufferHandler<String>(){

                    @Override
                    public void nextPacket(PcapHeader pcapHeader, JBuffer jBuffer, String string) {
                        jPcapRecordBuffer.append(pcapHeader, jBuffer);
                    }
                }, string);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                throw runtimeException;
            }
            finally {
                pcap.close();
            }
        }
        jPcapRecordBuffer.close();
        return jPcapRecordBuffer;
    }

    public static JPcapRecordBuffer loadAllTestPackets() {
        String[] stringArray = TestUtils.getDirFileList(new File("tests"), ".pcap");
        JPcapRecordBuffer jPcapRecordBuffer = TestUtils.loadAllPacketsFromFiles(stringArray);
        return jPcapRecordBuffer;
    }

    public static JPcapRecordBuffer loadAllPacketsFromFile(String string) {
        JPcapRecordBuffer jPcapRecordBuffer = TestUtils.loadAllPacketsFromFiles(new String[]{string});
        return jPcapRecordBuffer;
    }

    public static void openLive(JPacketHandler<Pcap> jPacketHandler) {
        TestUtils.openLive(-1L, jPacketHandler);
    }

    public static void openLive(long l, JPacketHandler<Pcap> jPacketHandler) {
        ArrayList<PcapIf> arrayList = new ArrayList<PcapIf>();
        StringBuilder stringBuilder = new StringBuilder();
        if (Pcap.findAllDevs(arrayList, stringBuilder) != 0) {
            throw new IllegalStateException(stringBuilder.toString());
        }
        Pcap pcap = Pcap.openLive(((PcapIf)arrayList.get(0)).getName(), 65536, 1, 0, stringBuilder);
        if (pcap == null) {
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        pcap.loop((int)l, jPacketHandler, pcap);
    }

    public static Pcap openOffline(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Pcap pcap = Pcap.openOffline(string, stringBuilder);
        if (pcap == null) {
            System.err.println(stringBuilder.toString());
            return null;
        }
        return pcap;
    }

    public static void openOffline(String string, JPacketHandler<Pcap> jPacketHandler) {
        TestUtils.openOffline(string, jPacketHandler, null);
    }

    public static void openOffline(String string, JPacketHandler<Pcap> jPacketHandler, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        Pcap pcap = Pcap.openOffline(string, stringBuilder);
        if (pcap == null) {
            TestUtils.fail((String)stringBuilder.toString());
        }
        if (string2 != null) {
            PcapBpfProgram pcapBpfProgram = new PcapBpfProgram();
            if (pcap.compile(pcapBpfProgram, string2, 0, 0) != 0) {
                System.err.printf("pcap filter err: %s\n", pcap.getErr());
            }
            pcap.setFilter(pcapBpfProgram);
        }
        pcap.loop(-1, jPacketHandler, pcap);
        pcap.close();
    }

    public static int scanPacket(JPacket jPacket) {
        return TestUtils.scanPacket(jPacket, 1);
    }

    public static int scanPacket(JPacket jPacket, int n) {
        return JScanner.getThreadLocal().scan(jPacket, n);
    }

    protected native void pcapOfflineReset(Pcap var1);

    protected void setUp() throws Exception {
        outStack.push(out);
        errStack.push(err);
        SAVE.flush();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        out = outStack.pop();
        err = errStack.pop();
        super.tearDown();
    }

    public static class TestPrintStream
    extends PrintStream {
        public TestPrintStream(OutputStream outputStream) {
            super(outputStream);
        }

        public int size() {
            return 0;
        }
    }

    public static class ListOfPanels
    extends JPanel
    implements ListSelectionListener {
        private static final long serialVersionUID = 7220988908581321871L;
        private final JImagePanel imagePanel = new JImagePanel();
        private JList jlist;
        private final List<Entry> list = new ArrayList<Entry>(50);
        private DefaultListModel listModel;
        private final JPanel listPanel = new JPanel();

        public void add(Image image, String string) {
            final Entry entry = new Entry(image, string);
            this.list.add(entry);
            if (this.jlist != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ListOfPanels.this.listModel.addElement(entry);
                        ListOfPanels.this.jlist.setSelectedIndex(ListOfPanels.this.list.size() - 1);
                    }
                });
            }
        }

        public void init() {
            super.setPreferredSize(new Dimension(500, 800));
            super.setLayout(new BorderLayout());
            super.add((Component)this.listPanel, "North");
            super.add((Component)this.imagePanel, "Center");
            this.listModel = new DefaultListModel();
            this.jlist = new JList(this.listModel);
            this.jlist.addListSelectionListener(this);
            this.jlist.setSelectionMode(0);
            this.jlist.setLayoutOrientation(1);
            JScrollPane jScrollPane = new JScrollPane(this.jlist);
            jScrollPane.setPreferredSize(new Dimension(250, 400));
            jScrollPane.setAlignmentX(0.0f);
            this.listPanel.setLayout(new BoxLayout(this.listPanel, 3));
            JLabel jLabel = new JLabel("Captured Images");
            jLabel.setLabelFor(this.jlist);
            this.listPanel.add(jLabel);
            this.listPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            this.listPanel.add(jScrollPane);
            this.listPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.jlist.setBorder(BorderFactory.createBevelBorder(1));
            this.listPanel.setBorder(BorderFactory.createBevelBorder(0));
            this.listPanel.setPreferredSize(new Dimension(100, 200));
            if (!this.list.isEmpty()) {
                this.imagePanel.setImg(this.list.get(this.list.size() - 1).getImg());
            }
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = ((JList)listSelectionEvent.getSource()).getSelectedIndex();
            Image image = this.list.get(n).getImg();
            this.imagePanel.setImg(image);
            this.imagePanel.repaint();
        }

        private static class Entry {
            Image img;
            String text;

            public Entry(Image image, String string) {
                this.img = image;
                this.text = string;
            }

            public final Image getImg() {
                return this.img;
            }

            public final String getText() {
                return this.text;
            }

            public final void setImg(Image image) {
                this.img = image;
            }

            public final void setText(String string) {
                this.text = string;
            }

            public String toString() {
                return this.text;
            }
        }
    }

    public static class JImagePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private Image img;

        public JImagePanel() {
            super.setSize(new Dimension(100, 100));
        }

        public JImagePanel(Image image) {
            this.img = image;
        }

        public final Image getImg() {
            return this.img;
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.img == null || this.img.getWidth(this) == -1) {
                return;
            }
            Image image = this.img;
            if (image == null) {
                return;
            }
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = n / 2 - image.getWidth(this) / 2;
            int n4 = n2 / 2 - image.getHeight(this) / 2;
            graphics.drawImage(image, n3, n4, this);
            graphics.drawString("(w=" + image.getWidth(this) + ", h=" + image.getHeight(this) + ")", 20, 20);
        }

        public Image resizeToComponentSize(Image image) {
            int n = super.getWidth();
            int n2 = super.getHeight();
            int n3 = image.getWidth(this);
            int n4 = image.getHeight(this);
            if (n3 == -1 || n4 == -1) {
                return image;
            }
            if (n3 > n4 && n3 > n) {
                image = image.getScaledInstance(n, -1, 2);
            } else if (n4 > n2) {
                image = image.getScaledInstance(-1, n2, 2);
            }
            return image;
        }

        public final void setImg(Image image) {
            this.img = this.resizeToComponentSize(image);
        }
    }
}

