/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data;

import de.gematik.rbellogger.data.RbelElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public class RbelMultiValuedMapElement
extends RbelElement
implements Map<String, RbelElement> {
    private final Map<String, List<RbelElement>> values;

    public RbelMultiValuedMapElement() {
        this.values = new HashMap<String, List<RbelElement>>();
    }

    public RbelMultiValuedMapElement(Map<String, List<RbelElement>> values) {
        this.values = values;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.values.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsKey(value);
    }

    @Override
    public RbelElement get(Object key) {
        List<RbelElement> list = this.values.get(key);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public RbelElement put(String key, RbelElement value) {
        if (!this.values.containsKey(key)) {
            this.values.put(key, new ArrayList());
        }
        this.values.get(key).add(value);
        return value;
    }

    @Override
    public RbelElement remove(Object key) {
        List<RbelElement> list = this.values.remove(key);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public void putAll(Map<? extends String, ? extends RbelElement> m) {
        for (Map.Entry<? extends String, ? extends RbelElement> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.values.keySet();
    }

    @Override
    public Collection<RbelElement> values() {
        return this.values.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<String, RbelElement>> entrySet() {
        return this.values.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(value -> Pair.of((String)entry.getKey(), value))).collect(Collectors.toSet());
    }

    @Override
    public List<RbelElement> getChildNodes() {
        return this.values.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public String getContent() {
        return this.getRawMessage();
    }

    @Override
    public Set<Map.Entry<String, RbelElement>> getChildElements() {
        return this.values.entrySet().stream().flatMap(entry -> {
            if (((List)entry.getValue()).isEmpty()) {
                return Stream.of(new Pair[0]);
            }
            return ((List)entry.getValue()).stream().map(value -> Pair.of((String)entry.getKey(), value));
        }).collect(Collectors.toSet());
    }
}

