/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelJexlExecutor;
import de.gematik.rbellogger.data.RbelHttpMessage;
import de.gematik.rbellogger.exceptions.RbelPathException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.platform.commons.util.ReflectionUtils;
import wiremock.com.fasterxml.jackson.annotation.JsonIgnore;

public abstract class RbelElement {
    private final String uuid = UUID.randomUUID().toString();
    private String rawMessage;
    @JsonIgnore
    private transient RbelElement parentNode;
    private String note;

    public String getNote() {
        return this.note;
    }

    public RbelElement setNote(String note) {
        this.note = note;
        return this;
    }

    public String getRawMessage() {
        return this.rawMessage;
    }

    public RbelElement setRawMessage(String rawMessage) {
        this.rawMessage = rawMessage;
        return this;
    }

    public String getUuid() {
        return this.uuid;
    }

    public RbelElement getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(RbelElement parentNode) {
        this.parentNode = parentNode;
    }

    public abstract List<RbelElement> getChildNodes();

    public abstract String getContent();

    public boolean isNestedBoundary() {
        return true;
    }

    private List<Class> getAllRbelSuperclasses(Class startClass) {
        ArrayList<Class> classes = new ArrayList<Class>();
        Class currentClass = startClass;
        while (currentClass != null) {
            classes.add(currentClass);
            if (RbelElement.class.isAssignableFrom(currentClass = currentClass.getSuperclass())) continue;
            break;
        }
        return classes;
    }

    public Set<Map.Entry<String, RbelElement>> getChildElements() {
        return this.getAllRbelSuperclasses(this.getClass()).stream().flatMap(clazz -> Stream.of(clazz.getDeclaredFields())).filter(field -> ReflectionUtils.isNotStatic(field)).filter(field -> !field.getName().equals("parentNode")).filter(f -> RbelElement.class.isAssignableFrom(f.getType())).map(f -> {
            try {
                Object o = ReflectionUtils.tryToReadFieldValue(f, this).get();
                if (o == null) {
                    return Optional.empty();
                }
                return Optional.of(Pair.of(f.getName(), (RbelElement)o));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }).filter(Optional::isPresent).map(Optional::get).map(e -> (Map.Entry)e).collect(Collectors.toSet());
    }

    public void triggerPostConversionListener(RbelConverter context) {
        for (RbelElement element : this.getChildNodes()) {
            element.setParentNode(this);
            element.triggerPostConversionListener(context);
        }
        context.triggerPostConversionListenerFor(this);
    }

    public Map<String, RbelElement> traverseAndReturnNestedMembers() {
        return this.traverseAndReturnNestedMembers(this.getClass());
    }

    private Map<String, RbelElement> traverseAndReturnNestedMembers(Class<? extends RbelElement> identityClass) {
        HashMap<String, RbelElement> result = new HashMap<String, RbelElement>();
        for (Map.Entry<String, RbelElement> child : this.getChildElements()) {
            for (Map.Entry<String, RbelElement> grandchild : child.getValue().traverseAndReturnNestedMembersWithStopAtNextBoundary(identityClass).entrySet()) {
                if (grandchild.getKey().isEmpty()) {
                    result.put(child.getKey(), grandchild.getValue());
                    continue;
                }
                result.put(child.getKey() + "." + grandchild.getKey(), grandchild.getValue());
            }
        }
        return result;
    }

    private Map<String, RbelElement> traverseAndReturnNestedMembersWithStopAtNextBoundary(Class<? extends RbelElement> identityClass) {
        if (this.isNestedBoundary() && !this.getClass().isAssignableFrom(identityClass)) {
            return Map.of("", this);
        }
        return this.traverseAndReturnNestedMembers(identityClass);
    }

    public String findNodePath() {
        LinkedList<Optional<String>> keyList = new LinkedList<Optional<String>>();
        AtomicReference<RbelElement> ptr = new AtomicReference<RbelElement>(this);
        while (!(ptr.get() instanceof RbelHttpMessage)) {
            keyList.addFirst(ptr.get().getParentNode().getChildElements().stream().filter(entry -> entry.getValue() == ptr.get()).map(Map.Entry::getKey).findFirst());
            ptr.set(ptr.get().getParentNode());
        }
        return keyList.stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining("."));
    }

    public Optional<RbelElement> getFirst(String key) {
        return this.getChildElements().stream().filter(entry -> ((String)entry.getKey()).equals(key)).map(Map.Entry::getValue).findFirst();
    }

    public List<RbelElement> getAll(String key) {
        return this.getChildElements().stream().filter(entry -> ((String)entry.getKey()).equals(key)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public List<String> getChildKeys() {
        return this.getChildElements().stream().map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public Optional<String> findKeyInParentElement() {
        return Optional.of(this).map(RbelElement::getParentNode).filter(Objects::nonNull).stream().flatMap(parent -> parent.getChildElements().stream()).filter(e -> e.getValue() == this).map(Map.Entry::getKey).findFirst();
    }

    public List<RbelElement> findRbelPathMembers(String rbelPath) {
        if (!rbelPath.startsWith("$")) {
            throw new RbelPathException("RbelPath expressions always start with $.");
        }
        List<String> keys = List.of(rbelPath.substring(2).split("\\.(?![^\\(]*\\))"));
        List<RbelElement> candidates = List.of(this);
        for (String key : keys) {
            candidates = candidates.stream().map(element -> element.resolveRbelPathElement(key.trim())).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        }
        return candidates;
    }

    private List<RbelElement> resolveRbelPathElement(String key) {
        if (key.startsWith("[") && key.endsWith("]")) {
            String functionExpression = key.substring(1, key.length() - 1).trim();
            if (functionExpression.startsWith("'") && functionExpression.endsWith("'")) {
                return this.getAll(functionExpression.substring(1, functionExpression.length() - 1));
            }
            if (functionExpression.equals("*")) {
                return this.getChildNodes();
            }
            if (functionExpression.startsWith("?")) {
                if (functionExpression.startsWith("?(") && functionExpression.endsWith(")")) {
                    return this.findChildNodesByJexlExpression(functionExpression.substring(2, functionExpression.length() - 1));
                }
                throw new RbelPathException("Invalid JEXL-Expression encountered (Does not start with '?(' and end with ')'): " + functionExpression);
            }
            throw new RbelPathException("Unknown function expression encountered: " + key);
        }
        if (key.isEmpty()) {
            return this.findAllChildsRecursive();
        }
        if (key.equals("*")) {
            return this.getChildNodes();
        }
        return this.getAll(key);
    }

    protected List<RbelElement> findChildNodesByJexlExpression(String jexl) {
        RbelJexlExecutor executor = new RbelJexlExecutor();
        return this.getChildElements().stream().filter(candidate -> executor.matchesAsJexlExpression(candidate.getValue(), jexl, Optional.of((String)candidate.getKey()))).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private List<RbelElement> findAllChildsRecursive() {
        List<RbelElement> childNodes = this.getChildNodes();
        ArrayList<RbelElement> result = new ArrayList<RbelElement>(childNodes);
        childNodes.stream().map(RbelElement::findAllChildsRecursive).filter(Objects::nonNull).flatMap(Collection::stream).forEach(result::add);
        return result;
    }
}

