/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelJexlExecutor;
import de.gematik.rbellogger.data.RbelElement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelValueShader {
    private static final Logger log = LoggerFactory.getLogger(RbelValueShader.class);
    private final Map<String, String> jexlShadingMap = new HashMap<String, String>();
    private final Map<String, String> jexlNoteMap = new HashMap<String, String>();
    private final RbelJexlExecutor rbelJexlExecutor = new RbelJexlExecutor();

    public Optional<String> shadeValue(Object element, Optional<String> key) {
        return this.jexlShadingMap.entrySet().stream().filter(entry -> this.rbelJexlExecutor.matchesAsJexlExpression(element, (String)entry.getKey(), key)).map(entry -> String.format((String)entry.getValue(), this.toStringValue(element))).findFirst();
    }

    public void addNote(RbelElement element, RbelConverter converter) {
        this.jexlNoteMap.entrySet().stream().filter(entry -> this.rbelJexlExecutor.matchesAsJexlExpression(element, (String)entry.getKey(), element.findKeyInParentElement())).map(entry -> String.format((String)entry.getValue(), this.toStringValue(element))).findFirst().ifPresent(element::setNote);
    }

    private String toStringValue(Object value) {
        if (value instanceof RbelElement) {
            return ((RbelElement)value).getContent();
        }
        return value.toString();
    }

    public RbelValueShader addSimpleShadingCriterion(String attributeName, String stringFValue) {
        this.jexlShadingMap.put("key == '" + attributeName + "'", stringFValue);
        return this;
    }

    public RbelValueShader addJexlShadingCriterion(String jsonPathExpression, String stringFValue) {
        this.jexlShadingMap.put(jsonPathExpression, stringFValue);
        return this;
    }

    public RbelValueShader addJexlNoteCriterion(String jsonPathExpression, String stringFValue) {
        this.jexlNoteMap.put(jsonPathExpression, stringFValue);
        return this;
    }

    public BiConsumer<RbelElement, RbelConverter> getPostConversionListener() {
        return (element, converter) -> this.addNote((RbelElement)element, (RbelConverter)converter);
    }

    public Map<String, String> getJexlShadingMap() {
        return this.jexlShadingMap;
    }

    public Map<String, String> getJexlNoteMap() {
        return this.jexlNoteMap;
    }

    public RbelJexlExecutor getRbelJexlExecutor() {
        return this.rbelJexlExecutor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelValueShader)) {
            return false;
        }
        RbelValueShader other = (RbelValueShader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$jexlShadingMap = this.getJexlShadingMap();
        Map<String, String> other$jexlShadingMap = other.getJexlShadingMap();
        if (this$jexlShadingMap == null ? other$jexlShadingMap != null : !((Object)this$jexlShadingMap).equals(other$jexlShadingMap)) {
            return false;
        }
        Map<String, String> this$jexlNoteMap = this.getJexlNoteMap();
        Map<String, String> other$jexlNoteMap = other.getJexlNoteMap();
        if (this$jexlNoteMap == null ? other$jexlNoteMap != null : !((Object)this$jexlNoteMap).equals(other$jexlNoteMap)) {
            return false;
        }
        RbelJexlExecutor this$rbelJexlExecutor = this.getRbelJexlExecutor();
        RbelJexlExecutor other$rbelJexlExecutor = other.getRbelJexlExecutor();
        return !(this$rbelJexlExecutor == null ? other$rbelJexlExecutor != null : !((Object)this$rbelJexlExecutor).equals(other$rbelJexlExecutor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RbelValueShader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $jexlShadingMap = this.getJexlShadingMap();
        result = result * 59 + ($jexlShadingMap == null ? 43 : ((Object)$jexlShadingMap).hashCode());
        Map<String, String> $jexlNoteMap = this.getJexlNoteMap();
        result = result * 59 + ($jexlNoteMap == null ? 43 : ((Object)$jexlNoteMap).hashCode());
        RbelJexlExecutor $rbelJexlExecutor = this.getRbelJexlExecutor();
        result = result * 59 + ($rbelJexlExecutor == null ? 43 : ((Object)$rbelJexlExecutor).hashCode());
        return result;
    }

    public String toString() {
        return "RbelValueShader(jexlShadingMap=" + this.getJexlShadingMap() + ", jexlNoteMap=" + this.getJexlNoteMap() + ", rbelJexlExecutor=" + this.getRbelJexlExecutor() + ")";
    }

    public static class JexlMessage {
        public final String method;
        public final String url;
        public final boolean isRequest;
        public final boolean isResponse;
        public final Map<String, String> headers;
        public final String bodyAsString;
        public final RbelElement body;

        JexlMessage(String method, String url, boolean isRequest, boolean isResponse, Map<String, String> headers, String bodyAsString, RbelElement body) {
            this.method = method;
            this.url = url;
            this.isRequest = isRequest;
            this.isResponse = isResponse;
            this.headers = headers;
            this.bodyAsString = bodyAsString;
            this.body = body;
        }

        public static JexlMessageBuilder builder() {
            return new JexlMessageBuilder();
        }

        public String getMethod() {
            return this.method;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isRequest() {
            return this.isRequest;
        }

        public boolean isResponse() {
            return this.isResponse;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String getBodyAsString() {
            return this.bodyAsString;
        }

        public RbelElement getBody() {
            return this.body;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JexlMessage)) {
                return false;
            }
            JexlMessage other = (JexlMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            if (this.isRequest() != other.isRequest()) {
                return false;
            }
            if (this.isResponse() != other.isResponse()) {
                return false;
            }
            Map<String, String> this$headers = this.getHeaders();
            Map<String, String> other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            String this$bodyAsString = this.getBodyAsString();
            String other$bodyAsString = other.getBodyAsString();
            if (this$bodyAsString == null ? other$bodyAsString != null : !this$bodyAsString.equals(other$bodyAsString)) {
                return false;
            }
            RbelElement this$body = this.getBody();
            RbelElement other$body = other.getBody();
            return !(this$body == null ? other$body != null : !this$body.equals(other$body));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JexlMessage;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            result = result * 59 + (this.isRequest() ? 79 : 97);
            result = result * 59 + (this.isResponse() ? 79 : 97);
            Map<String, String> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            String $bodyAsString = this.getBodyAsString();
            result = result * 59 + ($bodyAsString == null ? 43 : $bodyAsString.hashCode());
            RbelElement $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            return result;
        }

        public String toString() {
            return "RbelValueShader.JexlMessage(method=" + this.getMethod() + ", url=" + this.getUrl() + ", isRequest=" + this.isRequest() + ", isResponse=" + this.isResponse() + ", headers=" + this.getHeaders() + ", bodyAsString=" + this.getBodyAsString() + ", body=" + this.getBody() + ")";
        }

        public static class JexlMessageBuilder {
            private String method;
            private String url;
            private boolean isRequest;
            private boolean isResponse;
            private Map<String, String> headers;
            private String bodyAsString;
            private RbelElement body;

            JexlMessageBuilder() {
            }

            public JexlMessageBuilder method(String method) {
                this.method = method;
                return this;
            }

            public JexlMessageBuilder url(String url) {
                this.url = url;
                return this;
            }

            public JexlMessageBuilder isRequest(boolean isRequest) {
                this.isRequest = isRequest;
                return this;
            }

            public JexlMessageBuilder isResponse(boolean isResponse) {
                this.isResponse = isResponse;
                return this;
            }

            public JexlMessageBuilder headers(Map<String, String> headers) {
                this.headers = headers;
                return this;
            }

            public JexlMessageBuilder bodyAsString(String bodyAsString) {
                this.bodyAsString = bodyAsString;
                return this;
            }

            public JexlMessageBuilder body(RbelElement body) {
                this.body = body;
                return this;
            }

            public JexlMessage build() {
                return new JexlMessage(this.method, this.url, this.isRequest, this.isResponse, this.headers, this.bodyAsString, this.body);
            }

            public String toString() {
                return "RbelValueShader.JexlMessage.JexlMessageBuilder(method=" + this.method + ", url=" + this.url + ", isRequest=" + this.isRequest + ", isResponse=" + this.isResponse + ", headers=" + this.headers + ", bodyAsString=" + this.bodyAsString + ", body=" + this.body + ")";
            }
        }
    }
}

