/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelJsonElement;
import de.gematik.rbellogger.data.RbelListElement;
import de.gematik.rbellogger.data.RbelMapElement;
import de.gematik.rbellogger.data.RbelNullElement;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class RbelJsonConverter
implements RbelConverterPlugin {
    @Override
    public boolean canConvertElement(RbelElement rbel, RbelConverter context) {
        try {
            return !JsonParser.parseString(rbel.getContent()).isJsonPrimitive();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public RbelElement convertElement(RbelElement rbel, RbelConverter context) {
        return this.jsonElementToRbelElement(JsonParser.parseString(rbel.getContent()), context);
    }

    private RbelElement jsonElementToRbelElement(JsonElement jsonElement, RbelConverter context) {
        if (jsonElement.isJsonObject()) {
            RbelMapElement rbelMapElement = new RbelMapElement(jsonElement.getAsJsonObject().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> this.jsonElementToRbelElement((JsonElement)v.getValue(), context))));
            rbelMapElement.getChildNodes().forEach(child -> child.setParentNode(rbelMapElement));
            rbelMapElement.getChildNodes().forEach(context::triggerPostConversionListenerFor);
            return new RbelJsonElement(rbelMapElement, jsonElement.toString());
        }
        if (jsonElement.isJsonArray()) {
            RbelJsonElement rbelJsonElement = new RbelJsonElement(new RbelListElement(StreamSupport.stream(jsonElement.getAsJsonArray().spliterator(), false).map(el -> this.jsonElementToRbelElement((JsonElement)el, context)).collect(Collectors.toList())), jsonElement.toString());
            rbelJsonElement.getJsonElement().getChildNodes().forEach(child -> child.setParentNode(rbelJsonElement.getJsonElement()));
            rbelJsonElement.getJsonElement().getChildNodes().forEach(context::triggerPostConversionListenerFor);
            return rbelJsonElement;
        }
        if (jsonElement.isJsonPrimitive()) {
            RbelElement element = context.convertMessage(jsonElement.getAsString());
            if (jsonElement.getAsJsonPrimitive().isString()) {
                element.setRawMessage("\"" + jsonElement.getAsString() + "\"");
            } else {
                element.setRawMessage(jsonElement.getAsString());
            }
            return element;
        }
        return new RbelNullElement();
    }
}

