/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHttpMessage;
import de.gematik.rbellogger.data.RbelHttpRequest;
import de.gematik.rbellogger.data.RbelHttpResponse;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.MapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelJexlExecutor {
    private static final Logger log = LoggerFactory.getLogger(RbelJexlExecutor.class);
    private static final Map<Integer, JexlExpression> JEXL_EXPRESSION_CACHE = new HashMap<Integer, JexlExpression>();
    public static boolean ACTIVATE_JEXL_DEBUGGING = false;

    public boolean matchesAsJexlExpression(Object element, String jexlExpression, Optional<String> key) {
        try {
            JexlExpression expression = this.buildExpression(jexlExpression);
            MapContext mapContext = this.buildJexlMapContext(element, key);
            Boolean result = Optional.of(expression.evaluate(mapContext)).filter(Boolean.class::isInstance).map(Boolean.class::cast).orElse(false);
            if (result.booleanValue() && ACTIVATE_JEXL_DEBUGGING) {
                if (element instanceof RbelElement) {
                    log.info("Found match: '{}' with path {} matches '{}'", element, ((RbelElement)element).findNodePath(), jexlExpression);
                } else {
                    log.info("Found match: '{}' matches '{}'", element, (Object)jexlExpression);
                }
            }
            return result;
        }
        catch (Exception e) {
            if (ACTIVATE_JEXL_DEBUGGING) {
                log.debug("Error during Jexl-Evaluation.", e);
            }
            return false;
        }
    }

    private JexlExpression buildExpression(String jexlExpression) {
        int hashCode = jexlExpression.hashCode();
        if (JEXL_EXPRESSION_CACHE.containsKey(hashCode)) {
            return JEXL_EXPRESSION_CACHE.get(hashCode);
        }
        JexlExpression expression = new JexlBuilder().create().createExpression(jexlExpression);
        JEXL_EXPRESSION_CACHE.put(hashCode, expression);
        return expression;
    }

    private MapContext buildJexlMapContext(Object element, Optional<String> key) {
        MapContext mapContext = new MapContext();
        Optional<RbelElement> parentElement = this.getParentElement(element);
        mapContext.set("element", element);
        mapContext.set("parent", parentElement.orElse(null));
        mapContext.set("message", this.findMessage(element).map(this::convertToJexlMessage).orElse(null));
        mapContext.set("request", this.tryToFindRequestMessage(element).map(this::convertToJexlMessage).orElse(null));
        mapContext.set("key", key.or(() -> this.tryToFindKeyFromParentMap(element, parentElement)).orElse(null));
        mapContext.set("path", Optional.ofNullable(element).filter(RbelElement.class::isInstance).map(RbelElement.class::cast).map(RbelElement::findNodePath).orElse(null));
        mapContext.set("type", element.getClass().getSimpleName());
        if (element instanceof RbelElement) {
            mapContext.set("content", ((RbelElement)element).getContent());
        } else {
            mapContext.set("content", element.toString());
        }
        return mapContext;
    }

    private Optional<RbelHttpRequest> tryToFindRequestMessage(Object element) {
        RbelElement ptr;
        if (!(element instanceof RbelElement)) {
            return Optional.empty();
        }
        for (ptr = (RbelElement)element; ptr != null && !(ptr instanceof RbelHttpMessage); ptr = ptr.getParentNode()) {
        }
        if (ptr == null) {
            return Optional.empty();
        }
        if (ptr instanceof RbelHttpRequest) {
            return Optional.of((RbelHttpRequest)ptr);
        }
        return Optional.ofNullable(((RbelHttpResponse)ptr).getRequest());
    }

    private JexlMessage convertToJexlMessage(RbelHttpMessage element) {
        return JexlMessage.builder().isRequest(element instanceof RbelHttpRequest).isResponse(element instanceof RbelHttpResponse).method(element instanceof RbelHttpRequest ? ((RbelHttpRequest)element).getMethod() : null).url(element instanceof RbelHttpRequest ? ((RbelHttpRequest)element).getPath().getOriginalUrl() : null).bodyAsString(element.getBody().getContent()).body(element.getBody()).headers(element.getHeader().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), entry -> ((RbelElement)entry.getValue()).getContent()))).build();
    }

    private Optional<RbelHttpMessage> findMessage(Object element) {
        RbelElement ptr;
        if (!(element instanceof RbelElement)) {
            return Optional.empty();
        }
        for (ptr = (RbelElement)element; ptr != null && !(ptr instanceof RbelHttpMessage) && ptr.getParentNode() != ptr; ptr = ptr.getParentNode()) {
        }
        if (ptr instanceof RbelHttpMessage) {
            return Optional.of((RbelHttpMessage)ptr);
        }
        return Optional.empty();
    }

    private Optional<RbelElement> getParentElement(Object element) {
        return Optional.ofNullable(element).filter(RbelElement.class::isInstance).map(RbelElement.class::cast).map(RbelElement::getParentNode);
    }

    private Optional<String> tryToFindKeyFromParentMap(Object element, Optional<RbelElement> parent) {
        return parent.stream().map(RbelElement::getChildElements).flatMap(Collection::stream).filter(entry -> entry.getValue() == element).map(Map.Entry::getKey).findFirst();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelJexlExecutor)) {
            return false;
        }
        RbelJexlExecutor other = (RbelJexlExecutor)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof RbelJexlExecutor;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "RbelJexlExecutor()";
    }

    public static class JexlMessage {
        public final String method;
        public final String url;
        public final boolean isRequest;
        public final boolean isResponse;
        public final Map<String, String> headers;
        public final String bodyAsString;
        public final RbelElement body;

        JexlMessage(String method, String url, boolean isRequest, boolean isResponse, Map<String, String> headers, String bodyAsString, RbelElement body) {
            this.method = method;
            this.url = url;
            this.isRequest = isRequest;
            this.isResponse = isResponse;
            this.headers = headers;
            this.bodyAsString = bodyAsString;
            this.body = body;
        }

        public static JexlMessageBuilder builder() {
            return new JexlMessageBuilder();
        }

        public String getMethod() {
            return this.method;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isRequest() {
            return this.isRequest;
        }

        public boolean isResponse() {
            return this.isResponse;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String getBodyAsString() {
            return this.bodyAsString;
        }

        public RbelElement getBody() {
            return this.body;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JexlMessage)) {
                return false;
            }
            JexlMessage other = (JexlMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            if (this.isRequest() != other.isRequest()) {
                return false;
            }
            if (this.isResponse() != other.isResponse()) {
                return false;
            }
            Map<String, String> this$headers = this.getHeaders();
            Map<String, String> other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            String this$bodyAsString = this.getBodyAsString();
            String other$bodyAsString = other.getBodyAsString();
            if (this$bodyAsString == null ? other$bodyAsString != null : !this$bodyAsString.equals(other$bodyAsString)) {
                return false;
            }
            RbelElement this$body = this.getBody();
            RbelElement other$body = other.getBody();
            return !(this$body == null ? other$body != null : !this$body.equals(other$body));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JexlMessage;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            result = result * 59 + (this.isRequest() ? 79 : 97);
            result = result * 59 + (this.isResponse() ? 79 : 97);
            Map<String, String> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            String $bodyAsString = this.getBodyAsString();
            result = result * 59 + ($bodyAsString == null ? 43 : $bodyAsString.hashCode());
            RbelElement $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            return result;
        }

        public String toString() {
            return "RbelJexlExecutor.JexlMessage(method=" + this.getMethod() + ", url=" + this.getUrl() + ", isRequest=" + this.isRequest() + ", isResponse=" + this.isResponse() + ", headers=" + this.getHeaders() + ", bodyAsString=" + this.getBodyAsString() + ", body=" + this.getBody() + ")";
        }

        public static class JexlMessageBuilder {
            private String method;
            private String url;
            private boolean isRequest;
            private boolean isResponse;
            private Map<String, String> headers;
            private String bodyAsString;
            private RbelElement body;

            JexlMessageBuilder() {
            }

            public JexlMessageBuilder method(String method) {
                this.method = method;
                return this;
            }

            public JexlMessageBuilder url(String url) {
                this.url = url;
                return this;
            }

            public JexlMessageBuilder isRequest(boolean isRequest) {
                this.isRequest = isRequest;
                return this;
            }

            public JexlMessageBuilder isResponse(boolean isResponse) {
                this.isResponse = isResponse;
                return this;
            }

            public JexlMessageBuilder headers(Map<String, String> headers) {
                this.headers = headers;
                return this;
            }

            public JexlMessageBuilder bodyAsString(String bodyAsString) {
                this.bodyAsString = bodyAsString;
                return this;
            }

            public JexlMessageBuilder body(RbelElement body) {
                this.body = body;
                return this;
            }

            public JexlMessage build() {
                return new JexlMessage(this.method, this.url, this.isRequest, this.isResponse, this.headers, this.bodyAsString, this.body);
            }

            public String toString() {
                return "RbelJexlExecutor.JexlMessage.JexlMessageBuilder(method=" + this.method + ", url=" + this.url + ", isRequest=" + this.isRequest + ", isResponse=" + this.isResponse + ", headers=" + this.headers + ", bodyAsString=" + this.bodyAsString + ", body=" + this.body + ")";
            }
        }
    }
}

