/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHttpResponse;
import de.gematik.rbellogger.data.RbelMultiValuedMapElement;
import de.gematik.rbellogger.data.RbelStringElement;
import de.gematik.rbellogger.util.RbelException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RbelCurlHttpMessageConverter
implements RbelConverterPlugin {
    @Override
    public boolean canConvertElement(RbelElement rbel, RbelConverter context) {
        return rbel instanceof RbelStringElement && rbel.getContent().startsWith("HTTP");
    }

    @Override
    public RbelElement convertElement(RbelElement rbel, RbelConverter context) {
        Map<String, List<RbelElement>> headerMap;
        String eol = RbelCurlHttpMessageConverter.findLineSeparator(rbel.getContent());
        int separator = rbel.getContent().indexOf(eol + eol) + 2 * eol.length();
        if (separator == -1) {
            eol = "\n";
            separator = rbel.getContent().indexOf(eol + eol) + 2 * eol.length();
        }
        if ((headerMap = Arrays.stream(rbel.getContent().substring(0, separator).split(eol)).filter(line -> !line.isEmpty() && !line.startsWith("HTTP")).map(line -> this.parseStringToKeyValuePair((String)line, context)).collect(Collectors.groupingBy(e -> (String)e.getKey(), Collectors.mapping(Map.Entry::getValue, Collectors.toList())))).containsKey("Transfer-Encoding") && headerMap.get("Transfer-Encoding") != null && !headerMap.get("Transfer-Encoding").isEmpty() && headerMap.get("Transfer-Encoding").get(0).getContent().equals("chunked")) {
            separator = rbel.getContent().indexOf(eol, separator) + eol.length();
        }
        String bodyStr = rbel.getContent().substring(separator);
        return RbelHttpResponse.builder().header(new RbelMultiValuedMapElement(headerMap)).body(context.convertMessage(new RbelStringElement(bodyStr))).responseCode(Integer.parseInt(rbel.getContent().split("\\s")[1])).build();
    }

    public static String findLineSeparator(String content) {
        if (content.contains("\r\n")) {
            return "\r\n";
        }
        if (content.contains("\n")) {
            return "\n";
        }
        throw new RbelException("Could not determine linebreak for '" + content + "'");
    }

    protected AbstractMap.SimpleImmutableEntry<String, RbelElement> parseStringToKeyValuePair(String line, RbelConverter context) {
        int colon = line.indexOf(58);
        if (colon == -1) {
            throw new IllegalArgumentException("Header malformed: '" + line + "'");
        }
        String key = line.substring(0, colon).trim();
        RbelStringElement el = new RbelStringElement(line.substring(colon + 1).trim());
        return new AbstractMap.SimpleImmutableEntry<String, RbelElement>(key, context.convertMessage(el));
    }
}

