/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelJwtSignature;
import java.util.List;

public class RbelJwtElement
extends RbelElement {
    private final RbelElement header;
    private final RbelElement body;
    private final RbelJwtSignature signature;

    @Override
    public List<RbelElement> getChildNodes() {
        return List.of(this.header, this.body, this.signature);
    }

    @Override
    public String getContent() {
        return "Header Claims:\n" + this.header.getContent() + "\n\nBody Claims:  \n" + this.body.getContent();
    }

    public static RbelJwtElementBuilder builder() {
        return new RbelJwtElementBuilder();
    }

    public RbelElement getHeader() {
        return this.header;
    }

    public RbelElement getBody() {
        return this.body;
    }

    public RbelJwtSignature getSignature() {
        return this.signature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelJwtElement)) {
            return false;
        }
        RbelJwtElement other = (RbelJwtElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RbelElement this$header = this.getHeader();
        RbelElement other$header = other.getHeader();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        RbelElement this$body = this.getBody();
        RbelElement other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        RbelJwtSignature this$signature = this.getSignature();
        RbelJwtSignature other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !((Object)this$signature).equals(other$signature));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RbelJwtElement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RbelElement $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        RbelElement $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        RbelJwtSignature $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : ((Object)$signature).hashCode());
        return result;
    }

    public String toString() {
        return "RbelJwtElement(header=" + this.getHeader() + ", body=" + this.getBody() + ", signature=" + this.getSignature() + ")";
    }

    public RbelJwtElement(RbelElement header, RbelElement body, RbelJwtSignature signature) {
        this.header = header;
        this.body = body;
        this.signature = signature;
    }

    public static class RbelJwtElementBuilder {
        private RbelElement header;
        private RbelElement body;
        private RbelJwtSignature signature;

        RbelJwtElementBuilder() {
        }

        public RbelJwtElementBuilder header(RbelElement header) {
            this.header = header;
            return this;
        }

        public RbelJwtElementBuilder body(RbelElement body) {
            this.body = body;
            return this;
        }

        public RbelJwtElementBuilder signature(RbelJwtSignature signature) {
            this.signature = signature;
            return this;
        }

        public RbelJwtElement build() {
            return new RbelJwtElement(this.header, this.body, this.signature);
        }

        public String toString() {
            return "RbelJwtElement.RbelJwtElementBuilder(header=" + this.header + ", body=" + this.body + ", signature=" + this.signature + ")";
        }
    }
}

