/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHttpMessage;
import de.gematik.rbellogger.data.RbelHttpRequest;
import de.gematik.rbellogger.data.RbelHttpResponse;
import de.gematik.rbellogger.data.RbelMapElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.MapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelValueShader {
    private static final Logger log = LoggerFactory.getLogger(RbelValueShader.class);
    private final Map<String, String> jexlShadingMap = new HashMap<String, String>();
    private final Map<String, String> jexlNoteMap = new HashMap<String, String>();
    private final Map<Integer, JexlExpression> jexlExpressionCache = new HashMap<Integer, JexlExpression>();
    private RbelConverter rbelConverter;
    private boolean activateJexlDebugging = false;

    public Optional<String> shadeValue(Object element, Optional<String> key) {
        return this.jexlShadingMap.entrySet().stream().filter(entry -> this.matchesAsJexlExpression(element, (String)entry.getKey(), key)).map(entry -> String.format((String)entry.getValue(), this.toStringValue(element))).findFirst();
    }

    public void addNote(RbelElement element, RbelConverter converter) {
        this.rbelConverter = converter;
        this.jexlNoteMap.entrySet().stream().filter(entry -> this.matchesAsJexlExpression(element, (String)entry.getKey(), Optional.empty())).map(entry -> String.format((String)entry.getValue(), this.toStringValue(element))).findFirst().ifPresent(element::setNote);
    }

    private boolean matchesAsJexlExpression(Object element, String jexlExpression, Optional<String> key) {
        try {
            JexlExpression expression = this.buildExpression(jexlExpression);
            MapContext mapContext = this.buildJexlMapContext(element, key);
            return Optional.of(expression.evaluate((JexlContext)mapContext)).filter(Boolean.class::isInstance).map(Boolean.class::cast).orElse(false);
        }
        catch (Exception e) {
            if (this.activateJexlDebugging) {
                log.info("Error during Jexl-Evaluation.", (Throwable)e);
            }
            return false;
        }
    }

    private JexlExpression buildExpression(String jexlExpression) {
        int hashCode = jexlExpression.hashCode();
        if (this.jexlExpressionCache.containsKey(hashCode)) {
            return this.jexlExpressionCache.get(hashCode);
        }
        JexlExpression expression = new JexlBuilder().create().createExpression(jexlExpression);
        this.jexlExpressionCache.put(hashCode, expression);
        return expression;
    }

    private MapContext buildJexlMapContext(Object element, Optional<String> key) {
        MapContext mapContext = new MapContext();
        Optional<RbelElement> parentElement = this.getParentElement(element);
        mapContext.set("element", element);
        mapContext.set("parent", parentElement.orElse(null));
        mapContext.set("message", this.findMessage(element).map(this::convertToJexlMessage).orElse(null));
        mapContext.set("request", this.tryToFindRequestMessage(element).map(this::convertToJexlMessage).orElse(null));
        mapContext.set("key", key.or(() -> this.tryToFindKeyFromParentMap(element, parentElement)).orElse(null));
        mapContext.set("path", Optional.ofNullable(element).filter(RbelElement.class::isInstance).map(RbelElement.class::cast).map(RbelElement::findNodePath).orElse(null));
        return mapContext;
    }

    private Optional<RbelHttpRequest> tryToFindRequestMessage(Object element) {
        if (this.rbelConverter == null || this.rbelConverter.getMessageHistory().size() < 2) {
            return Optional.empty();
        }
        RbelElement rbelElement = this.rbelConverter.getMessageHistory().get(this.rbelConverter.getMessageHistory().size() - 2);
        if (rbelElement instanceof RbelHttpRequest) {
            return Optional.of((RbelHttpRequest)rbelElement);
        }
        return Optional.empty();
    }

    private JexlMessage convertToJexlMessage(RbelHttpMessage element) {
        return JexlMessage.builder().isRequest(element instanceof RbelHttpRequest).isResponse(element instanceof RbelHttpResponse).method(element instanceof RbelHttpRequest ? ((RbelHttpRequest)element).getMethod() : null).url(element instanceof RbelHttpRequest ? ((RbelHttpRequest)element).getPath().getOriginalUrl() : null).bodyAsString(element.getBody().getContent()).body(element.getBody()).headers(element.getHeader().getElementMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((RbelElement)entry.getValue()).getContent()))).build();
    }

    private Optional<RbelHttpMessage> findMessage(Object element) {
        RbelElement ptr;
        if (!(element instanceof RbelElement)) {
            return Optional.empty();
        }
        for (ptr = (RbelElement)element; ptr != null && !(ptr instanceof RbelHttpMessage) && ptr.getParentNode() != ptr; ptr = ptr.getParentNode()) {
        }
        if (ptr instanceof RbelHttpMessage) {
            return Optional.of((RbelHttpMessage)ptr);
        }
        return Optional.empty();
    }

    private Optional<RbelElement> getParentElement(Object element) {
        return Optional.ofNullable(element).filter(RbelElement.class::isInstance).map(RbelElement.class::cast).map(RbelElement::getParentNode);
    }

    private Optional<String> tryToFindKeyFromParentMap(Object element, Optional<RbelElement> parent) {
        return parent.filter(RbelMapElement.class::isInstance).map(RbelMapElement.class::cast).map(RbelMapElement::getElementMap).stream().map(Map::entrySet).flatMap(Collection::stream).filter(entry -> entry.getValue() == element).map(Map.Entry::getKey).findFirst();
    }

    private String toStringValue(Object value) {
        if (value instanceof RbelElement) {
            return ((RbelElement)value).getContent();
        }
        return value.toString();
    }

    public RbelValueShader addSimpleShadingCriterion(String attributeName, String stringFValue) {
        this.jexlShadingMap.put("key == '" + attributeName + "'", stringFValue);
        return this;
    }

    public RbelValueShader addJexlShadingCriterion(String jsonPathExpression, String stringFValue) {
        this.jexlShadingMap.put(jsonPathExpression, stringFValue);
        return this;
    }

    public RbelValueShader addJexlNoteCriterion(String jsonPathExpression, String stringFValue) {
        this.jexlNoteMap.put(jsonPathExpression, stringFValue);
        return this;
    }

    public BiConsumer<RbelElement, RbelConverter> getPostConversionListener() {
        return (element, converter) -> this.addNote((RbelElement)element, (RbelConverter)converter);
    }

    public static class JexlMessage {
        public final String method;
        public final String url;
        public final boolean isRequest;
        public final boolean isResponse;
        public final Map<String, String> headers;
        public final String bodyAsString;
        public final RbelElement body;

        JexlMessage(String method, String url, boolean isRequest, boolean isResponse, Map<String, String> headers, String bodyAsString, RbelElement body) {
            this.method = method;
            this.url = url;
            this.isRequest = isRequest;
            this.isResponse = isResponse;
            this.headers = headers;
            this.bodyAsString = bodyAsString;
            this.body = body;
        }

        public static JexlMessageBuilder builder() {
            return new JexlMessageBuilder();
        }

        public String getMethod() {
            return this.method;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isRequest() {
            return this.isRequest;
        }

        public boolean isResponse() {
            return this.isResponse;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String getBodyAsString() {
            return this.bodyAsString;
        }

        public RbelElement getBody() {
            return this.body;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JexlMessage)) {
                return false;
            }
            JexlMessage other = (JexlMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            if (this.isRequest() != other.isRequest()) {
                return false;
            }
            if (this.isResponse() != other.isResponse()) {
                return false;
            }
            Map<String, String> this$headers = this.getHeaders();
            Map<String, String> other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            String this$bodyAsString = this.getBodyAsString();
            String other$bodyAsString = other.getBodyAsString();
            if (this$bodyAsString == null ? other$bodyAsString != null : !this$bodyAsString.equals(other$bodyAsString)) {
                return false;
            }
            RbelElement this$body = this.getBody();
            RbelElement other$body = other.getBody();
            return !(this$body == null ? other$body != null : !this$body.equals(other$body));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JexlMessage;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            result = result * 59 + (this.isRequest() ? 79 : 97);
            result = result * 59 + (this.isResponse() ? 79 : 97);
            Map<String, String> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            String $bodyAsString = this.getBodyAsString();
            result = result * 59 + ($bodyAsString == null ? 43 : $bodyAsString.hashCode());
            RbelElement $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            return result;
        }

        public String toString() {
            return "RbelValueShader.JexlMessage(method=" + this.getMethod() + ", url=" + this.getUrl() + ", isRequest=" + this.isRequest() + ", isResponse=" + this.isResponse() + ", headers=" + this.getHeaders() + ", bodyAsString=" + this.getBodyAsString() + ", body=" + this.getBody() + ")";
        }

        public static class JexlMessageBuilder {
            private String method;
            private String url;
            private boolean isRequest;
            private boolean isResponse;
            private Map<String, String> headers;
            private String bodyAsString;
            private RbelElement body;

            JexlMessageBuilder() {
            }

            public JexlMessageBuilder method(String method) {
                this.method = method;
                return this;
            }

            public JexlMessageBuilder url(String url) {
                this.url = url;
                return this;
            }

            public JexlMessageBuilder isRequest(boolean isRequest) {
                this.isRequest = isRequest;
                return this;
            }

            public JexlMessageBuilder isResponse(boolean isResponse) {
                this.isResponse = isResponse;
                return this;
            }

            public JexlMessageBuilder headers(Map<String, String> headers) {
                this.headers = headers;
                return this;
            }

            public JexlMessageBuilder bodyAsString(String bodyAsString) {
                this.bodyAsString = bodyAsString;
                return this;
            }

            public JexlMessageBuilder body(RbelElement body) {
                this.body = body;
                return this;
            }

            public JexlMessage build() {
                return new JexlMessage(this.method, this.url, this.isRequest, this.isResponse, this.headers, this.bodyAsString, this.body);
            }

            public String toString() {
                return "RbelValueShader.JexlMessage.JexlMessageBuilder(method=" + this.method + ", url=" + this.url + ", isRequest=" + this.isRequest + ", isResponse=" + this.isResponse + ", headers=" + this.headers + ", bodyAsString=" + this.bodyAsString + ", body=" + this.body + ")";
            }
        }
    }
}

